/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.content.Context;
import android.support.transition.R;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

final class ScenePort {
    Runnable mEnterAction;
    Runnable mExitAction;
    private Context mContext;
    private int mLayoutId = -1;
    private ViewGroup mSceneRoot;
    private View mLayout;

    public ScenePort(ViewGroup sceneRoot) {
        this.mSceneRoot = sceneRoot;
    }

    private ScenePort(ViewGroup sceneRoot, int layoutId, Context context) {
        this.mContext = context;
        this.mSceneRoot = sceneRoot;
        this.mLayoutId = layoutId;
    }

    public ScenePort(ViewGroup sceneRoot, View layout) {
        this.mSceneRoot = sceneRoot;
        this.mLayout = layout;
    }

    public static ScenePort getSceneForLayout(ViewGroup sceneRoot, int layoutId, Context context) {
        return new ScenePort(sceneRoot, layoutId, context);
    }

    static void setCurrentScene(View view, ScenePort scene) {
        view.setTag(R.id.transition_current_scene, (Object)scene);
    }

    static ScenePort getCurrentScene(View view) {
        return (ScenePort)view.getTag(R.id.transition_current_scene);
    }

    public ViewGroup getSceneRoot() {
        return this.mSceneRoot;
    }

    public void exit() {
        if (ScenePort.getCurrentScene((View)this.mSceneRoot) == this && this.mExitAction != null) {
            this.mExitAction.run();
        }
    }

    public void enter() {
        if (this.mLayoutId > 0 || this.mLayout != null) {
            this.getSceneRoot().removeAllViews();
            if (this.mLayoutId > 0) {
                LayoutInflater.from((Context)this.mContext).inflate(this.mLayoutId, this.mSceneRoot);
            } else {
                this.mSceneRoot.addView(this.mLayout);
            }
        }
        if (this.mEnterAction != null) {
            this.mEnterAction.run();
        }
        ScenePort.setCurrentScene((View)this.mSceneRoot, this);
    }

    public void setEnterAction(Runnable action) {
        this.mEnterAction = action;
    }

    public void setExitAction(Runnable action) {
        this.mExitAction = action;
    }

    boolean isCreatedFromLayoutResource() {
        return this.mLayoutId > 0;
    }
}

