/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.support.annotation.NonNull;
import android.support.transition.Transition;
import android.support.transition.TransitionValues;
import android.support.transition.ViewGroupUtils;
import android.support.transition.Visibility;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;

public class Fade
extends Visibility {
    private static final String LOG_TAG = "Fade";
    private static final String PROPNAME_SCREEN_X = "android:fade:screenX";
    private static final String PROPNAME_SCREEN_Y = "android:fade:screenY";
    public static final int IN = 1;
    public static final int OUT = 2;
    private int mFadingMode;

    public Fade(int fadingMode) {
        this.mFadingMode = fadingMode;
    }

    public Fade() {
        this(3);
    }

    private Animator createAnimation(View view, float startAlpha, float endAlpha, AnimatorListenerAdapter listener) {
        if (startAlpha == endAlpha) {
            if (listener != null) {
                listener.onAnimationEnd(null);
            }
            return null;
        }
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{startAlpha, endAlpha});
        if (listener != null) {
            anim.addListener((Animator.AnimatorListener)listener);
        }
        return anim;
    }

    private void captureValues(TransitionValues transitionValues) {
        int[] loc = new int[2];
        transitionValues.view.getLocationOnScreen(loc);
        transitionValues.values.put(PROPNAME_SCREEN_X, loc[0]);
        transitionValues.values.put(PROPNAME_SCREEN_Y, loc[1]);
    }

    @Override
    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mFadingMode & 1) != 1 || endValues == null) {
            return null;
        }
        final View endView = endValues.view;
        endView.setAlpha(0.0f);
        Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
            boolean mCanceled = false;
            float mPausedAlpha;

            @Override
            public void onTransitionCancel(@NonNull Transition transition) {
                endView.setAlpha(1.0f);
                this.mCanceled = true;
            }

            @Override
            public void onTransitionEnd(@NonNull Transition transition) {
                if (!this.mCanceled) {
                    endView.setAlpha(1.0f);
                }
            }

            @Override
            public void onTransitionPause(@NonNull Transition transition) {
                this.mPausedAlpha = endView.getAlpha();
                endView.setAlpha(1.0f);
            }

            @Override
            public void onTransitionResume(@NonNull Transition transition) {
                endView.setAlpha(this.mPausedAlpha);
            }
        };
        this.addListener(transitionListener);
        return this.createAnimation(endView, 0.0f, 1.0f, null);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mFadingMode & 2) != 2) {
            return null;
        }
        View view = null;
        View startView = startValues != null ? startValues.view : null;
        View endView = endValues != null ? endValues.view : null;
        View overlayView = null;
        View viewToKeep = null;
        if (endView == null || endView.getParent() == null) {
            if (endView != null) {
                view = overlayView = endView;
            } else if (startView != null) {
                View startParent;
                int id2;
                if (startView.getParent() == null) {
                    view = overlayView = startView;
                } else if (startView.getParent() instanceof View && startView.getParent().getParent() == null && (id2 = (startParent = (View)startView.getParent()).getId()) != -1 && sceneRoot.findViewById(id2) != null && this.mCanRemoveViews) {
                    view = overlayView = startView;
                }
            }
        } else if (endVisibility == 4) {
            viewToKeep = view = endView;
        } else if (startView == endView) {
            viewToKeep = view = endView;
        } else {
            overlayView = view = startView;
        }
        final int finalVisibility = endVisibility;
        if (overlayView != null) {
            int screenX = (Integer)startValues.values.get(PROPNAME_SCREEN_X);
            int screenY = (Integer)startValues.values.get(PROPNAME_SCREEN_Y);
            int[] loc = new int[2];
            sceneRoot.getLocationOnScreen(loc);
            ViewCompat.offsetLeftAndRight((View)overlayView, (int)(screenX - loc[0] - overlayView.getLeft()));
            ViewCompat.offsetTopAndBottom((View)overlayView, (int)(screenY - loc[1] - overlayView.getTop()));
            ViewGroupUtils.getOverlay(sceneRoot).add(overlayView);
            float startAlpha = 1.0f;
            float endAlpha = 0.0f;
            final View finalView = view;
            final View finalOverlayView = overlayView;
            final View finalViewToKeep = viewToKeep;
            final ViewGroup finalSceneRoot = sceneRoot;
            AnimatorListenerAdapter endListener = new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    finalView.setAlpha(1.0f);
                    if (finalViewToKeep != null) {
                        finalViewToKeep.setVisibility(finalVisibility);
                    }
                    if (finalOverlayView != null) {
                        ViewGroupUtils.getOverlay(finalSceneRoot).remove(finalOverlayView);
                    }
                }
            };
            return this.createAnimation(view, 1.0f, endAlpha, endListener);
        }
        if (viewToKeep != null) {
            viewToKeep.setVisibility(0);
            float startAlpha = 1.0f;
            float endAlpha = 0.0f;
            final View finalView = view;
            final View finalOverlayView = overlayView;
            final View finalViewToKeep = viewToKeep;
            final ViewGroup finalSceneRoot = sceneRoot;
            AnimatorListenerAdapter endListener = new AnimatorListenerAdapter(){
                boolean mCanceled = false;
                float mPausedAlpha = -1.0f;

                public void onAnimationCancel(Animator animation) {
                    this.mCanceled = true;
                    if (this.mPausedAlpha >= 0.0f) {
                        finalView.setAlpha(this.mPausedAlpha);
                    }
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.mCanceled) {
                        finalView.setAlpha(1.0f);
                    }
                    if (finalViewToKeep != null && !this.mCanceled) {
                        finalViewToKeep.setVisibility(finalVisibility);
                    }
                    if (finalOverlayView != null) {
                        ViewGroupUtils.getOverlay(finalSceneRoot).remove(finalOverlayView);
                    }
                }
            };
            return this.createAnimation(view, 1.0f, endAlpha, endListener);
        }
        return null;
    }
}

