/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.transition.RectEvaluator;
import android.support.transition.Transition;
import android.support.transition.TransitionValues;
import android.support.transition.ViewUtils;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

public class ChangeClipBounds
extends Transition {
    private static final String PROPNAME_CLIP = "android:clipBounds:clip";
    private static final String PROPNAME_BOUNDS = "android:clipBounds:bounds";
    private static final String[] sTransitionProperties = new String[]{"android:clipBounds:clip"};

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public ChangeClipBounds() {
    }

    public ChangeClipBounds(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private void captureValues(TransitionValues values) {
        View view = values.view;
        if (view.getVisibility() == 8) {
            return;
        }
        Rect clip = ViewCompat.getClipBounds((View)view);
        values.values.put(PROPNAME_CLIP, clip);
        if (clip == null) {
            Rect bounds = new Rect(0, 0, view.getWidth(), view.getHeight());
            values.values.put(PROPNAME_BOUNDS, bounds);
        }
    }

    @Override
    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public Animator createAnimator(@NonNull ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null || endValues == null || !startValues.values.containsKey(PROPNAME_CLIP) || !endValues.values.containsKey(PROPNAME_CLIP)) {
            return null;
        }
        Rect start = (Rect)startValues.values.get(PROPNAME_CLIP);
        Rect end = (Rect)endValues.values.get(PROPNAME_CLIP);
        if (start == null && end == null) {
            return null;
        }
        if (start == null) {
            start = (Rect)startValues.values.get(PROPNAME_BOUNDS);
        } else if (end == null) {
            end = (Rect)endValues.values.get(PROPNAME_BOUNDS);
        }
        if (start.equals((Object)end)) {
            return null;
        }
        ViewCompat.setClipBounds((View)endValues.view, (Rect)start);
        RectEvaluator evaluator = new RectEvaluator(new Rect());
        return ObjectAnimator.ofObject((Object)endValues.view, ViewUtils.CLIP_BOUNDS, (TypeEvaluator)evaluator, (Object[])new Rect[]{start, end});
    }
}

