/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.support.annotation.NonNull;
import android.support.transition.Styleable;
import android.support.transition.Transition;
import android.support.transition.TransitionValues;
import android.support.transition.ViewUtils;
import android.support.transition.Visibility;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import org.xmlpull.v1.XmlPullParser;

public class Fade
extends Visibility {
    private static final String PROPNAME_TRANSITION_ALPHA = "android:fade:transitionAlpha";
    private static final String LOG_TAG = "Fade";
    public static final int IN = 1;
    public static final int OUT = 2;

    public Fade(int fadingMode) {
        this.setMode(fadingMode);
    }

    public Fade() {
    }

    public Fade(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, Styleable.FADE);
        int fadingMode = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)((XmlResourceParser)attrs), (String)"fadingMode", (int)0, (int)this.getMode());
        this.setMode(fadingMode);
        a.recycle();
    }

    @Override
    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        transitionValues.values.put(PROPNAME_TRANSITION_ALPHA, Float.valueOf(ViewUtils.getTransitionAlpha(transitionValues.view)));
    }

    private Animator createAnimation(final View view, float startAlpha, float endAlpha) {
        if (startAlpha == endAlpha) {
            return null;
        }
        ViewUtils.setTransitionAlpha(view, startAlpha);
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)view, ViewUtils.TRANSITION_ALPHA, (float[])new float[]{endAlpha});
        FadeAnimatorListener listener = new FadeAnimatorListener(view);
        anim.addListener((Animator.AnimatorListener)listener);
        this.addListener(new Transition.TransitionListenerAdapter(){

            @Override
            public void onTransitionEnd(@NonNull Transition transition) {
                ViewUtils.setTransitionAlpha(view, 1.0f);
                ViewUtils.clearNonTransitionAlpha(view);
                transition.removeListener(this);
            }
        });
        return anim;
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        float startAlpha = Fade.getStartAlpha(startValues, 0.0f);
        if (startAlpha == 1.0f) {
            startAlpha = 0.0f;
        }
        return this.createAnimation(view, startAlpha, 1.0f);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        ViewUtils.saveNonTransitionAlpha(view);
        float startAlpha = Fade.getStartAlpha(startValues, 1.0f);
        return this.createAnimation(view, startAlpha, 0.0f);
    }

    private static float getStartAlpha(TransitionValues startValues, float fallbackValue) {
        Float startAlphaFloat;
        float startAlpha = fallbackValue;
        if (startValues != null && (startAlphaFloat = (Float)startValues.values.get(PROPNAME_TRANSITION_ALPHA)) != null) {
            startAlpha = startAlphaFloat.floatValue();
        }
        return startAlpha;
    }

    private static class FadeAnimatorListener
    extends AnimatorListenerAdapter {
        private final View mView;
        private boolean mLayerTypeChanged = false;

        FadeAnimatorListener(View view) {
            this.mView = view;
        }

        public void onAnimationStart(Animator animation) {
            if (ViewCompat.hasOverlappingRendering((View)this.mView) && this.mView.getLayerType() == 0) {
                this.mLayerTypeChanged = true;
                this.mView.setLayerType(2, null);
            }
        }

        public void onAnimationEnd(Animator animation) {
            ViewUtils.setTransitionAlpha(this.mView, 1.0f);
            if (this.mLayerTypeChanged) {
                this.mView.setLayerType(0, null);
            }
        }
    }
}

