/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.support.annotation.NonNull;
import android.support.transition.ArcMotion;
import android.support.transition.AutoTransition;
import android.support.transition.ChangeBounds;
import android.support.transition.ChangeClipBounds;
import android.support.transition.ChangeImageTransform;
import android.support.transition.ChangeTransform;
import android.support.transition.Explode;
import android.support.transition.Fade;
import android.support.transition.PathMotion;
import android.support.transition.PatternPathMotion;
import android.support.transition.Scene;
import android.support.transition.Slide;
import android.support.transition.Styleable;
import android.support.transition.Transition;
import android.support.transition.TransitionManager;
import android.support.transition.TransitionSet;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v4.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import android.view.ViewGroup;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TransitionInflater {
    private static final Class<?>[] CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class};
    private static final ArrayMap<String, Constructor> CONSTRUCTORS = new ArrayMap();
    private final Context mContext;

    private TransitionInflater(@NonNull Context context) {
        this.mContext = context;
    }

    public static TransitionInflater from(Context context) {
        return new TransitionInflater(context);
    }

    public Transition inflateTransition(int resource) {
        try (XmlResourceParser parser = this.mContext.getResources().getXml(resource);){
            Transition transition = this.createTransitionFromXml((XmlPullParser)parser, Xml.asAttributeSet((XmlPullParser)parser), null);
            return transition;
        }
    }

    public TransitionManager inflateTransitionManager(int resource, ViewGroup sceneRoot) {
        try (XmlResourceParser parser = this.mContext.getResources().getXml(resource);){
            TransitionManager transitionManager = this.createTransitionManagerFromXml((XmlPullParser)parser, Xml.asAttributeSet((XmlPullParser)parser), sceneRoot);
            return transitionManager;
        }
    }

    private Transition createTransitionFromXml(XmlPullParser parser, AttributeSet attrs, Transition parent) throws XmlPullParserException, IOException {
        int type;
        TransitionSet transitionSet;
        Transition transition = null;
        int depth = parser.getDepth();
        TransitionSet transitionSet2 = transitionSet = parent instanceof TransitionSet ? (TransitionSet)parent : null;
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if ("fade".equals(name)) {
                transition = new Fade(this.mContext, attrs);
            } else if ("changeBounds".equals(name)) {
                transition = new ChangeBounds(this.mContext, attrs);
            } else if ("slide".equals(name)) {
                transition = new Slide(this.mContext, attrs);
            } else if ("explode".equals(name)) {
                transition = new Explode(this.mContext, attrs);
            } else if ("changeImageTransform".equals(name)) {
                transition = new ChangeImageTransform(this.mContext, attrs);
            } else if ("changeTransform".equals(name)) {
                transition = new ChangeTransform(this.mContext, attrs);
            } else if ("changeClipBounds".equals(name)) {
                transition = new ChangeClipBounds(this.mContext, attrs);
            } else if ("autoTransition".equals(name)) {
                transition = new AutoTransition(this.mContext, attrs);
            } else if ("transitionSet".equals(name)) {
                transition = new TransitionSet(this.mContext, attrs);
            } else if ("transition".equals(name)) {
                transition = (Transition)this.createCustom(attrs, Transition.class, "transition");
            } else if ("targets".equals(name)) {
                this.getTargetIds(parser, attrs, parent);
            } else if ("arcMotion".equals(name)) {
                if (parent == null) {
                    throw new RuntimeException("Invalid use of arcMotion element");
                }
                parent.setPathMotion(new ArcMotion(this.mContext, attrs));
            } else if ("pathMotion".equals(name)) {
                if (parent == null) {
                    throw new RuntimeException("Invalid use of pathMotion element");
                }
                parent.setPathMotion((PathMotion)this.createCustom(attrs, PathMotion.class, "pathMotion"));
            } else if ("patternPathMotion".equals(name)) {
                if (parent == null) {
                    throw new RuntimeException("Invalid use of patternPathMotion element");
                }
                parent.setPathMotion(new PatternPathMotion(this.mContext, attrs));
            } else {
                throw new RuntimeException("Unknown scene name: " + parser.getName());
            }
            if (transition == null) continue;
            if (!parser.isEmptyElementTag()) {
                this.createTransitionFromXml(parser, attrs, transition);
            }
            if (transitionSet != null) {
                transitionSet.addTransition(transition);
                transition = null;
                continue;
            }
            if (parent == null) continue;
            throw new InflateException("Could not add transition to another transition.");
        }
        return transition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createCustom(AttributeSet attrs, Class expectedType, String tag) {
        String className = attrs.getAttributeValue(null, "class");
        if (className == null) {
            throw new InflateException(tag + " tag must have a 'class' attribute");
        }
        try {
            ArrayMap<String, Constructor> arrayMap = CONSTRUCTORS;
            synchronized (arrayMap) {
                Class c;
                Constructor constructor = (Constructor)CONSTRUCTORS.get((Object)className);
                if (constructor == null && (c = this.mContext.getClassLoader().loadClass(className).asSubclass(expectedType)) != null) {
                    constructor = c.getConstructor(CONSTRUCTOR_SIGNATURE);
                    constructor.setAccessible(true);
                    CONSTRUCTORS.put((Object)className, constructor);
                }
                return constructor.newInstance(this.mContext, attrs);
            }
        }
        catch (Exception e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, (Throwable)e);
        }
    }

    private void getTargetIds(XmlPullParser parser, AttributeSet attrs, Transition transition) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("target")) {
                TypedArray a = this.mContext.obtainStyledAttributes(attrs, Styleable.TRANSITION_TARGET);
                int id2 = TypedArrayUtils.getNamedResourceId((TypedArray)a, (XmlPullParser)parser, (String)"targetId", (int)1, (int)0);
                if (id2 != 0) {
                    transition.addTarget(id2);
                } else {
                    id2 = TypedArrayUtils.getNamedResourceId((TypedArray)a, (XmlPullParser)parser, (String)"excludeId", (int)2, (int)0);
                    if (id2 != 0) {
                        transition.excludeTarget(id2, true);
                    } else {
                        String transitionName = TypedArrayUtils.getNamedString((TypedArray)a, (XmlPullParser)parser, (String)"targetName", (int)4);
                        if (transitionName != null) {
                            transition.addTarget(transitionName);
                        } else {
                            transitionName = TypedArrayUtils.getNamedString((TypedArray)a, (XmlPullParser)parser, (String)"excludeName", (int)5);
                            if (transitionName != null) {
                                transition.excludeTarget(transitionName, true);
                            } else {
                                String className = TypedArrayUtils.getNamedString((TypedArray)a, (XmlPullParser)parser, (String)"excludeClass", (int)3);
                                try {
                                    Class<?> clazz;
                                    if (className != null) {
                                        clazz = Class.forName(className);
                                        transition.excludeTarget(clazz, true);
                                    } else {
                                        className = TypedArrayUtils.getNamedString((TypedArray)a, (XmlPullParser)parser, (String)"targetClass", (int)0);
                                        if (className != null) {
                                            clazz = Class.forName(className);
                                            transition.addTarget(clazz);
                                        }
                                    }
                                }
                                catch (ClassNotFoundException e) {
                                    a.recycle();
                                    throw new RuntimeException("Could not create " + className, e);
                                }
                            }
                        }
                    }
                }
                a.recycle();
                continue;
            }
            throw new RuntimeException("Unknown scene name: " + parser.getName());
        }
    }

    private TransitionManager createTransitionManagerFromXml(XmlPullParser parser, AttributeSet attrs, ViewGroup sceneRoot) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        TransitionManager transitionManager = null;
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("transitionManager")) {
                transitionManager = new TransitionManager();
                continue;
            }
            if (name.equals("transition") && transitionManager != null) {
                this.loadTransition(attrs, parser, sceneRoot, transitionManager);
                continue;
            }
            throw new RuntimeException("Unknown scene name: " + parser.getName());
        }
        return transitionManager;
    }

    private void loadTransition(AttributeSet attrs, XmlPullParser parser, ViewGroup sceneRoot, TransitionManager transitionManager) throws Resources.NotFoundException {
        Transition transition;
        Scene toScene;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, Styleable.TRANSITION_MANAGER);
        int transitionId = TypedArrayUtils.getNamedResourceId((TypedArray)a, (XmlPullParser)parser, (String)"transition", (int)2, (int)-1);
        int fromId = TypedArrayUtils.getNamedResourceId((TypedArray)a, (XmlPullParser)parser, (String)"fromScene", (int)0, (int)-1);
        Scene fromScene = fromId < 0 ? null : Scene.getSceneForLayout(sceneRoot, fromId, this.mContext);
        int toId = TypedArrayUtils.getNamedResourceId((TypedArray)a, (XmlPullParser)parser, (String)"toScene", (int)1, (int)-1);
        Scene scene = toScene = toId < 0 ? null : Scene.getSceneForLayout(sceneRoot, toId, this.mContext);
        if (transitionId >= 0 && (transition = this.inflateTransition(transitionId)) != null) {
            if (toScene == null) {
                throw new RuntimeException("No toScene for transition ID " + transitionId);
            }
            if (fromScene == null) {
                transitionManager.setTransition(toScene, transition);
            } else {
                transitionManager.setTransition(fromScene, toScene, transition);
            }
        }
        a.recycle();
    }
}

