/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.transition.ViewOverlayImpl;
import android.support.transition.ViewUtilsApi14;
import android.support.transition.ViewUtilsApi18;
import android.support.transition.ViewUtilsApi19;
import android.support.transition.ViewUtilsApi21;
import android.support.transition.ViewUtilsApi22;
import android.support.transition.ViewUtilsImpl;
import android.support.transition.WindowIdImpl;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.util.Property;
import android.view.View;
import java.lang.reflect.Field;

class ViewUtils {
    private static final ViewUtilsImpl IMPL = Build.VERSION.SDK_INT >= 22 ? new ViewUtilsApi22() : (Build.VERSION.SDK_INT >= 21 ? new ViewUtilsApi21() : (Build.VERSION.SDK_INT >= 19 ? new ViewUtilsApi19() : (Build.VERSION.SDK_INT >= 18 ? new ViewUtilsApi18() : new ViewUtilsApi14())));
    private static final String TAG = "ViewUtils";
    private static Field sViewFlagsField;
    private static boolean sViewFlagsFieldFetched;
    private static final int VISIBILITY_MASK = 12;
    static final Property<View, Float> TRANSITION_ALPHA;
    static final Property<View, Rect> CLIP_BOUNDS;

    ViewUtils() {
    }

    static ViewOverlayImpl getOverlay(@NonNull View view) {
        return IMPL.getOverlay(view);
    }

    static WindowIdImpl getWindowId(@NonNull View view) {
        return IMPL.getWindowId(view);
    }

    static void setTransitionAlpha(@NonNull View view, float alpha) {
        IMPL.setTransitionAlpha(view, alpha);
    }

    static float getTransitionAlpha(@NonNull View view) {
        return IMPL.getTransitionAlpha(view);
    }

    static void saveNonTransitionAlpha(@NonNull View view) {
        IMPL.saveNonTransitionAlpha(view);
    }

    static void clearNonTransitionAlpha(@NonNull View view) {
        IMPL.clearNonTransitionAlpha(view);
    }

    static void setTransitionVisibility(@NonNull View view, int visibility) {
        ViewUtils.fetchViewFlagsField();
        if (sViewFlagsField != null) {
            try {
                int viewFlags = sViewFlagsField.getInt(view);
                sViewFlagsField.setInt(view, viewFlags & 0xFFFFFFF3 | visibility);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    static void transformMatrixToGlobal(@NonNull View view, @NonNull Matrix matrix) {
        IMPL.transformMatrixToGlobal(view, matrix);
    }

    static void transformMatrixToLocal(@NonNull View view, @NonNull Matrix matrix) {
        IMPL.transformMatrixToLocal(view, matrix);
    }

    static void setAnimationMatrix(@NonNull View v, @NonNull Matrix m) {
        IMPL.setAnimationMatrix(v, m);
    }

    static void setLeftTopRightBottom(@NonNull View v, int left, int top, int right, int bottom) {
        IMPL.setLeftTopRightBottom(v, left, top, right, bottom);
    }

    private static void fetchViewFlagsField() {
        if (!sViewFlagsFieldFetched) {
            try {
                sViewFlagsField = View.class.getDeclaredField("mViewFlags");
                sViewFlagsField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.i((String)TAG, (String)"fetchViewFlagsField: ");
            }
            sViewFlagsFieldFetched = true;
        }
    }

    static {
        TRANSITION_ALPHA = new Property<View, Float>(Float.class, "translationAlpha"){

            public Float get(View view) {
                return Float.valueOf(ViewUtils.getTransitionAlpha(view));
            }

            public void set(View view, Float alpha) {
                ViewUtils.setTransitionAlpha(view, alpha.floatValue());
            }
        };
        CLIP_BOUNDS = new Property<View, Rect>(Rect.class, "clipBounds"){

            public Rect get(View view) {
                return ViewCompat.getClipBounds((View)view);
            }

            public void set(View view, Rect clipBounds) {
                ViewCompat.setClipBounds((View)view, (Rect)clipBounds);
            }
        };
    }
}

