/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.internal.widget.drawer;

import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.wear.internal.widget.drawer.WearableNavigationDrawerPresenter;
import android.support.wear.widget.drawer.WearableNavigationDrawerView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SinglePagePresenter
extends WearableNavigationDrawerPresenter {
    private static final long DRAWER_CLOSE_DELAY_MS = 500L;
    private final Ui mUi;
    private final boolean mIsAccessibilityEnabled;
    @Nullable
    private WearableNavigationDrawerView.WearableNavigationDrawerAdapter mAdapter;
    private int mCount = 0;
    private int mSelected = 0;

    public SinglePagePresenter(Ui ui, boolean isAccessibilityEnabled) {
        if (ui == null) {
            throw new IllegalArgumentException("Received null ui.");
        }
        this.mIsAccessibilityEnabled = isAccessibilityEnabled;
        this.mUi = ui;
        this.mUi.setPresenter(this);
        this.onDataSetChanged();
    }

    @Override
    public void onDataSetChanged() {
        if (this.mAdapter == null) {
            return;
        }
        int count = this.mAdapter.getCount();
        if (this.mCount != count) {
            this.mCount = count;
            this.mSelected = Math.min(this.mSelected, count - 1);
            this.mUi.initialize(count);
        }
        for (int i = 0; i < count; ++i) {
            this.mUi.setIcon(i, this.mAdapter.getItemDrawable(i), this.mAdapter.getItemText(i));
        }
        this.mUi.setText(this.mAdapter.getItemText(this.mSelected), false);
        this.mUi.selectItem(this.mSelected);
    }

    @Override
    public void onNewAdapter(WearableNavigationDrawerView.WearableNavigationDrawerAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Received null adapter.");
        }
        this.mAdapter = adapter;
        this.mAdapter.setPresenter(this);
        this.onDataSetChanged();
    }

    @Override
    public void onSelected(int index) {
        this.mUi.deselectItem(this.mSelected);
        this.mUi.selectItem(index);
        this.mSelected = index;
        if (this.mIsAccessibilityEnabled) {
            this.mUi.peekDrawer();
        } else {
            this.mUi.closeDrawerDelayed(500L);
        }
        if (this.mAdapter != null) {
            this.mUi.setText(this.mAdapter.getItemText(index), true);
        }
        this.notifyItemSelectedListeners(index);
    }

    @Override
    public void onSetCurrentItemRequested(int index, boolean smoothScrollTo) {
        this.mUi.deselectItem(this.mSelected);
        this.mUi.selectItem(index);
        this.mSelected = index;
        if (this.mAdapter != null) {
            this.mUi.setText(this.mAdapter.getItemText(index), false);
        }
        this.notifyItemSelectedListeners(index);
    }

    @Override
    public boolean onDrawerTapped() {
        return false;
    }

    public static interface Ui {
        public void setPresenter(WearableNavigationDrawerPresenter var1);

        public void initialize(int var1);

        public void setIcon(int var1, Drawable var2, CharSequence var3);

        public void setText(CharSequence var1, boolean var2);

        public void selectItem(int var1);

        public void deselectItem(int var1);

        public void closeDrawerDelayed(long var1);

        public void peekDrawer();
    }
}

