/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.content.Context;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.RecyclerView;
import android.support.wear.R;
import android.support.wear.widget.WearableLinearLayoutManager;
import android.view.View;

public class CurvingLayoutCallback
extends WearableLinearLayoutManager.LayoutCallback {
    private static final float EPSILON = 0.001f;
    private final Path mCurvePath;
    private final PathMeasure mPathMeasure;
    private int mCurvePathHeight;
    private int mXCurveOffset;
    private float mPathLength;
    private float mCurveBottom;
    private float mCurveTop;
    private float mLineGradient;
    private final float[] mPathPoints = new float[2];
    private final float[] mPathTangent = new float[2];
    private final float[] mAnchorOffsetXY = new float[2];
    private RecyclerView mParentView;
    private boolean mIsScreenRound;
    private int mLayoutWidth;
    private int mLayoutHeight;

    public CurvingLayoutCallback(Context context) {
        this.mCurvePath = new Path();
        this.mPathMeasure = new PathMeasure();
        this.mIsScreenRound = context.getResources().getConfiguration().isScreenRound();
        this.mXCurveOffset = context.getResources().getDimensionPixelSize(R.dimen.ws_wrv_curve_default_x_offset);
    }

    @Override
    public void onLayoutFinished(View child, RecyclerView parent) {
        if (this.mParentView != parent || this.mParentView != null && (this.mParentView.getWidth() != parent.getWidth() || this.mParentView.getHeight() != parent.getHeight())) {
            this.mParentView = parent;
            this.mLayoutWidth = this.mParentView.getWidth();
            this.mLayoutHeight = this.mParentView.getHeight();
        }
        if (this.mIsScreenRound) {
            boolean bottomClusterRisk;
            this.maybeSetUpCircularInitialLayout(this.mLayoutWidth, this.mLayoutHeight);
            this.mAnchorOffsetXY[0] = this.mXCurveOffset;
            this.mAnchorOffsetXY[1] = (float)child.getHeight() / 2.0f;
            this.adjustAnchorOffsetXY(child, this.mAnchorOffsetXY);
            float minCenter = -((float)child.getHeight()) / 2.0f;
            float maxCenter = (float)this.mLayoutHeight + (float)child.getHeight() / 2.0f;
            float range = maxCenter - minCenter;
            float verticalAnchor = (float)child.getTop() + this.mAnchorOffsetXY[1];
            float mYScrollProgress = (verticalAnchor + Math.abs(minCenter)) / range;
            this.mPathMeasure.getPosTan(mYScrollProgress * this.mPathLength, this.mPathPoints, this.mPathTangent);
            boolean topClusterRisk = Math.abs(this.mPathPoints[1] - this.mCurveBottom) < 0.001f && minCenter < this.mPathPoints[1];
            boolean bl = bottomClusterRisk = Math.abs(this.mPathPoints[1] - this.mCurveTop) < 0.001f && maxCenter > this.mPathPoints[1];
            if (topClusterRisk || bottomClusterRisk) {
                this.mPathPoints[1] = verticalAnchor;
                this.mPathPoints[0] = Math.abs(verticalAnchor) * this.mLineGradient;
            }
            int newLeft = (int)(this.mPathPoints[0] - this.mAnchorOffsetXY[0]);
            child.offsetLeftAndRight(newLeft - child.getLeft());
            float verticalTranslation = this.mPathPoints[1] - verticalAnchor;
            child.setTranslationY(verticalTranslation);
        } else {
            child.setTranslationY(0.0f);
        }
    }

    public void adjustAnchorOffsetXY(View child, float[] anchorOffsetXY) {
    }

    @VisibleForTesting
    void setRound(boolean isScreenRound) {
        this.mIsScreenRound = isScreenRound;
    }

    @VisibleForTesting
    void setOffset(int offset) {
        this.mXCurveOffset = offset;
    }

    private void maybeSetUpCircularInitialLayout(int width, int height) {
        if (this.mCurvePathHeight != height) {
            this.mCurvePathHeight = height;
            this.mCurveBottom = -0.048f * (float)height;
            this.mCurveTop = 1.048f * (float)height;
            this.mLineGradient = 10.416667f;
            this.mCurvePath.reset();
            this.mCurvePath.moveTo(0.5f * (float)width, this.mCurveBottom);
            this.mCurvePath.lineTo(0.34f * (float)width, 0.075f * (float)height);
            this.mCurvePath.cubicTo(0.22f * (float)width, 0.17f * (float)height, 0.13f * (float)width, 0.32f * (float)height, 0.13f * (float)width, (float)(height / 2));
            this.mCurvePath.cubicTo(0.13f * (float)width, 0.68f * (float)height, 0.22f * (float)width, 0.83f * (float)height, 0.34f * (float)width, 0.925f * (float)height);
            this.mCurvePath.lineTo((float)(width / 2), this.mCurveTop);
            this.mPathMeasure.setPath(this.mCurvePath, false);
            this.mPathLength = this.mPathMeasure.getLength();
        }
    }
}

