/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.RestrictTo;
import android.support.wear.widget.BezierSCurveInterpolator;
import android.util.Property;
import android.view.animation.LinearInterpolator;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class ProgressDrawable
extends Drawable {
    private static final Property<ProgressDrawable, Integer> LEVEL = new Property<ProgressDrawable, Integer>(Integer.class, "level"){

        public Integer get(ProgressDrawable drawable2) {
            return drawable2.getLevel();
        }

        public void set(ProgressDrawable drawable2, Integer value) {
            drawable2.setLevel(value);
            drawable2.invalidateSelf();
        }
    };
    private static final int MAX_LEVEL = 10000;
    private static final int NUMBER_OF_SEGMENTS = 5;
    private static final int LEVELS_PER_SEGMENT = 2000;
    private static final float STARTING_ANGLE = -90.0f;
    private static final long ANIMATION_DURATION = 6000L;
    private static final int FULL_CIRCLE = 360;
    private static final int MAX_SWEEP = 306;
    private static final int CORRECTION_ANGLE = 54;
    private static final float GROW_SHRINK_RATIO = 0.5f;
    private static final TimeInterpolator sInterpolator = BezierSCurveInterpolator.INSTANCE;
    private final RectF mInnerCircleBounds = new RectF();
    private final Paint mPaint = new Paint();
    private final ObjectAnimator mAnimator;
    private float mCircleBorderWidth;
    private int mCircleBorderColor;

    ProgressDrawable() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mAnimator = ObjectAnimator.ofInt((Object)((Object)this), LEVEL, (int[])new int[]{0, 10000});
        this.mAnimator.setRepeatCount(-1);
        this.mAnimator.setRepeatMode(1);
        this.mAnimator.setDuration(6000L);
        this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
    }

    private static float lerpInv(float a, float b, float value) {
        return a != b ? (value - a) / (b - a) : 0.0f;
    }

    public void setRingColor(int color2) {
        this.mCircleBorderColor = color2;
    }

    public void setRingWidth(float width) {
        this.mCircleBorderWidth = width;
    }

    public void startAnimation() {
        if (!this.mAnimator.isStarted()) {
            this.mAnimator.start();
        }
    }

    public void stopAnimation() {
        this.mAnimator.cancel();
    }

    public void draw(Canvas canvas) {
        canvas.save();
        this.mInnerCircleBounds.set(this.getBounds());
        this.mInnerCircleBounds.inset(this.mCircleBorderWidth / 2.0f, this.mCircleBorderWidth / 2.0f);
        this.mPaint.setStrokeWidth(this.mCircleBorderWidth);
        this.mPaint.setColor(this.mCircleBorderColor);
        int level = this.getLevel();
        int currentSegment = level / 2000;
        int offset = currentSegment * 2000;
        float progress = (float)(level - offset) / 2000.0f;
        boolean growing = progress < 0.5f;
        float correctionAngle = 54.0f * progress;
        float sweepAngle = growing ? 306.0f * sInterpolator.getInterpolation(ProgressDrawable.lerpInv(0.0f, 0.5f, progress)) : 306.0f * (1.0f - sInterpolator.getInterpolation(ProgressDrawable.lerpInv(0.5f, 1.0f, progress)));
        sweepAngle = Math.max(1.0f, sweepAngle);
        canvas.rotate((float)level * 1.0E-4f * 2.0f * 360.0f + -90.0f + correctionAngle, this.mInnerCircleBounds.centerX(), this.mInnerCircleBounds.centerY());
        canvas.drawArc(this.mInnerCircleBounds, growing ? 0.0f : 306.0f - sweepAngle, sweepAngle, false, this.mPaint);
        canvas.restore();
    }

    public void setAlpha(int i) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -1;
    }

    protected boolean onLevelChange(int level) {
        return true;
    }
}

