/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.wear.R;
import android.util.AttributeSet;
import android.util.Xml;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RoundedDrawable
extends Drawable {
    @VisibleForTesting
    final Paint mPaint;
    final Paint mBackgroundPaint;
    @Nullable
    private Drawable mDrawable;
    private int mRadius;
    private boolean mIsClipEnabled;
    private final Rect mTmpBounds = new Rect();
    private final RectF mTmpBoundsF = new RectF();

    public RoundedDrawable() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setColor(0);
    }

    public void inflate(@NonNull Resources r, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = r.obtainAttributes(Xml.asAttributeSet((XmlPullParser)parser), R.styleable.RoundedDrawable);
        if (a.hasValue(R.styleable.RoundedDrawable_android_src)) {
            this.setDrawable(a.getDrawable(R.styleable.RoundedDrawable_android_src));
        }
        this.setRadius(a.getDimensionPixelSize(R.styleable.RoundedDrawable_radius, 0));
        this.setClipEnabled(a.getBoolean(R.styleable.RoundedDrawable_clipEnabled, false));
        this.setBackgroundColor(a.getColor(R.styleable.RoundedDrawable_backgroundColor, 0));
        a.recycle();
    }

    public void setDrawable(@Nullable Drawable drawable2) {
        if (Objects.equals(this.mDrawable, drawable2)) {
            return;
        }
        this.mDrawable = drawable2;
        this.mPaint.setShader(null);
        this.invalidateSelf();
    }

    @Nullable
    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public void setBackgroundColor(@ColorInt int color2) {
        this.mBackgroundPaint.setColor(color2);
        this.invalidateSelf();
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.mBackgroundPaint.getColor();
    }

    public void setClipEnabled(boolean clipEnabled) {
        this.mIsClipEnabled = clipEnabled;
        if (!clipEnabled) {
            this.mPaint.setShader(null);
        }
        this.invalidateSelf();
    }

    public boolean isClipEnabled() {
        return this.mIsClipEnabled;
    }

    protected void onBoundsChange(Rect bounds) {
        this.mTmpBounds.right = bounds.width();
        this.mTmpBounds.bottom = bounds.height();
        this.mTmpBoundsF.right = bounds.width();
        this.mTmpBoundsF.bottom = bounds.height();
        this.mPaint.setShader(null);
    }

    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        if (this.mDrawable == null || bounds.isEmpty()) {
            return;
        }
        canvas.save();
        canvas.translate((float)bounds.left, (float)bounds.top);
        canvas.drawRoundRect(this.mTmpBoundsF, (float)this.mRadius, (float)this.mRadius, this.mBackgroundPaint);
        if (this.mIsClipEnabled) {
            if (this.mPaint.getShader() == null) {
                this.updateBitmapShader();
            }
            canvas.drawRoundRect(this.mTmpBoundsF, (float)this.mRadius, (float)this.mRadius, this.mPaint);
        } else {
            int minEdge = Math.min(bounds.width(), bounds.height());
            int padding = (int)Math.ceil((float)Math.min(this.mRadius, minEdge / 2) * (1.0f - 1.0f / (float)Math.sqrt(2.0)));
            this.mTmpBounds.inset(padding, padding);
            this.mDrawable.setBounds(this.mTmpBounds);
            this.mDrawable.draw(canvas);
            this.mTmpBounds.inset(-padding, -padding);
        }
        canvas.restore();
    }

    public int getOpacity() {
        return -3;
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
        this.mBackgroundPaint.setAlpha(alpha);
    }

    public int getAlpha() {
        return this.mPaint.getAlpha();
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public void setRadius(int radius) {
        this.mRadius = radius;
    }

    public int getRadius() {
        return this.mRadius;
    }

    private void updateBitmapShader() {
        if (this.mDrawable == null) {
            return;
        }
        Rect bounds = this.getBounds();
        if (!bounds.isEmpty()) {
            Bitmap bitmap = this.drawableToBitmap(this.mDrawable, bounds.width(), bounds.height());
            BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mPaint.setShader((Shader)shader);
        }
    }

    private Bitmap drawableToBitmap(Drawable drawable2, int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        return bitmap;
    }
}

