/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.UiThread;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@UiThread
class SwipeDismissLayout
extends FrameLayout {
    private static final String TAG = "SwipeDismissLayout";
    public static final float DEFAULT_DISMISS_DRAG_WIDTH_RATIO = 0.33f;
    private static final float EDGE_SWIPE_THRESHOLD = 0.1f;
    private int mSlop;
    private int mMinFlingVelocity;
    private float mGestureThresholdPx;
    private int mActiveTouchId;
    private float mDownX;
    private float mDownY;
    private boolean mSwipeable;
    private boolean mSwiping;
    private boolean mCanStartSwipe = true;
    private boolean mDismissed;
    private boolean mDiscardIntercept;
    private VelocityTracker mVelocityTracker;
    private float mTranslationX;
    private boolean mDisallowIntercept;
    @Nullable
    private OnPreSwipeListener mOnPreSwipeListener;
    private OnDismissedListener mDismissedListener;
    private OnSwipeProgressChangedListener mProgressListener;
    private float mLastX;
    private float mDismissMinDragWidthRatio = 0.33f;

    SwipeDismissLayout(Context context) {
        this(context, null);
    }

    SwipeDismissLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    SwipeDismissLayout(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    SwipeDismissLayout(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs, defStyle, defStyleRes);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mGestureThresholdPx = (float)Resources.getSystem().getDisplayMetrics().widthPixels * 0.1f;
        this.setSwipeable(true);
    }

    public void setDismissMinDragWidthRatio(float ratio) {
        this.mDismissMinDragWidthRatio = ratio;
    }

    public float getDismissMinDragWidthRatio() {
        return this.mDismissMinDragWidthRatio;
    }

    public void setSwipeable(boolean swipeable) {
        this.mSwipeable = swipeable;
    }

    public boolean isSwipeable() {
        return this.mSwipeable;
    }

    void setOnPreSwipeListener(@Nullable OnPreSwipeListener listener) {
        this.mOnPreSwipeListener = listener;
    }

    void setOnDismissedListener(@Nullable OnDismissedListener listener) {
        this.mDismissedListener = listener;
    }

    void setOnSwipeProgressChangedListener(@Nullable OnSwipeProgressChangedListener listener) {
        this.mProgressListener = listener;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        this.mDisallowIntercept = disallowIntercept;
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mSwipeable) {
            return super.onInterceptTouchEvent(ev);
        }
        ev.offsetLocation(this.mTranslationX, 0.0f);
        switch (ev.getActionMasked()) {
            case 0: {
                this.resetMembers();
                this.mDownX = ev.getRawX();
                this.mDownY = ev.getRawY();
                this.mActiveTouchId = ev.getPointerId(0);
                this.mVelocityTracker = VelocityTracker.obtain();
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 5: {
                int actionIndex = ev.getActionIndex();
                this.mActiveTouchId = ev.getPointerId(actionIndex);
                break;
            }
            case 6: {
                int actionIndex = ev.getActionIndex();
                int pointerId = ev.getPointerId(actionIndex);
                if (pointerId != this.mActiveTouchId) break;
                int newActionIndex = actionIndex == 0 ? 1 : 0;
                this.mActiveTouchId = ev.getPointerId(newActionIndex);
                break;
            }
            case 1: 
            case 3: {
                this.resetMembers();
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mDiscardIntercept) break;
                int pointerIndex = ev.findPointerIndex(this.mActiveTouchId);
                if (pointerIndex == -1) {
                    Log.e((String)TAG, (String)"Invalid pointer index: ignoring.");
                    this.mDiscardIntercept = true;
                    break;
                }
                float dx = ev.getRawX() - this.mDownX;
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                if (dx != 0.0f && this.mDownX >= this.mGestureThresholdPx && this.canScroll((View)this, false, dx, x, y)) {
                    this.mDiscardIntercept = true;
                    break;
                }
                this.updateSwiping(ev);
            }
        }
        if (this.mOnPreSwipeListener == null && !this.mDisallowIntercept || this.mOnPreSwipeListener.onPreSwipe(this, this.mDownX, this.mDownY)) {
            return !this.mDiscardIntercept && this.mSwiping;
        }
        return false;
    }

    public boolean canScrollHorizontally(int direction) {
        return direction < 0 && this.isSwipeable() && this.getVisibility() == 0;
    }

    private boolean isPotentialSwipe(float dx, float dy) {
        return dx * dx + dy * dy > (float)(this.mSlop * this.mSlop);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mSwipeable) {
            return super.onTouchEvent(ev);
        }
        if (this.mVelocityTracker == null) {
            return super.onTouchEvent(ev);
        }
        if (this.mOnPreSwipeListener != null && !this.mOnPreSwipeListener.onPreSwipe(this, this.mDownX, this.mDownY)) {
            return super.onTouchEvent(ev);
        }
        ev.offsetLocation(this.mTranslationX, 0.0f);
        switch (ev.getActionMasked()) {
            case 1: {
                this.updateDismiss(ev);
                if (this.mDismissed) {
                    this.dismiss();
                } else if (this.mSwiping) {
                    this.cancel();
                }
                this.resetMembers();
                break;
            }
            case 3: {
                this.cancel();
                this.resetMembers();
                break;
            }
            case 2: {
                this.mVelocityTracker.addMovement(ev);
                this.mLastX = ev.getRawX();
                this.updateSwiping(ev);
                if (!this.mSwiping) break;
                this.setProgress(ev.getRawX() - this.mDownX);
            }
        }
        return true;
    }

    private void setProgress(float deltaX) {
        this.mTranslationX = deltaX;
        if (this.mProgressListener != null && deltaX >= 0.0f) {
            this.mProgressListener.onSwipeProgressChanged(this, deltaX / (float)this.getWidth(), deltaX);
        }
    }

    private void dismiss() {
        if (this.mDismissedListener != null) {
            this.mDismissedListener.onDismissed(this);
        }
    }

    private void cancel() {
        if (this.mProgressListener != null) {
            this.mProgressListener.onSwipeCanceled(this);
        }
    }

    private void resetMembers() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = null;
        this.mTranslationX = 0.0f;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mSwiping = false;
        this.mDismissed = false;
        this.mDiscardIntercept = false;
        this.mCanStartSwipe = true;
        this.mDisallowIntercept = false;
    }

    private void updateSwiping(MotionEvent ev) {
        float deltaY;
        float deltaX;
        if (!this.mSwiping && this.isPotentialSwipe(deltaX = ev.getRawX() - this.mDownX, deltaY = ev.getRawY() - this.mDownY)) {
            this.mCanStartSwipe = this.mSwiping = this.mCanStartSwipe && Math.abs(deltaY) < Math.abs(deltaX) && deltaX > 0.0f;
        }
    }

    private void updateDismiss(MotionEvent ev) {
        float deltaX = ev.getRawX() - this.mDownX;
        this.mVelocityTracker.addMovement(ev);
        this.mVelocityTracker.computeCurrentVelocity(1000);
        if (!this.mDismissed && (deltaX > (float)this.getWidth() * this.mDismissMinDragWidthRatio && ev.getRawX() >= this.mLastX || this.mVelocityTracker.getXVelocity() >= (float)this.mMinFlingVelocity)) {
            this.mDismissed = true;
        }
        if (this.mDismissed && this.mSwiping && this.mVelocityTracker.getXVelocity() < (float)(-this.mMinFlingVelocity)) {
            this.mDismissed = false;
        }
    }

    protected boolean canScroll(View v, boolean checkV, float dx, float x, float y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (!(x + (float)scrollX >= (float)child.getLeft()) || !(x + (float)scrollX < (float)child.getRight()) || !(y + (float)scrollY >= (float)child.getTop()) || !(y + (float)scrollY < (float)child.getBottom()) || !this.canScroll(child, true, dx, x + (float)scrollX - (float)child.getLeft(), y + (float)scrollY - (float)child.getTop())) continue;
                return true;
            }
        }
        return checkV && v.canScrollHorizontally((int)(-dx));
    }

    @UiThread
    static interface OnSwipeProgressChangedListener {
        public void onSwipeProgressChanged(SwipeDismissLayout var1, float var2, float var3);

        public void onSwipeCanceled(SwipeDismissLayout var1);
    }

    @UiThread
    static interface OnDismissedListener {
        public void onDismissed(SwipeDismissLayout var1);
    }

    @UiThread
    static interface OnPreSwipeListener {
        public boolean onPreSwipe(SwipeDismissLayout var1, float var2, float var3);
    }
}

