/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.wear.widget.CurvingLayoutCallback;
import android.support.wear.widget.WearableRecyclerView;
import android.view.View;

public class WearableLinearLayoutManager
extends LinearLayoutManager {
    @Nullable
    private LayoutCallback mLayoutCallback;

    public WearableLinearLayoutManager(Context context, LayoutCallback layoutCallback) {
        super(context, 1, false);
        this.mLayoutCallback = layoutCallback;
    }

    public WearableLinearLayoutManager(Context context) {
        this(context, new CurvingLayoutCallback(context));
    }

    public void setLayoutCallback(@Nullable LayoutCallback layoutCallback) {
        this.mLayoutCallback = layoutCallback;
    }

    @Nullable
    public LayoutCallback getLayoutCallback() {
        return this.mLayoutCallback;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        int scrolled = super.scrollVerticallyBy(dy, recycler, state);
        this.updateLayout();
        return scrolled;
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        super.onLayoutChildren(recycler, state);
        if (this.getChildCount() == 0) {
            return;
        }
        this.updateLayout();
    }

    private void updateLayout() {
        if (this.mLayoutCallback == null) {
            return;
        }
        int childCount = this.getChildCount();
        for (int count = 0; count < childCount; ++count) {
            View child = this.getChildAt(count);
            this.mLayoutCallback.onLayoutFinished(child, (WearableRecyclerView)child.getParent());
        }
    }

    public static abstract class LayoutCallback {
        public abstract void onLayoutFinished(View var1, RecyclerView var2);
    }
}

