/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget.drawer;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.RecyclerView;
import android.support.wear.widget.drawer.AbsListViewFlingWatcher;
import android.support.wear.widget.drawer.NestedScrollViewFlingWatcher;
import android.support.wear.widget.drawer.RecyclerViewFlingWatcher;
import android.support.wear.widget.drawer.ScrollViewFlingWatcher;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ScrollView;
import java.util.Map;
import java.util.WeakHashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class FlingWatcherFactory {
    private final FlingListener mListener;
    private final Map<View, FlingWatcher> mWatchers = new WeakHashMap<View, FlingWatcher>();

    FlingWatcherFactory(FlingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("FlingListener was null");
        }
        this.mListener = listener;
    }

    @Nullable
    FlingWatcher getFor(View view) {
        FlingWatcher watcher = this.mWatchers.get(view);
        if (watcher == null && (watcher = this.createFor(view)) != null) {
            this.mWatchers.put(view, watcher);
        }
        return watcher;
    }

    @Nullable
    private FlingWatcher createFor(View view) {
        if (view == null) {
            throw new IllegalArgumentException("View was null");
        }
        if (view instanceof RecyclerView) {
            return new RecyclerViewFlingWatcher(this.mListener, (RecyclerView)view);
        }
        if (view instanceof AbsListView) {
            return new AbsListViewFlingWatcher(this.mListener, (AbsListView)view);
        }
        if (view instanceof ScrollView) {
            return new ScrollViewFlingWatcher(this.mListener, (ScrollView)view);
        }
        if (view instanceof NestedScrollView) {
            return new NestedScrollViewFlingWatcher(this.mListener, (NestedScrollView)view);
        }
        return null;
    }

    static interface FlingWatcher {
        public void watch();
    }

    static interface FlingListener {
        public void onFlingComplete(View var1);
    }
}

