/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget.drawer;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.wear.R;
import android.support.wear.internal.widget.ResourcesUtil;
import android.support.wear.widget.drawer.WearableActionDrawerMenu;
import android.support.wear.widget.drawer.WearableDrawerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.Objects;

public class WearableActionDrawerView
extends WearableDrawerView {
    private static final String TAG = "WearableActionDrawer";
    private final RecyclerView mActionList;
    private final int mTopPadding;
    private final int mBottomPadding;
    private final int mLeftPadding;
    private final int mRightPadding;
    private final int mFirstItemTopPadding;
    private final int mLastItemBottomPadding;
    private final int mIconRightMargin;
    private final boolean mShowOverflowInPeek;
    @Nullable
    private final ImageView mPeekActionIcon;
    @Nullable
    private final ImageView mPeekExpandIcon;
    private final RecyclerView.Adapter<RecyclerView.ViewHolder> mActionListAdapter;
    private MenuItem.OnMenuItemClickListener mOnMenuItemClickListener;
    private Menu mMenu;
    @Nullable
    private CharSequence mTitle;

    public WearableActionDrawerView(Context context) {
        this(context, null);
    }

    public WearableActionDrawerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearableActionDrawerView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WearableActionDrawerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setLockedWhenClosed(true);
        boolean showOverflowInPeek = false;
        int menuRes = 0;
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.WearableActionDrawerView, defStyleAttr, 0);
            try {
                this.mTitle = typedArray.getString(R.styleable.WearableActionDrawerView_drawerTitle);
                showOverflowInPeek = typedArray.getBoolean(R.styleable.WearableActionDrawerView_showOverflowInPeek, false);
                menuRes = typedArray.getResourceId(R.styleable.WearableActionDrawerView_actionMenu, 0);
            }
            finally {
                typedArray.recycle();
            }
        }
        AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        boolean bl = this.mShowOverflowInPeek = showOverflowInPeek || accessibilityManager.isEnabled();
        if (!this.mShowOverflowInPeek) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
            View peekView = layoutInflater.inflate(R.layout.ws_action_drawer_peek_view, this.getPeekContainer(), false);
            this.setPeekContent(peekView);
            this.mPeekActionIcon = (ImageView)peekView.findViewById(R.id.ws_action_drawer_peek_action_icon);
            this.mPeekExpandIcon = (ImageView)peekView.findViewById(R.id.ws_action_drawer_expand_icon);
        } else {
            this.mPeekActionIcon = null;
            this.mPeekExpandIcon = null;
            this.getPeekContainer().setContentDescription((CharSequence)context.getString(R.string.ws_action_drawer_content_description));
        }
        if (menuRes != 0) {
            MenuInflater inflater = new MenuInflater(context);
            inflater.inflate(menuRes, this.getMenu());
        }
        int screenWidthPx = ResourcesUtil.getScreenWidthPx(context);
        int screenHeightPx = ResourcesUtil.getScreenHeightPx(context);
        Resources res = this.getResources();
        this.mTopPadding = res.getDimensionPixelOffset(R.dimen.ws_action_drawer_item_top_padding);
        this.mBottomPadding = res.getDimensionPixelOffset(R.dimen.ws_action_drawer_item_bottom_padding);
        this.mLeftPadding = ResourcesUtil.getFractionOfScreenPx(context, screenWidthPx, R.fraction.ws_action_drawer_item_left_padding);
        this.mRightPadding = ResourcesUtil.getFractionOfScreenPx(context, screenWidthPx, R.fraction.ws_action_drawer_item_right_padding);
        this.mFirstItemTopPadding = ResourcesUtil.getFractionOfScreenPx(context, screenHeightPx, R.fraction.ws_action_drawer_item_first_item_top_padding);
        this.mLastItemBottomPadding = ResourcesUtil.getFractionOfScreenPx(context, screenHeightPx, R.fraction.ws_action_drawer_item_last_item_bottom_padding);
        this.mIconRightMargin = res.getDimensionPixelOffset(R.dimen.ws_action_drawer_item_icon_right_margin);
        this.mActionList = new RecyclerView(context);
        this.mActionList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.mActionListAdapter = new ActionListAdapter(this.getMenu());
        this.mActionList.setAdapter(this.mActionListAdapter);
        this.setDrawerContent((View)this.mActionList);
    }

    @Override
    public void onDrawerOpened() {
        RecyclerView.ViewHolder holder;
        if (this.mActionListAdapter.getItemCount() > 0 && (holder = this.mActionList.findViewHolderForAdapterPosition(0)) != null && holder.itemView != null) {
            holder.itemView.sendAccessibilityEvent(8);
        }
    }

    public boolean canScrollHorizontally(int direction) {
        return this.isOpened();
    }

    @Override
    public void onPeekContainerClicked(View v) {
        if (this.mShowOverflowInPeek) {
            super.onPeekContainerClicked(v);
        } else {
            this.onMenuItemClicked(0);
        }
    }

    @Override
    int preferGravity() {
        return 80;
    }

    public void setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener listener) {
        this.mOnMenuItemClickListener = listener;
    }

    public void setTitle(@Nullable CharSequence title) {
        if (Objects.equals(title, this.mTitle)) {
            return;
        }
        CharSequence oldTitle = this.mTitle;
        this.mTitle = title;
        if (oldTitle == null) {
            this.mActionListAdapter.notifyItemInserted(0);
        } else if (title == null) {
            this.mActionListAdapter.notifyItemRemoved(0);
        } else {
            this.mActionListAdapter.notifyItemChanged(0);
        }
    }

    private boolean hasTitle() {
        return this.mTitle != null;
    }

    private void onMenuItemClicked(int position) {
        if (position >= 0 && position < this.getMenu().size()) {
            WearableActionDrawerMenu.WearableActionDrawerMenuItem menuItem = (WearableActionDrawerMenu.WearableActionDrawerMenuItem)this.getMenu().getItem(position);
            if (menuItem.invoke()) {
                return;
            }
            if (this.mOnMenuItemClickListener != null) {
                this.mOnMenuItemClickListener.onMenuItemClick((MenuItem)menuItem);
            }
        }
    }

    private void updatePeekIcons() {
        if (this.mPeekActionIcon == null || this.mPeekExpandIcon == null) {
            return;
        }
        Menu menu = this.getMenu();
        int numberOfActions = menu.size();
        if (numberOfActions > 1) {
            this.setDrawerContent((View)this.mActionList);
            this.mPeekExpandIcon.setVisibility(0);
        } else {
            this.setDrawerContent(null);
            this.mPeekExpandIcon.setVisibility(8);
        }
        if (numberOfActions >= 1) {
            Drawable firstActionDrawable = menu.getItem(0).getIcon();
            if (firstActionDrawable != null) {
                firstActionDrawable = firstActionDrawable.getConstantState().newDrawable().mutate();
                firstActionDrawable.clearColorFilter();
            }
            this.mPeekActionIcon.setImageDrawable(firstActionDrawable);
            this.mPeekActionIcon.setContentDescription(menu.getItem(0).getTitle());
        }
    }

    public Menu getMenu() {
        if (this.mMenu == null) {
            this.mMenu = new WearableActionDrawerMenu(this.getContext(), new WearableActionDrawerMenu.WearableActionDrawerMenuListener(){

                @Override
                public void menuItemChanged(int position) {
                    if (WearableActionDrawerView.this.mActionListAdapter != null) {
                        int listPosition = WearableActionDrawerView.this.hasTitle() ? position + 1 : position;
                        WearableActionDrawerView.this.mActionListAdapter.notifyItemChanged(listPosition);
                    }
                    if (position == 0) {
                        WearableActionDrawerView.this.updatePeekIcons();
                    }
                }

                @Override
                public void menuItemAdded(int position) {
                    if (WearableActionDrawerView.this.mActionListAdapter != null) {
                        int listPosition = WearableActionDrawerView.this.hasTitle() ? position + 1 : position;
                        WearableActionDrawerView.this.mActionListAdapter.notifyItemInserted(listPosition);
                    }
                    if (position <= 1) {
                        WearableActionDrawerView.this.updatePeekIcons();
                    }
                }

                @Override
                public void menuItemRemoved(int position) {
                    if (WearableActionDrawerView.this.mActionListAdapter != null) {
                        int listPosition = WearableActionDrawerView.this.hasTitle() ? position + 1 : position;
                        WearableActionDrawerView.this.mActionListAdapter.notifyItemRemoved(listPosition);
                    }
                    if (position <= 1) {
                        WearableActionDrawerView.this.updatePeekIcons();
                    }
                }

                @Override
                public void menuChanged() {
                    if (WearableActionDrawerView.this.mActionListAdapter != null) {
                        WearableActionDrawerView.this.mActionListAdapter.notifyDataSetChanged();
                    }
                    WearableActionDrawerView.this.updatePeekIcons();
                }
            });
        }
        return this.mMenu;
    }

    private final class ActionItemViewHolder
    extends RecyclerView.ViewHolder {
        public final View view;
        public final ImageView iconView;
        public final TextView textView;

        ActionItemViewHolder(View view) {
            super(view);
            this.view = view;
            this.iconView = (ImageView)view.findViewById(R.id.ws_action_drawer_item_icon);
            ((LinearLayout.LayoutParams)this.iconView.getLayoutParams()).setMarginEnd(WearableActionDrawerView.this.mIconRightMargin);
            this.textView = (TextView)view.findViewById(R.id.ws_action_drawer_item_text);
        }
    }

    private final class ActionListAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        public static final int TYPE_ACTION = 0;
        public static final int TYPE_TITLE = 1;
        private final Menu mActionMenu;
        private final View.OnClickListener mItemClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                int childPos = WearableActionDrawerView.this.mActionList.getChildAdapterPosition(v) - (WearableActionDrawerView.this.hasTitle() ? 1 : 0);
                if (childPos == -1) {
                    Log.w((String)WearableActionDrawerView.TAG, (String)"invalid child position");
                    return;
                }
                WearableActionDrawerView.this.onMenuItemClicked(childPos);
            }
        };

        ActionListAdapter(Menu menu) {
            this.mActionMenu = WearableActionDrawerView.this.getMenu();
        }

        public int getItemCount() {
            return this.mActionMenu.size() + (WearableActionDrawerView.this.hasTitle() ? 1 : 0);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
            int titleAwarePosition;
            int n = titleAwarePosition = WearableActionDrawerView.this.hasTitle() ? position - 1 : position;
            if (viewHolder instanceof ActionItemViewHolder) {
                ActionItemViewHolder holder = (ActionItemViewHolder)viewHolder;
                holder.view.setPadding(WearableActionDrawerView.this.mLeftPadding, position == 0 ? WearableActionDrawerView.this.mFirstItemTopPadding : WearableActionDrawerView.this.mTopPadding, WearableActionDrawerView.this.mRightPadding, position == this.getItemCount() - 1 ? WearableActionDrawerView.this.mLastItemBottomPadding : WearableActionDrawerView.this.mBottomPadding);
                Drawable icon = this.mActionMenu.getItem(titleAwarePosition).getIcon();
                if (icon != null) {
                    icon = icon.getConstantState().newDrawable().mutate();
                }
                CharSequence title = this.mActionMenu.getItem(titleAwarePosition).getTitle();
                holder.textView.setText(title);
                holder.textView.setContentDescription(title);
                holder.iconView.setImageDrawable(icon);
            } else if (viewHolder instanceof TitleViewHolder) {
                TitleViewHolder holder = (TitleViewHolder)viewHolder;
                holder.textView.setText(WearableActionDrawerView.this.mTitle);
            }
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            switch (viewType) {
                case 1: {
                    View titleView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ws_action_drawer_title_view, parent, false);
                    return new TitleViewHolder(titleView);
                }
            }
            View actionView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ws_action_drawer_item_view, parent, false);
            actionView.setOnClickListener(this.mItemClickListener);
            return new ActionItemViewHolder(actionView);
        }

        public int getItemViewType(int position) {
            return WearableActionDrawerView.this.hasTitle() && position == 0 ? 1 : 0;
        }
    }

    private static final class TitleViewHolder
    extends RecyclerView.ViewHolder {
        public final View view;
        public final TextView textView;

        TitleViewHolder(View view) {
            super(view);
            this.view = view;
            this.textView = (TextView)view.findViewById(R.id.ws_action_drawer_title);
        }
    }
}

