/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget.drawer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.support.wear.widget.drawer.FlingWatcherFactory;
import android.support.wear.widget.drawer.WearableDrawerController;
import android.support.wear.widget.drawer.WearableDrawerView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.widget.FrameLayout;

public class WearableDrawerLayout
extends FrameLayout
implements View.OnLayoutChangeListener,
NestedScrollingParent,
FlingWatcherFactory.FlingListener {
    private static final String TAG = "WearableDrawerLayout";
    private static final int GRAVITY_UNDEFINED = -1;
    private static final int PEEK_FADE_DURATION_MS = 150;
    private static final int PEEK_AUTO_CLOSE_DELAY_MS = 1000;
    private static final int DOWN = 1;
    private static final int UP = -1;
    private static final float OPENED_PERCENT_THRESHOLD = 0.5f;
    private static final int NESTED_SCROLL_SLOP_DP = 5;
    @VisibleForTesting
    final ViewDragHelper.Callback mTopDrawerDraggerCallback;
    @VisibleForTesting
    final ViewDragHelper.Callback mBottomDrawerDraggerCallback;
    private final int mNestedScrollSlopPx;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
    private final ViewDragHelper mTopDrawerDragger;
    private final ViewDragHelper mBottomDrawerDragger;
    private final boolean mIsAccessibilityEnabled;
    private final FlingWatcherFactory mFlingWatcher;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private final ClosePeekRunnable mCloseTopPeekRunnable = new ClosePeekRunnable(48);
    private final ClosePeekRunnable mCloseBottomPeekRunnable = new ClosePeekRunnable(80);
    @Nullable
    private WearableDrawerView mTopDrawerView;
    @Nullable
    private WearableDrawerView mBottomDrawerView;
    @Nullable
    private View mScrollingContentView;
    private DrawerStateCallback mDrawerStateCallback;
    private int mSystemWindowInsetBottom;
    private int mCurrentNestedScrollSlopTracker;
    private boolean mShouldOpenTopDrawerAfterLayout;
    private boolean mShouldOpenBottomDrawerAfterLayout;
    private boolean mShouldPeekTopDrawerAfterLayout;
    private boolean mShouldPeekBottomDrawerAfterLayout;
    private boolean mCanTopDrawerBeClosed;
    private boolean mCanBottomDrawerBeClosed;
    private boolean mLastScrollWasFling;
    private MotionEvent mDrawerOpenLastInterceptedTouchEvent;

    public WearableDrawerLayout(Context context) {
        this(context, null);
    }

    public WearableDrawerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearableDrawerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public WearableDrawerLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mFlingWatcher = new FlingWatcherFactory(this);
        this.mTopDrawerDraggerCallback = new TopDrawerDraggerCallback();
        this.mTopDrawerDragger = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)this.mTopDrawerDraggerCallback);
        this.mTopDrawerDragger.setEdgeTrackingEnabled(4);
        this.mBottomDrawerDraggerCallback = new BottomDrawerDraggerCallback();
        this.mBottomDrawerDragger = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)this.mBottomDrawerDraggerCallback);
        this.mBottomDrawerDragger.setEdgeTrackingEnabled(8);
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        this.mNestedScrollSlopPx = Math.round(metrics.density * 5.0f);
        AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        this.mIsAccessibilityEnabled = accessibilityManager.isEnabled();
    }

    private static void animatePeekVisibleAfterBeingClosed(WearableDrawerView drawer) {
        final View content = drawer.getDrawerContent();
        if (content != null) {
            content.animate().setDuration(150L).alpha(0.0f).withEndAction(new Runnable(){

                @Override
                public void run() {
                    content.setVisibility(8);
                }
            }).start();
        }
        ViewGroup peek = drawer.getPeekContainer();
        peek.setVisibility(0);
        peek.animate().setStartDelay(150L).setDuration(150L).alpha(1.0f).scaleX(1.0f).scaleY(1.0f).start();
        drawer.setIsPeeking(true);
    }

    private static void showDrawerContentMaybeAnimate(WearableDrawerView drawerView) {
        drawerView.bringToFront();
        View contentView = drawerView.getDrawerContent();
        if (contentView != null) {
            contentView.setVisibility(0);
        }
        if (drawerView.isPeeking()) {
            ViewGroup peekView = drawerView.getPeekContainer();
            peekView.animate().alpha(0.0f).scaleX(0.0f).scaleY(0.0f).setDuration(150L).start();
            if (contentView != null) {
                contentView.setAlpha(0.0f);
                contentView.animate().setStartDelay(150L).alpha(1.0f).setDuration(150L).start();
            }
        } else {
            drawerView.getPeekContainer().setAlpha(0.0f);
            if (contentView != null) {
                contentView.setAlpha(1.0f);
            }
        }
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        this.mSystemWindowInsetBottom = insets.getSystemWindowInsetBottom();
        if (this.mSystemWindowInsetBottom != 0) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            layoutParams.bottomMargin = this.mSystemWindowInsetBottom;
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        return super.onApplyWindowInsets(insets);
    }

    private void closeDrawerDelayed(int gravity, long delayMs) {
        switch (gravity) {
            case 48: {
                this.mMainThreadHandler.removeCallbacks((Runnable)this.mCloseTopPeekRunnable);
                this.mMainThreadHandler.postDelayed((Runnable)this.mCloseTopPeekRunnable, delayMs);
                break;
            }
            case 80: {
                this.mMainThreadHandler.removeCallbacks((Runnable)this.mCloseBottomPeekRunnable);
                this.mMainThreadHandler.postDelayed((Runnable)this.mCloseBottomPeekRunnable, delayMs);
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Invoked a delayed drawer close with an invalid gravity: " + gravity));
            }
        }
    }

    void closeDrawer(int gravity) {
        this.closeDrawer(this.findDrawerWithGravity(gravity));
    }

    void closeDrawer(WearableDrawerView drawer) {
        if (drawer == null) {
            return;
        }
        if (drawer == this.mTopDrawerView) {
            this.mTopDrawerDragger.smoothSlideViewTo((View)this.mTopDrawerView, 0, -this.mTopDrawerView.getHeight());
            this.invalidate();
        } else if (drawer == this.mBottomDrawerView) {
            this.mBottomDrawerDragger.smoothSlideViewTo((View)this.mBottomDrawerView, 0, this.getHeight());
            this.invalidate();
        } else {
            Log.w((String)TAG, (String)"closeDrawer(View) should be passed in the top or bottom drawer");
        }
    }

    void openDrawer(int gravity) {
        if (!this.isLaidOut()) {
            switch (gravity) {
                case 48: {
                    this.mShouldOpenTopDrawerAfterLayout = true;
                    break;
                }
                case 80: {
                    this.mShouldOpenBottomDrawerAfterLayout = true;
                    break;
                }
            }
            return;
        }
        this.openDrawer(this.findDrawerWithGravity(gravity));
    }

    void openDrawer(WearableDrawerView drawer) {
        if (drawer == null) {
            return;
        }
        if (!this.isLaidOut()) {
            if (drawer == this.mTopDrawerView) {
                this.mShouldOpenTopDrawerAfterLayout = true;
            } else if (drawer == this.mBottomDrawerView) {
                this.mShouldOpenBottomDrawerAfterLayout = true;
            }
            return;
        }
        if (drawer == this.mTopDrawerView) {
            this.mTopDrawerDragger.smoothSlideViewTo((View)this.mTopDrawerView, 0, 0);
            WearableDrawerLayout.showDrawerContentMaybeAnimate(this.mTopDrawerView);
            this.invalidate();
        } else if (drawer == this.mBottomDrawerView) {
            this.mBottomDrawerDragger.smoothSlideViewTo((View)this.mBottomDrawerView, 0, this.getHeight() - this.mBottomDrawerView.getHeight());
            WearableDrawerLayout.showDrawerContentMaybeAnimate(this.mBottomDrawerView);
            this.invalidate();
        } else {
            Log.w((String)TAG, (String)"openDrawer(View) should be passed in the top or bottom drawer");
        }
    }

    void peekDrawer(int gravity) {
        if (!this.isLaidOut()) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"WearableDrawerLayout not laid out yet. Postponing peek.");
            }
            switch (gravity) {
                case 48: {
                    this.mShouldPeekTopDrawerAfterLayout = true;
                    break;
                }
                case 80: {
                    this.mShouldPeekBottomDrawerAfterLayout = true;
                    break;
                }
            }
            return;
        }
        WearableDrawerView drawerView = this.findDrawerWithGravity(gravity);
        this.maybePeekDrawer(drawerView);
    }

    void peekDrawer(WearableDrawerView drawer) {
        if (drawer == null) {
            throw new IllegalArgumentException("peekDrawer(WearableDrawerView) received a null drawer.");
        }
        if (drawer != this.mTopDrawerView && drawer != this.mBottomDrawerView) {
            throw new IllegalArgumentException("peekDrawer(WearableDrawerView) received a drawer that isn't a child.");
        }
        if (!this.isLaidOut()) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"WearableDrawerLayout not laid out yet. Postponing peek.");
            }
            if (drawer == this.mTopDrawerView) {
                this.mShouldPeekTopDrawerAfterLayout = true;
            } else if (drawer == this.mBottomDrawerView) {
                this.mShouldPeekBottomDrawerAfterLayout = true;
            }
            return;
        }
        this.maybePeekDrawer(drawer);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mBottomDrawerView != null && this.mBottomDrawerView.isOpened() && !this.mCanBottomDrawerBeClosed || this.mTopDrawerView != null && this.mTopDrawerView.isOpened() && !this.mCanTopDrawerBeClosed) {
            this.mDrawerOpenLastInterceptedTouchEvent = ev;
            return false;
        }
        boolean shouldInterceptTop = this.mTopDrawerDragger.shouldInterceptTouchEvent(ev);
        boolean shouldInterceptBottom = this.mBottomDrawerDragger.shouldInterceptTouchEvent(ev);
        return shouldInterceptTop || shouldInterceptBottom;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev == null) {
            Log.w((String)TAG, (String)"null MotionEvent passed to onTouchEvent");
            return false;
        }
        this.mTopDrawerDragger.processTouchEvent(ev);
        this.mBottomDrawerDragger.processTouchEvent(ev);
        return true;
    }

    public void computeScroll() {
        boolean topSettling = this.mTopDrawerDragger.continueSettling(true);
        boolean bottomSettling = this.mBottomDrawerDragger.continueSettling(true);
        if (topSettling || bottomSettling) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        WearableDrawerView drawerView;
        super.addView(child, index, params);
        if (!(child instanceof WearableDrawerView)) {
            return;
        }
        WearableDrawerView drawerChild = (WearableDrawerView)child;
        drawerChild.setDrawerController(new WearableDrawerController(this, drawerChild));
        int childGravity = ((FrameLayout.LayoutParams)params).gravity;
        if (childGravity == 0 || childGravity == -1) {
            ((FrameLayout.LayoutParams)params).gravity = drawerChild.preferGravity();
            childGravity = drawerChild.preferGravity();
            drawerChild.setLayoutParams(params);
        }
        if ((drawerView = childGravity == 48 ? (this.mTopDrawerView = drawerChild) : (childGravity == 80 ? (this.mBottomDrawerView = drawerChild) : null)) != null) {
            drawerView.addOnLayoutChangeListener(this);
        }
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (v == this.mTopDrawerView) {
            float openedPercent = this.mTopDrawerView.getOpenedPercent();
            int height = v.getHeight();
            int childTop = -height + (int)((float)height * openedPercent);
            v.layout(v.getLeft(), childTop, v.getRight(), childTop + height);
        } else if (v == this.mBottomDrawerView) {
            float openedPercent = this.mBottomDrawerView.getOpenedPercent();
            int height = v.getHeight();
            int childTop = (int)((float)this.getHeight() - (float)height * openedPercent);
            v.layout(v.getLeft(), childTop, v.getRight(), childTop + height);
        }
    }

    public void setDrawerStateCallback(DrawerStateCallback callback) {
        this.mDrawerStateCallback = callback;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mShouldPeekBottomDrawerAfterLayout || this.mShouldPeekTopDrawerAfterLayout || this.mShouldOpenTopDrawerAfterLayout || this.mShouldOpenBottomDrawerAfterLayout) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    WearableDrawerLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    if (WearableDrawerLayout.this.mShouldOpenBottomDrawerAfterLayout) {
                        WearableDrawerLayout.this.openDrawerWithoutAnimation(WearableDrawerLayout.this.mBottomDrawerView);
                        WearableDrawerLayout.this.mShouldOpenBottomDrawerAfterLayout = false;
                    } else if (WearableDrawerLayout.this.mShouldPeekBottomDrawerAfterLayout) {
                        WearableDrawerLayout.this.peekDrawer(80);
                        WearableDrawerLayout.this.mShouldPeekBottomDrawerAfterLayout = false;
                    }
                    if (WearableDrawerLayout.this.mShouldOpenTopDrawerAfterLayout) {
                        WearableDrawerLayout.this.openDrawerWithoutAnimation(WearableDrawerLayout.this.mTopDrawerView);
                        WearableDrawerLayout.this.mShouldOpenTopDrawerAfterLayout = false;
                    } else if (WearableDrawerLayout.this.mShouldPeekTopDrawerAfterLayout) {
                        WearableDrawerLayout.this.peekDrawer(48);
                        WearableDrawerLayout.this.mShouldPeekTopDrawerAfterLayout = false;
                    }
                }
            });
        }
    }

    @Override
    public void onFlingComplete(View view) {
        boolean canTopPeek = this.mTopDrawerView != null && this.mTopDrawerView.isAutoPeekEnabled();
        boolean canBottomPeek = this.mBottomDrawerView != null && this.mBottomDrawerView.isAutoPeekEnabled();
        boolean canScrollUp = view.canScrollVertically(-1);
        boolean canScrollDown = view.canScrollVertically(1);
        if (canTopPeek && !canScrollUp && !this.mTopDrawerView.isPeeking()) {
            this.peekDrawer(48);
        }
        if (!(!canBottomPeek || canScrollUp && canScrollDown || this.mBottomDrawerView.isPeeking())) {
            this.peekDrawer(80);
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public boolean onNestedFling(@NonNull View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public boolean onNestedPreFling(@NonNull View target, float velocityX, float velocityY) {
        FlingWatcherFactory.FlingWatcher flingWatcher;
        this.maybeUpdateScrollingContentView(target);
        this.mLastScrollWasFling = true;
        if (target == this.mScrollingContentView && (flingWatcher = this.mFlingWatcher.getFor(this.mScrollingContentView)) != null) {
            flingWatcher.watch();
        }
        return false;
    }

    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed) {
        this.maybeUpdateScrollingContentView(target);
    }

    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        boolean shouldPeekOnScrollDown;
        boolean overScrolledDown;
        boolean scrolledUp = dyConsumed < 0;
        boolean scrolledDown = dyConsumed > 0;
        boolean overScrolledUp = dyUnconsumed < 0;
        boolean bl = overScrolledDown = dyUnconsumed > 0;
        if (this.mTopDrawerView != null && this.mTopDrawerView.isOpened()) {
            boolean bl2 = this.mCanTopDrawerBeClosed = overScrolledDown || !this.mTopDrawerView.getDrawerContent().canScrollVertically(1);
            if (this.mCanTopDrawerBeClosed && this.mLastScrollWasFling) {
                this.onTouchEvent(this.mDrawerOpenLastInterceptedTouchEvent);
            }
            this.mLastScrollWasFling = false;
            return;
        }
        if (this.mBottomDrawerView != null && this.mBottomDrawerView.isOpened()) {
            this.mCanBottomDrawerBeClosed = overScrolledUp;
            if (this.mCanBottomDrawerBeClosed && this.mLastScrollWasFling) {
                this.onTouchEvent(this.mDrawerOpenLastInterceptedTouchEvent);
            }
            this.mLastScrollWasFling = false;
            return;
        }
        this.mLastScrollWasFling = false;
        boolean canTopAutoPeek = this.mTopDrawerView != null && this.mTopDrawerView.isAutoPeekEnabled();
        boolean canBottomAutoPeek = this.mBottomDrawerView != null && this.mBottomDrawerView.isAutoPeekEnabled();
        boolean isTopDrawerPeeking = this.mTopDrawerView != null && this.mTopDrawerView.isPeeking();
        boolean isBottomDrawerPeeking = this.mBottomDrawerView != null && this.mBottomDrawerView.isPeeking();
        boolean scrolledDownPastSlop = false;
        boolean bl3 = shouldPeekOnScrollDown = this.mBottomDrawerView != null && this.mBottomDrawerView.isPeekOnScrollDownEnabled();
        if (scrolledDown) {
            this.mCurrentNestedScrollSlopTracker += dyConsumed;
            boolean bl4 = scrolledDownPastSlop = this.mCurrentNestedScrollSlopTracker > this.mNestedScrollSlopPx;
        }
        if (canTopAutoPeek) {
            if (overScrolledUp && !isTopDrawerPeeking) {
                this.peekDrawer(48);
            } else if (scrolledDown && isTopDrawerPeeking && !this.isClosingPeek(this.mTopDrawerView)) {
                this.closeDrawer(48);
            }
        }
        if (canBottomAutoPeek) {
            if ((overScrolledDown || overScrolledUp) && !isBottomDrawerPeeking) {
                this.peekDrawer(80);
            } else if (shouldPeekOnScrollDown && scrolledDownPastSlop && !isBottomDrawerPeeking) {
                this.peekDrawer(80);
            } else if ((scrolledUp || !shouldPeekOnScrollDown && scrolledDown) && isBottomDrawerPeeking && !this.isClosingPeek(this.mBottomDrawerView)) {
                this.closeDrawer(this.mBottomDrawerView);
            }
        }
    }

    private void maybePeekDrawer(WearableDrawerView drawerView) {
        if (drawerView == null) {
            return;
        }
        ViewGroup peekView = drawerView.getPeekContainer();
        if (peekView == null) {
            return;
        }
        View drawerContent = drawerView.getDrawerContent();
        int layoutGravity = ((FrameLayout.LayoutParams)drawerView.getLayoutParams()).gravity;
        int gravity = layoutGravity == 0 ? drawerView.preferGravity() : layoutGravity;
        drawerView.setIsPeeking(true);
        peekView.setAlpha(1.0f);
        peekView.setScaleX(1.0f);
        peekView.setScaleY(1.0f);
        peekView.setVisibility(0);
        if (drawerContent != null) {
            drawerContent.setAlpha(0.0f);
            drawerContent.setVisibility(8);
        }
        if (gravity == 80) {
            this.mBottomDrawerDragger.smoothSlideViewTo((View)drawerView, 0, this.getHeight() - peekView.getHeight());
        } else if (gravity == 48) {
            this.mTopDrawerDragger.smoothSlideViewTo((View)drawerView, 0, -(drawerView.getHeight() - peekView.getHeight()));
            if (!this.mIsAccessibilityEnabled) {
                this.closeDrawerDelayed(gravity, 1000L);
            }
        }
        this.invalidate();
    }

    private void openDrawerWithoutAnimation(WearableDrawerView drawer) {
        int offset;
        if (drawer == null) {
            return;
        }
        if (drawer == this.mTopDrawerView) {
            offset = this.mTopDrawerView.getHeight();
        } else if (drawer == this.mBottomDrawerView) {
            offset = -this.mBottomDrawerView.getHeight();
        } else {
            Log.w((String)TAG, (String)"openDrawer(View) should be passed in the top or bottom drawer");
            return;
        }
        drawer.offsetTopAndBottom(offset);
        drawer.setOpenedPercent(1.0f);
        drawer.onDrawerOpened();
        if (this.mDrawerStateCallback != null) {
            this.mDrawerStateCallback.onDrawerOpened(this, drawer);
        }
        WearableDrawerLayout.showDrawerContentMaybeAnimate(drawer);
        this.invalidate();
    }

    @Nullable
    private WearableDrawerView findDrawerWithGravity(int gravity) {
        switch (gravity) {
            case 48: {
                return this.mTopDrawerView;
            }
            case 80: {
                return this.mBottomDrawerView;
            }
        }
        Log.w((String)TAG, (String)("Invalid drawer gravity: " + gravity));
        return null;
    }

    private void maybeUpdateScrollingContentView(View view) {
        if (view != this.mScrollingContentView && !this.isDrawerOrChildOfDrawer(view)) {
            this.mScrollingContentView = view;
        }
    }

    private boolean isDrawerOrChildOfDrawer(View view) {
        while (view != null && view != this) {
            if (view instanceof WearableDrawerView) {
                return true;
            }
            view = (View)view.getParent();
        }
        return false;
    }

    private boolean isClosingPeek(WearableDrawerView drawerView) {
        return drawerView != null && drawerView.getDrawerState() == 2;
    }

    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
    }

    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
        this.mCurrentNestedScrollSlopTracker = 0;
        return true;
    }

    public void onStopNestedScroll(@NonNull View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
    }

    private boolean canDrawerContentScrollVertically(@Nullable WearableDrawerView drawerView, int direction) {
        if (drawerView == null) {
            return false;
        }
        View drawerContent = drawerView.getDrawerContent();
        if (drawerContent == null) {
            return false;
        }
        return drawerContent.canScrollVertically(direction);
    }

    private void allowAccessibilityFocusOnAllChildren() {
        if (!this.mIsAccessibilityEnabled) {
            return;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setImportantForAccessibility(1);
        }
    }

    private void allowAccessibilityFocusOnOnly(WearableDrawerView drawer) {
        if (!this.mIsAccessibilityEnabled) {
            return;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child == drawer) continue;
            child.setImportantForAccessibility(4);
        }
    }

    private class ClosePeekRunnable
    implements Runnable {
        private final int mGravity;

        private ClosePeekRunnable(int gravity) {
            this.mGravity = gravity;
        }

        @Override
        public void run() {
            WearableDrawerView drawer = WearableDrawerLayout.this.findDrawerWithGravity(this.mGravity);
            if (drawer != null && !drawer.isOpened() && drawer.getDrawerState() == 0) {
                WearableDrawerLayout.this.closeDrawer(this.mGravity);
            }
        }
    }

    private class BottomDrawerDraggerCallback
    extends DrawerDraggerCallback {
        private BottomDrawerDraggerCallback() {
        }

        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            if (WearableDrawerLayout.this.mBottomDrawerView == child) {
                int parentHeight = WearableDrawerLayout.this.getHeight();
                int peekHeight = WearableDrawerLayout.this.mBottomDrawerView.getPeekContainer().getHeight();
                return Math.max(parentHeight - child.getHeight(), Math.min(top, parentHeight - peekHeight));
            }
            return 0;
        }

        public void onEdgeDragStarted(int edgeFlags, int pointerId) {
            if (!(WearableDrawerLayout.this.mBottomDrawerView == null || edgeFlags != 8 || WearableDrawerLayout.this.mBottomDrawerView.isLocked() || WearableDrawerLayout.this.mTopDrawerView != null && WearableDrawerLayout.this.mTopDrawerView.isOpened() || WearableDrawerLayout.this.mBottomDrawerView.getDrawerContent() == null)) {
                WearableDrawerLayout.this.mBottomDrawerDragger.captureChildView((View)WearableDrawerLayout.this.mBottomDrawerView, pointerId);
            }
        }

        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            if (releasedChild == WearableDrawerLayout.this.mBottomDrawerView) {
                int finalTop;
                int parentHeight = WearableDrawerLayout.this.getHeight();
                float openedPercent = WearableDrawerLayout.this.mBottomDrawerView.getOpenedPercent();
                if (yvel < 0.0f || yvel == 0.0f && openedPercent > 0.5f) {
                    finalTop = parentHeight - releasedChild.getHeight();
                } else {
                    WearableDrawerLayout.animatePeekVisibleAfterBeingClosed(WearableDrawerLayout.this.mBottomDrawerView);
                    finalTop = WearableDrawerLayout.this.getHeight() - WearableDrawerLayout.this.mBottomDrawerView.getPeekContainer().getHeight();
                }
                WearableDrawerLayout.this.mBottomDrawerDragger.settleCapturedViewAt(0, finalTop);
                WearableDrawerLayout.this.invalidate();
            }
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            if (changedView == WearableDrawerLayout.this.mBottomDrawerView) {
                int height = changedView.getHeight();
                int parentHeight = WearableDrawerLayout.this.getHeight();
                WearableDrawerLayout.this.mBottomDrawerView.setOpenedPercent((float)(parentHeight - top) / (float)height);
                WearableDrawerLayout.this.invalidate();
            }
        }

        @Override
        public WearableDrawerView getDrawerView() {
            return WearableDrawerLayout.this.mBottomDrawerView;
        }
    }

    private class TopDrawerDraggerCallback
    extends DrawerDraggerCallback {
        private TopDrawerDraggerCallback() {
        }

        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            if (WearableDrawerLayout.this.mTopDrawerView == child) {
                int peekHeight = WearableDrawerLayout.this.mTopDrawerView.getPeekContainer().getHeight();
                return Math.max(peekHeight - child.getHeight(), Math.min(top, 0));
            }
            return 0;
        }

        public void onEdgeDragStarted(int edgeFlags, int pointerId) {
            if (!(WearableDrawerLayout.this.mTopDrawerView == null || edgeFlags != 4 || WearableDrawerLayout.this.mTopDrawerView.isLocked() || WearableDrawerLayout.this.mBottomDrawerView != null && WearableDrawerLayout.this.mBottomDrawerView.isOpened() || WearableDrawerLayout.this.mTopDrawerView.getDrawerContent() == null)) {
                boolean atTop;
                boolean bl = atTop = WearableDrawerLayout.this.mScrollingContentView == null || !WearableDrawerLayout.this.mScrollingContentView.canScrollVertically(-1);
                if (!WearableDrawerLayout.this.mTopDrawerView.isOpenOnlyAtTopEnabled() || atTop) {
                    WearableDrawerLayout.this.mTopDrawerDragger.captureChildView((View)WearableDrawerLayout.this.mTopDrawerView, pointerId);
                }
            }
        }

        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            if (releasedChild == WearableDrawerLayout.this.mTopDrawerView) {
                int finalTop;
                float openedPercent = WearableDrawerLayout.this.mTopDrawerView.getOpenedPercent();
                if (yvel > 0.0f || yvel == 0.0f && openedPercent > 0.5f) {
                    finalTop = 0;
                } else {
                    WearableDrawerLayout.animatePeekVisibleAfterBeingClosed(WearableDrawerLayout.this.mTopDrawerView);
                    finalTop = WearableDrawerLayout.this.mTopDrawerView.getPeekContainer().getHeight() - releasedChild.getHeight();
                }
                WearableDrawerLayout.this.mTopDrawerDragger.settleCapturedViewAt(0, finalTop);
                WearableDrawerLayout.this.invalidate();
            }
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            if (changedView == WearableDrawerLayout.this.mTopDrawerView) {
                int height = changedView.getHeight();
                WearableDrawerLayout.this.mTopDrawerView.setOpenedPercent((float)(top + height) / (float)height);
                WearableDrawerLayout.this.invalidate();
            }
        }

        @Override
        public WearableDrawerView getDrawerView() {
            return WearableDrawerLayout.this.mTopDrawerView;
        }
    }

    private abstract class DrawerDraggerCallback
    extends ViewDragHelper.Callback {
        private DrawerDraggerCallback() {
        }

        public abstract WearableDrawerView getDrawerView();

        public boolean tryCaptureView(@NonNull View child, int pointerId) {
            WearableDrawerView drawerView = this.getDrawerView();
            return child == drawerView && !drawerView.isLocked() && drawerView.getDrawerContent() != null;
        }

        public int getViewVerticalDragRange(@NonNull View child) {
            return child == this.getDrawerView() ? child.getHeight() : 0;
        }

        public void onViewCaptured(@NonNull View capturedChild, int activePointerId) {
            WearableDrawerLayout.showDrawerContentMaybeAnimate((WearableDrawerView)capturedChild);
        }

        public void onViewDragStateChanged(int state) {
            WearableDrawerView drawerView = this.getDrawerView();
            switch (state) {
                case 0: {
                    boolean openedOrClosed = false;
                    if (drawerView.isOpened()) {
                        openedOrClosed = true;
                        drawerView.onDrawerOpened();
                        WearableDrawerLayout.this.allowAccessibilityFocusOnOnly(drawerView);
                        if (WearableDrawerLayout.this.mDrawerStateCallback != null) {
                            WearableDrawerLayout.this.mDrawerStateCallback.onDrawerOpened(WearableDrawerLayout.this, drawerView);
                        }
                        WearableDrawerLayout.this.mCanTopDrawerBeClosed = !WearableDrawerLayout.this.canDrawerContentScrollVertically(WearableDrawerLayout.this.mTopDrawerView, 1);
                        WearableDrawerLayout.this.mCanBottomDrawerBeClosed = !WearableDrawerLayout.this.canDrawerContentScrollVertically(WearableDrawerLayout.this.mBottomDrawerView, -1);
                    } else if (drawerView.isClosed()) {
                        openedOrClosed = true;
                        drawerView.onDrawerClosed();
                        WearableDrawerLayout.this.allowAccessibilityFocusOnAllChildren();
                        if (WearableDrawerLayout.this.mDrawerStateCallback != null) {
                            WearableDrawerLayout.this.mDrawerStateCallback.onDrawerClosed(WearableDrawerLayout.this, drawerView);
                        }
                    } else {
                        WearableDrawerLayout.this.allowAccessibilityFocusOnAllChildren();
                    }
                    if (!openedOrClosed || !drawerView.isPeeking()) break;
                    drawerView.setIsPeeking(false);
                    drawerView.getPeekContainer().setVisibility(4);
                    break;
                }
            }
            if (drawerView.getDrawerState() != state) {
                drawerView.setDrawerState(state);
                drawerView.onDrawerStateChanged(state);
                if (WearableDrawerLayout.this.mDrawerStateCallback != null) {
                    WearableDrawerLayout.this.mDrawerStateCallback.onDrawerStateChanged(WearableDrawerLayout.this, state);
                }
            }
        }
    }

    public static class DrawerStateCallback {
        public void onDrawerOpened(WearableDrawerLayout layout2, WearableDrawerView drawerView) {
        }

        public void onDrawerClosed(WearableDrawerLayout layout2, WearableDrawerView drawerView) {
        }

        public void onDrawerStateChanged(WearableDrawerLayout layout2, int newState) {
        }
    }
}

