/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget.drawer;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.wear.R;
import android.support.wear.internal.widget.drawer.MultiPagePresenter;
import android.support.wear.internal.widget.drawer.MultiPageUi;
import android.support.wear.internal.widget.drawer.SinglePagePresenter;
import android.support.wear.internal.widget.drawer.SinglePageUi;
import android.support.wear.internal.widget.drawer.WearableNavigationDrawerPresenter;
import android.support.wear.widget.drawer.WearableDrawerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.TimeUnit;

public class WearableNavigationDrawerView
extends WearableDrawerView {
    private static final String TAG = "WearableNavDrawer";
    public static final int SINGLE_PAGE = 0;
    public static final int MULTI_PAGE = 1;
    private static final int DEFAULT_STYLE = 0;
    private static final long AUTO_CLOSE_DRAWER_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
    private final boolean mIsAccessibilityEnabled;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private final Runnable mCloseDrawerRunnable = new Runnable(){

        @Override
        public void run() {
            WearableNavigationDrawerView.this.getController().closeDrawer();
        }
    };
    @Nullable
    private final GestureDetector mGestureDetector;
    private final int mNavigationStyle;
    private final WearableNavigationDrawerPresenter mPresenter;
    private final GestureDetector.SimpleOnGestureListener mOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onSingleTapUp(MotionEvent e) {
            return WearableNavigationDrawerView.this.mPresenter.onDrawerTapped();
        }
    };

    public WearableNavigationDrawerView(Context context) {
        this(context, null);
    }

    public WearableNavigationDrawerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearableNavigationDrawerView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public WearableNavigationDrawerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this.mOnGestureListener);
        int navStyle = 0;
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.WearableNavigationDrawerView, defStyleAttr, 0);
            navStyle = typedArray.getInt(R.styleable.WearableNavigationDrawerView_navigationStyle, 0);
            typedArray.recycle();
        }
        this.mNavigationStyle = navStyle;
        AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        this.mIsAccessibilityEnabled = accessibilityManager.isEnabled();
        this.mPresenter = this.mNavigationStyle == 0 ? new SinglePagePresenter(new SinglePageUi(this), this.mIsAccessibilityEnabled) : new MultiPagePresenter(this, new MultiPageUi(), this.mIsAccessibilityEnabled);
        this.getPeekContainer().setContentDescription((CharSequence)context.getString(R.string.ws_navigation_drawer_content_description));
        this.setOpenOnlyAtTopEnabled(true);
    }

    public void setAdapter(WearableNavigationDrawerAdapter adapter) {
        this.mPresenter.onNewAdapter(adapter);
    }

    public void addOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mPresenter.onItemSelectedListenerAdded(listener);
    }

    public void removeOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mPresenter.onItemSelectedListenerRemoved(listener);
    }

    public void setCurrentItem(int index, boolean smoothScrollTo) {
        this.mPresenter.onSetCurrentItemRequested(index, smoothScrollTo);
    }

    public int getNavigationStyle() {
        return this.mNavigationStyle;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.autoCloseDrawerAfterDelay();
        return this.mGestureDetector != null && this.mGestureDetector.onTouchEvent(ev);
    }

    public boolean canScrollHorizontally(int direction) {
        return this.isOpened();
    }

    @Override
    public void onDrawerOpened() {
        this.autoCloseDrawerAfterDelay();
    }

    @Override
    public void onDrawerClosed() {
        this.mMainThreadHandler.removeCallbacks(this.mCloseDrawerRunnable);
    }

    private void autoCloseDrawerAfterDelay() {
        if (!this.mIsAccessibilityEnabled) {
            this.mMainThreadHandler.removeCallbacks(this.mCloseDrawerRunnable);
            this.mMainThreadHandler.postDelayed(this.mCloseDrawerRunnable, AUTO_CLOSE_DRAWER_DELAY_MS);
        }
    }

    @Override
    int preferGravity() {
        return 48;
    }

    public static abstract class WearableNavigationDrawerAdapter {
        @Nullable
        private WearableNavigationDrawerPresenter mPresenter;

        public abstract CharSequence getItemText(int var1);

        public abstract Drawable getItemDrawable(int var1);

        public abstract int getCount();

        public void notifyDataSetChanged() {
            if (this.mPresenter != null) {
                this.mPresenter.onDataSetChanged();
            } else {
                Log.w((String)WearableNavigationDrawerView.TAG, (String)"adapter.notifyDataSetChanged called before drawer.setAdapter; ignoring.");
            }
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public void setPresenter(WearableNavigationDrawerPresenter presenter) {
            this.mPresenter = presenter;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface NavigationStyle {
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(int var1);
    }
}

