/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics.crash;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.analytics.crash.UploadRateLimiter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class GoogleCrashReporter
implements CrashReporter {
    private static final String CRASH_URL = "https://clients2.google.com/cr/report";
    private static final String STAGING_CRASH_URL = "https://clients2.google.com/cr/staging_report";
    private static final String LOCALE = Locale.getDefault() == null ? "unknown" : Locale.getDefault().toString();
    private static final int REJECTED_UPLOAD_TRIGGER_COUNT = 20;
    private static AtomicInteger ourRejectedExecutionCount = new AtomicInteger();
    private static final ExecutorService ourExecutor = new ThreadPoolExecutor(1, 5, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(5), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("google-crash-pool-%d").build(), (r, executor) -> {
        ourRejectedExecutionCount.incrementAndGet();
        if (ourRejectedExecutionCount.compareAndSet(20, 0)) {
            Logger.getLogger(GoogleCrashReporter.class.getName()).info("Lost 20 crash events due to full queue.");
        }
    });
    protected static final String KEY_PRODUCT_ID = "productId";
    protected static final String KEY_VERSION = "version";
    private static final double MAX_CRASHES_PER_SEC = 0.016666666666666666;
    private final boolean isUnitTestMode;
    private final boolean isDebugBuild;
    private final String crashUrl;
    private final UploadRateLimiter rateLimiter;

    public GoogleCrashReporter(boolean isUnitTestMode, boolean isDebugBuild) {
        this(isUnitTestMode || isDebugBuild ? STAGING_CRASH_URL : CRASH_URL, UploadRateLimiter.create(0.016666666666666666), isUnitTestMode, isDebugBuild);
    }

    @VisibleForTesting
    GoogleCrashReporter(String crashUrl, UploadRateLimiter rateLimiter, boolean isUnitTestMode, boolean isDebugBuild) {
        this.crashUrl = crashUrl;
        this.rateLimiter = rateLimiter;
        this.isUnitTestMode = isUnitTestMode;
        this.isDebugBuild = isDebugBuild;
    }

    @Override
    public CompletableFuture<String> submit(CrashReport report) {
        return this.submit(report, false);
    }

    @Override
    public CompletableFuture<String> submit(CrashReport report, boolean userReported) {
        if (!userReported && !this.rateLimiter.tryAcquire()) {
            CompletableFuture<String> f = new CompletableFuture<String>();
            f.completeExceptionally(new RuntimeException("Exceeded Quota of crashes that can be reported"));
            return f;
        }
        Map<String, String> parameters = this.getDefaultParameters();
        if (report.getVersion() != null) {
            parameters.put(KEY_VERSION, report.getVersion());
        }
        parameters.put(KEY_PRODUCT_ID, report.getProductId());
        report.overrideDefaultParameters(parameters);
        MultipartEntityBuilder builder = GoogleCrashReporter.newMultipartEntityBuilderWithKv(parameters);
        report.serialize(builder);
        return this.submit(builder.build());
    }

    @Override
    public CompletableFuture<String> submit(Map<String, String> kv) {
        Map<String, String> parameters = this.getDefaultParameters();
        kv.forEach(parameters::put);
        return this.submit(GoogleCrashReporter.newMultipartEntityBuilderWithKv(parameters).build());
    }

    @Override
    public CompletableFuture<String> submit(HttpEntity requestEntity) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            ourExecutor.submit(() -> {
                try {
                    CloseableHttpClient client = HttpClients.createDefault();
                    HttpEntity entity = requestEntity;
                    if (!this.isUnitTestMode) {
                        entity = new GzipCompressingEntity(requestEntity);
                    }
                    HttpPost post = new HttpPost(this.crashUrl);
                    post.setEntity(entity);
                    HttpResponse response = client.execute((HttpUriRequest)post);
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() >= 300) {
                        future.completeExceptionally((Throwable)new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                        return;
                    }
                    entity = response.getEntity();
                    if (entity == null) {
                        future.completeExceptionally(new NullPointerException("Empty response entity"));
                        return;
                    }
                    String reportId = EntityUtils.toString((HttpEntity)entity);
                    if (this.isDebugBuild) {
                        System.out.println("Report submitted: http://go/crash-staging/" + reportId);
                    }
                    future.complete(reportId);
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return future;
    }

    private static MultipartEntityBuilder newMultipartEntityBuilderWithKv(Map<String, String> kv) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        kv.forEach((arg_0, arg_1) -> ((MultipartEntityBuilder)builder).addTextBody(arg_0, arg_1));
        return builder;
    }

    private Map<String, String> getDefaultParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        map.put("ptime", Long.toString(runtimeMXBean.getUptime()));
        map.put("osName", Strings.nullToEmpty((String)StandardSystemProperty.OS_NAME.value()));
        map.put("osVersion", Strings.nullToEmpty((String)StandardSystemProperty.OS_VERSION.value()));
        map.put("osArch", Strings.nullToEmpty((String)StandardSystemProperty.OS_ARCH.value()));
        map.put("locale", Strings.nullToEmpty((String)LOCALE));
        map.put("vmName", Strings.nullToEmpty((String)runtimeMXBean.getVmName()));
        map.put("vmVendor", Strings.nullToEmpty((String)runtimeMXBean.getVmVendor()));
        map.put("vmVersion", Strings.nullToEmpty((String)runtimeMXBean.getVmVersion()));
        MemoryUsage usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        map.put("heapUsed", Long.toString(usage.getUsed()));
        map.put("heapCommitted", Long.toString(usage.getCommitted()));
        map.put("heapMax", Long.toString(usage.getMax()));
        map.putAll(this.getProductSpecificParams());
        return map;
    }

    protected Map<String, String> getProductSpecificParams() {
        return Collections.emptyMap();
    }
}

