/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.utils.DateProvider;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.UUID;
import kotlin.AutoCloseableKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/analytics/AnalyticsSettings;", "", "()V", "debugDisablePublishing", "", "getDebugDisablePublishing", "()Z", "optedIn", "getOptedIn", "setOptedIn", "(Z)V", "salt", "", "getSalt", "()[B", "saltSkew", "", "saltValue", "Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "userId", "", "getUserId", "()Ljava/lang/String;", "setUserId", "(Ljava/lang/String;)V", "isValid", "saveSettings", "", "Companion", "shared"})
public final class AnalyticsSettings {
    @SerializedName(value="userId")
    @Nullable
    private String userId;
    @SerializedName(value="optedIn")
    private boolean optedIn;
    @SerializedName(value="debugDisablePublishing")
    private final boolean debugDisablePublishing = false;
    @SerializedName(value="saltValue")
    private BigInteger saltValue = BigInteger.valueOf(0L);
    @SerializedName(value="saltSkew")
    private int saltSkew = -1;
    private static final int SALT_SKEW_NOT_INITIALIZED = -1;
    @NotNull
    private static DateProvider dateProvider;
    private static final LocalDate EPOCH;
    private static final transient Object gate;
    private static AnalyticsSettings instance;
    public static final Companion Companion;

    @Nullable
    public final String getUserId() {
        return this.userId;
    }

    public final void setUserId(@Nullable String string) {
        this.userId = string;
    }

    public final boolean getOptedIn() {
        return this.optedIn;
    }

    public final void setOptedIn(boolean bl) {
        this.optedIn = bl;
    }

    public final boolean getDebugDisablePublishing() {
        return this.debugDisablePublishing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getSalt() throws IOException {
        Object object = gate;
        synchronized (object) {
            byte[] blob;
            int currentSaltSkew = Companion.currentSaltSkew();
            if (this.saltSkew != currentSaltSkew) {
                this.saltSkew = currentSaltSkew;
                SecureRandom random = new SecureRandom();
                byte[] data = new byte[24];
                random.nextBytes(data);
                this.saltValue = new BigInteger(data);
                this.saveSettings();
            }
            byte[] fullBlob = blob = this.saltValue.toByteArray();
            if (blob.length < 24) {
                fullBlob = new byte[24];
                System.arraycopy(blob, 0, fullBlob, 0, blob.length);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)fullBlob, (String)"fullBlob");
            byte[] byArray = fullBlob;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveSettings() throws IOException {
        File file = AnalyticsSettings.Companion.getSettingsFile();
        try {
            Closeable closeable = new RandomAccessFile(file, "rw");
            Throwable throwable = null;
            try {
                RandomAccessFile settingsFile = (RandomAccessFile)closeable;
                Closeable closeable2 = settingsFile.getChannel();
                Throwable throwable2 = null;
                try {
                    FileChannel channel = (FileChannel)closeable2;
                    AutoCloseable autoCloseable = channel.tryLock();
                    Throwable throwable3 = null;
                    try {
                        FileLock lock = (FileLock)autoCloseable;
                        if (lock == null) {
                            throw (Throwable)new IOException("Unable to lock settings file " + file.toString());
                        }
                        channel.truncate(0L);
                        OutputStream outputStream = Channels.newOutputStream(channel);
                        Gson gson = new GsonBuilder().create();
                        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                        gson.toJson((Object)this, (Appendable)writer);
                        writer.flush();
                        outputStream.flush();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (OverlappingFileLockException e) {
            throw (Throwable)new IOException("Unable to lock settings file " + file.toString(), e);
        }
    }

    private final boolean isValid() {
        return this.userId != null && (this.saltSkew == -1 || this.saltValue != null);
    }

    static {
        Companion = new Companion(null);
        DateProvider dateProvider = DateProvider.SYSTEM;
        Intrinsics.checkExpressionValueIsNotNull((Object)dateProvider, (String)"DateProvider.SYSTEM");
        AnalyticsSettings.dateProvider = dateProvider;
        EPOCH = LocalDate.ofEpochDay(0L);
        gate = new Object();
    }

    @NotNull
    public static final DateProvider getDateProvider() {
        Companion companion = Companion;
        return dateProvider;
    }

    public static final void setDateProvider(@NotNull DateProvider dateProvider) {
        Companion companion = Companion;
        AnalyticsSettings.dateProvider = dateProvider;
    }

    @JvmStatic
    public static final int currentSaltSkew() {
        return Companion.currentSaltSkew();
    }

    @JvmStatic
    @Nullable
    public static final AnalyticsSettings loadSettings() throws IOException {
        return Companion.loadSettings();
    }

    @JvmStatic
    @NotNull
    public static final AnalyticsSettings createNewAnalyticsSettings() throws IOException {
        return Companion.createNewAnalyticsSettings();
    }

    @JvmStatic
    @NotNull
    public static final AnalyticsSettings getInstance(@NotNull ILogger logger) {
        return Companion.getInstance(logger);
    }

    @JvmStatic
    public static final void setInstanceForTest(@Nullable AnalyticsSettings settings) {
        Companion.setInstanceForTest(settings);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0007J\b\u0010\u0018\u001a\u00020\u0007H\u0007J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0011H\u0007J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0002R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/android/tools/analytics/AnalyticsSettings$Companion;", "", "()V", "EPOCH", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "SALT_SKEW_NOT_INITIALIZED", "", "dateProvider", "Lcom/android/utils/DateProvider;", "dateProvider$annotations", "getDateProvider", "()Lcom/android/utils/DateProvider;", "setDateProvider", "(Lcom/android/utils/DateProvider;)V", "gate", "instance", "Lcom/android/tools/analytics/AnalyticsSettings;", "instance$annotations", "settingsFile", "Ljava/io/File;", "getSettingsFile", "()Ljava/io/File;", "createNewAnalyticsSettings", "currentSaltSkew", "getInstance", "logger", "Lcom/android/utils/ILogger;", "loadSettings", "setInstanceForTest", "", "settings", "shared"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void dateProvider$annotations() {
        }

        @NotNull
        public final DateProvider getDateProvider() {
            return dateProvider;
        }

        public final void setDateProvider(@NotNull DateProvider dateProvider) {
            Intrinsics.checkParameterIsNotNull((Object)dateProvider, (String)"<set-?>");
            AnalyticsSettings.dateProvider = dateProvider;
        }

        @JvmStatic
        private static /* synthetic */ void instance$annotations() {
        }

        @JvmStatic
        public final int currentSaltSkew() {
            Date date = this.getDateProvider().now();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"dateProvider.now()");
            LocalDate now = LocalDate.from(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC));
            long days = ChronoUnit.DAYS.between(EPOCH, now) + (long)3;
            return (int)(days / (long)28);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final AnalyticsSettings loadSettings() throws IOException {
            File file = this.getSettingsFile();
            if (!file.exists()) {
                return this.createNewAnalyticsSettings();
            }
            FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
            try {
                AnalyticsSettings settings = null;
                AutoCloseable autoCloseable = channel.tryLock();
                Throwable throwable = null;
                try {
                    FileLock it = (FileLock)autoCloseable;
                    InputStream inputStream = Channels.newInputStream(channel);
                    Gson gson = new GsonBuilder().create();
                    Object object = gson.fromJson((Reader)new InputStreamReader(inputStream), AnalyticsSettings.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(InputStrea\u2026ticsSettings::class.java)");
                    AnalyticsSettings analyticsSettings = settings = (AnalyticsSettings)object;
                    if (analyticsSettings == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    }
                    instance = analyticsSettings;
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                if (!settings.isValid()) {
                    return this.createNewAnalyticsSettings();
                }
                return settings;
            }
            catch (OverlappingFileLockException e) {
                throw (Throwable)new IOException("Unable to lock settings file " + file.toString(), e);
            }
            catch (JsonParseException e) {
                throw (Throwable)new IOException("Unable to parse settings file " + file.toString(), e);
            }
        }

        @JvmStatic
        @NotNull
        public final AnalyticsSettings createNewAnalyticsSettings() throws IOException {
            AnalyticsSettings settings = new AnalyticsSettings();
            File uidFile = Paths.get(AnalyticsPaths.getAndEnsureAndroidSettingsHome(), "uid.txt").toFile();
            if (uidFile.exists()) {
                try {
                    String uid = Files.readFirstLine((File)uidFile, (Charset)Charsets.UTF_8);
                    settings.setUserId(uid);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (settings.getUserId() == null) {
                settings.setUserId(UUID.randomUUID().toString());
            }
            settings.saveSettings();
            return settings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final AnalyticsSettings getInstance(@NotNull ILogger logger) {
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            Object object = gate;
            synchronized (object) {
                void var3_4;
                block11: {
                    if (instance == null) break block11;
                    AnalyticsSettings analyticsSettings = instance;
                    if (analyticsSettings == null) {
                        Intrinsics.throwNpe();
                    }
                    AnalyticsSettings analyticsSettings2 = analyticsSettings;
                    return analyticsSettings2;
                }
                AnalyticsSettings loaded = null;
                try {
                    loaded = Companion.loadSettings();
                }
                catch (IOException e) {
                    logger.info("Unable to load analytics settings: %s", new Object[]{e.getMessage()});
                }
                if (loaded == null) {
                    try {
                        loaded = Companion.createNewAnalyticsSettings();
                    }
                    catch (IOException e) {
                        logger.info("Unable to create new analytics settings: %s", new Object[]{e.getMessage()});
                    }
                }
                if (loaded == null) {
                    loaded = new AnalyticsSettings();
                    loaded.setUserId(UUID.randomUUID().toString());
                }
                void var6_8 = var3_4;
                return var6_8;
            }
        }

        @JvmStatic
        public final void setInstanceForTest(@Nullable AnalyticsSettings settings) {
            instance = settings;
        }

        private final File getSettingsFile() {
            File file = Paths.get(AnalyticsPaths.getAndEnsureAndroidSettingsHome(), "analytics.settings").toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Paths.get(AnalyticsPaths\u2026ytics.settings\").toFile()");
            return file;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

