/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.JournalingUsageTracker;
import com.android.tools.analytics.NullUsageTracker;
import com.android.utils.DateProvider;
import com.android.utils.ILogger;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ProductDetails;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class UsageTracker
implements AutoCloseable {
    private static final Object sGate = new Object();
    static String sSessionId = UUID.randomUUID().toString();
    public static DateProvider sDateProvider = DateProvider.SYSTEM;
    private static UsageTracker sInstance = new NullUsageTracker(new AnalyticsSettings(), null);
    private static boolean sIsTesting;
    private final AnalyticsSettings mAnalyticsSettings;
    private final ScheduledExecutorService mScheduler;
    private static int sMaxJournalSize;
    private static long sMaxJournalTime;
    private static String sVersion;
    private static AndroidStudioEvent.IdeBrand sIdeBrand;
    protected static long sStartTimeMs;

    protected UsageTracker(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler) {
        this.mAnalyticsSettings = analyticsSettings;
        this.mScheduler = scheduler;
    }

    public static int getMaxJournalSize() {
        return sMaxJournalSize;
    }

    public static void setMaxJournalSize(int maxJournalSize) {
        sMaxJournalSize = maxJournalSize;
    }

    protected void scheduleJournalTimeout(long maxJournalTime) {
    }

    public static long getMaxJournalTime() {
        return sMaxJournalTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxJournalTime(long duration, TimeUnit unit) {
        Object object = sGate;
        synchronized (object) {
            sMaxJournalTime = unit.toNanos(duration);
            sInstance.scheduleJournalTimeout(sMaxJournalTime);
        }
    }

    public static String getVersion() {
        return sVersion;
    }

    public static void setVersion(String version) {
        sVersion = version;
    }

    public static AndroidStudioEvent.IdeBrand getIdeBrand() {
        return sIdeBrand;
    }

    public static void setIdeBrand(AndroidStudioEvent.IdeBrand ideBrand) {
        sIdeBrand = ideBrand;
    }

    public AnalyticsSettings getAnalyticsSettings() {
        return this.mAnalyticsSettings;
    }

    public ScheduledExecutorService getScheduler() {
        return this.mScheduler;
    }

    public void logNow(AndroidStudioEvent.Builder studioEvent) {
        this.logAt(sDateProvider.now().getTime(), studioEvent);
    }

    public void logAt(long eventTimeMs, AndroidStudioEvent.Builder studioEvent) {
        studioEvent.setStudioSessionId(sSessionId);
        studioEvent.setIdeBrand(sIdeBrand);
        if (sVersion != null && !studioEvent.hasProductDetails()) {
            studioEvent.setProductDetails(ProductDetails.newBuilder().setVersion(sVersion));
        }
        try {
            this.logDetails(ClientAnalytics.LogEvent.newBuilder().setEventTimeMs(eventTimeMs).setEventUptimeMs(eventTimeMs - sStartTimeMs).setSourceExtension(studioEvent.build().toByteString()));
        }
        catch (NullPointerException exception) {
            this.logDetails(ClientAnalytics.LogEvent.newBuilder().setEventTimeMs(eventTimeMs).setEventUptimeMs(eventTimeMs - sStartTimeMs));
        }
    }

    public abstract void logDetails(ClientAnalytics.LogEvent.Builder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UsageTracker getInstance() {
        Object object = sGate;
        synchronized (object) {
            return sInstance;
        }
    }

    public static void log(AndroidStudioEvent.Builder studioEvent) {
        UsageTracker.getInstance().logNow(studioEvent);
    }

    public static void log(long eventTimeMs, AndroidStudioEvent.Builder studioEvent) {
        UsageTracker.getInstance().logAt(eventTimeMs, studioEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsageTracker initialize(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler) {
        Object object = sGate;
        synchronized (object) {
            UsageTracker oldInstance = sInstance;
            if (analyticsSettings.hasOptedIn()) {
                try {
                    sInstance = new JournalingUsageTracker(analyticsSettings, scheduler, Paths.get(AnalyticsPaths.getSpoolDirectory(), new String[0]));
                }
                catch (RuntimeException ex) {
                    sInstance = new NullUsageTracker(analyticsSettings, scheduler);
                    throw ex;
                }
            } else {
                sInstance = new NullUsageTracker(analyticsSettings, scheduler);
            }
            try {
                oldInstance.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to close usage tracker", ex);
            }
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsageTracker getInstanceForTest() {
        Object object = sGate;
        synchronized (object) {
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsageTracker setInstanceForTest(UsageTracker tracker) {
        Object object = sGate;
        synchronized (object) {
            sIsTesting = true;
            UsageTracker old = sInstance;
            sInstance = tracker;
            sStartTimeMs = sDateProvider.now().getTime();
            return old;
        }
    }

    public static void cleanAfterTesting() {
        sIsTesting = false;
        sInstance = new NullUsageTracker(new AnalyticsSettings(), null);
    }

    public static AnalyticsSettings updateSettingsAndTracker(boolean optIn, ILogger logger, ScheduledExecutorService scheduler) {
        AnalyticsSettings settings = AnalyticsSettings.getInstance((ILogger)logger);
        if (sIsTesting) {
            return settings;
        }
        if (optIn != settings.hasOptedIn()) {
            settings.setHasOptedIn(optIn);
            try {
                settings.saveSettings();
            }
            catch (IOException e) {
                logger.error((Throwable)e, "Unable to save analytics settings", new Object[0]);
            }
        }
        try {
            UsageTracker.initialize(settings, scheduler);
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Unable to initialize analytics tracker", new Object[0]);
        }
        return settings;
    }

    static {
        sIdeBrand = AndroidStudioEvent.IdeBrand.UNKNOWN_IDE_BRAND;
        sStartTimeMs = sDateProvider.now().getTime();
    }
}

