/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.CountersKt;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001c\u001a\u00020\u001dJ\"\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!H\u0082\b\u00a2\u0006\u0002\u0010\"J\u001f\u0010#\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0$\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020'J\b\u0010(\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR\u000e\u0010\u0019\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\f\u00a8\u0006)"}, d2={"Lcom/android/tools/analytics/Counter;", "", "name", "", "(Ljava/lang/String;)V", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "maxCpu", "Ljava/util/concurrent/atomic/AtomicLong;", "maxCpuNanos", "", "getMaxCpuNanos", "()J", "maxWall", "maxWallNanos", "getMaxWallNanos", "getName", "()Ljava/lang/String;", "totalCount", "", "getTotalCount", "()I", "totalCpu", "totalCpuNanos", "getTotalCpuNanos", "totalWall", "totalWallNanos", "getTotalWallNanos", "reset", "", "time", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "timeCallable", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)Ljava/lang/Object;", "timeRunnable", "Ljava/lang/Runnable;", "toString", "tracker"})
public final class Counter {
    private final AtomicLong totalCpu;
    private final AtomicLong totalWall;
    private final AtomicLong maxCpu;
    private final AtomicLong maxWall;
    private final AtomicInteger count;
    @NotNull
    private final String name;

    public final long getTotalCpuNanos() {
        return this.totalCpu.get();
    }

    public final long getTotalWallNanos() {
        return this.totalWall.get();
    }

    public final long getMaxCpuNanos() {
        return this.maxCpu.get();
    }

    public final long getMaxWallNanos() {
        return this.maxWall.get();
    }

    public final int getTotalCount() {
        return this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R timeCallable(@NotNull Callable<R> block) {
        R r;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        Counter this_$iv = this;
        boolean $i$f$time = false;
        long startCpu$iv = CountersKt.access$getCurrentCpuTimeNano$p();
        long startWall$iv = CountersKt.access$getCurrentTimeNano$p();
        try {
            boolean bl = false;
            r = block.call();
        }
        catch (Throwable throwable) {
            long deltaCpu$iv = CountersKt.access$getCurrentCpuTimeNano$p() - startCpu$iv;
            long deltaWall$iv = CountersKt.access$getCurrentTimeNano$p() - startWall$iv;
            this_$iv.totalCpu.addAndGet(deltaCpu$iv);
            this_$iv.totalWall.addAndGet(deltaWall$iv);
            this_$iv.maxCpu.updateAndGet(new LongUnaryOperator(deltaCpu$iv){
                final /* synthetic */ long $deltaCpu;

                public final long applyAsLong(long it) {
                    long l = this.$deltaCpu;
                    return Math.max(it, l);
                }
                {
                    this.$deltaCpu = l;
                }
            });
            this_$iv.maxWall.updateAndGet(new LongUnaryOperator(deltaWall$iv){
                final /* synthetic */ long $deltaWall;

                public final long applyAsLong(long it) {
                    long l = this.$deltaWall;
                    return Math.max(it, l);
                }
                {
                    this.$deltaWall = l;
                }
            });
            this_$iv.count.incrementAndGet();
            throw throwable;
        }
        long deltaCpu$iv = CountersKt.access$getCurrentCpuTimeNano$p() - startCpu$iv;
        long deltaWall$iv = CountersKt.access$getCurrentTimeNano$p() - startWall$iv;
        this_$iv.totalCpu.addAndGet(deltaCpu$iv);
        this_$iv.totalWall.addAndGet(deltaWall$iv);
        this_$iv.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this_$iv.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this_$iv.count.incrementAndGet();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void timeRunnable(@NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        Counter this_$iv = this;
        boolean $i$f$time = false;
        long startCpu$iv = CountersKt.access$getCurrentCpuTimeNano$p();
        long startWall$iv = CountersKt.access$getCurrentTimeNano$p();
        try {
            boolean bl = false;
            block.run();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            long deltaCpu$iv = CountersKt.access$getCurrentCpuTimeNano$p() - startCpu$iv;
            long deltaWall$iv = CountersKt.access$getCurrentTimeNano$p() - startWall$iv;
            this_$iv.totalCpu.addAndGet(deltaCpu$iv);
            this_$iv.totalWall.addAndGet(deltaWall$iv);
            this_$iv.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
            this_$iv.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
            this_$iv.count.incrementAndGet();
            throw throwable;
        }
        long deltaCpu$iv = CountersKt.access$getCurrentCpuTimeNano$p() - startCpu$iv;
        long deltaWall$iv = CountersKt.access$getCurrentTimeNano$p() - startWall$iv;
        this_$iv.totalCpu.addAndGet(deltaCpu$iv);
        this_$iv.totalWall.addAndGet(deltaWall$iv);
        this_$iv.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this_$iv.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this_$iv.count.incrementAndGet();
    }

    public final void reset() {
        this.totalCpu.set(0L);
        this.totalWall.set(0L);
        this.maxCpu.set(0L);
        this.maxWall.set(0L);
        this.count.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R time(Function0<? extends R> block) {
        Object object;
        int $i$f$time = 0;
        long startCpu = CountersKt.access$getCurrentCpuTimeNano$p();
        long startWall = CountersKt.access$getCurrentTimeNano$p();
        try {
            object = block.invoke();
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            long deltaCpu = CountersKt.access$getCurrentCpuTimeNano$p() - startCpu;
            long deltaWall = CountersKt.access$getCurrentTimeNano$p() - startWall;
            this.totalCpu.addAndGet(deltaCpu);
            this.totalWall.addAndGet(deltaWall);
            this.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
            this.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
            this.count.incrementAndGet();
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        long deltaCpu = CountersKt.access$getCurrentCpuTimeNano$p() - startCpu;
        long deltaWall = CountersKt.access$getCurrentTimeNano$p() - startWall;
        this.totalCpu.addAndGet(deltaCpu);
        this.totalWall.addAndGet(deltaWall);
        this.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this.count.incrementAndGet();
        InlineMarker.finallyEnd((int)1);
        return (R)object;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        boolean bl = false;
        int totalCount = this.count.get();
        if (totalCount > 0) {
            double avgCpuMicros = (double)(this.getTotalCpuNanos() / (long)totalCount / (long)100) / 10.0;
            double avgWallMicros = (double)(this.getTotalWallNanos() / (long)totalCount / (long)100) / 10.0;
            double maxCpuMicros = (double)(this.getMaxCpuNanos() / (long)100) / 10.0;
            double maxWallMicros = (double)(this.getMaxWallNanos() / (long)100) / 10.0;
            double totalCpuMillis = (double)(this.getTotalCpuNanos() / (long)100000) / 10.0;
            double totalWallMillis = (double)(this.getTotalWallNanos() / (long)100000) / 10.0;
            StringsKt.append((StringBuilder)$receiver, (String[])new String[]{"Counter: ", this.name, " "});
            StringsKt.append((StringBuilder)$receiver, (Object[])new Object[]{"Count: ", totalCount, " "});
            StringsKt.append((StringBuilder)$receiver, (Object[])new Object[]{"AvgCpu: ", avgCpuMicros, "\u03bcs "});
            StringsKt.append((StringBuilder)$receiver, (Object[])new Object[]{"AvgWall: ", avgWallMicros, "\u03bcs "});
            StringsKt.append((StringBuilder)$receiver, (Object[])new Object[]{"TotalCpu: ", totalCpuMillis, "ms "});
            StringsKt.append((StringBuilder)$receiver, (Object[])new Object[]{"TotalWall: ", totalWallMillis, "ms "});
            StringsKt.append((StringBuilder)$receiver, (Object[])new Object[]{"MaxCpu: ", maxCpuMicros, "\u03bcs "});
            StringsKt.append((StringBuilder)$receiver, (Object[])new Object[]{"MaxWall: ", maxWallMicros, "\u03bcs "});
            StringsKt.appendln((StringBuilder)$receiver);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public Counter(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        this.totalCpu = new AtomicLong();
        this.totalWall = new AtomicLong();
        this.maxCpu = new AtomicLong();
        this.maxWall = new AtomicLong();
        this.count = new AtomicInteger();
    }
}

