/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aapt.Resources;
import com.android.aaptcompiler.AaptResourceType;
import com.android.aaptcompiler.AaptResourceTypeKt;
import com.android.aaptcompiler.BlameLogger;
import com.android.aaptcompiler.BlameLoggerKt;
import com.android.aaptcompiler.Container;
import com.android.aaptcompiler.PseudolocaleGenerator;
import com.android.aaptcompiler.ResourceCompilationException;
import com.android.aaptcompiler.ResourceCompiler;
import com.android.aaptcompiler.ResourceCompilerOptions;
import com.android.aaptcompiler.ResourceFile;
import com.android.aaptcompiler.ResourceName;
import com.android.aaptcompiler.ResourcePathData;
import com.android.aaptcompiler.ResourcePathDataKt;
import com.android.aaptcompiler.ResourceTable;
import com.android.aaptcompiler.TableExtractor;
import com.android.aaptcompiler.TableExtractorOptions;
import com.android.aaptcompiler.XmlProcessor;
import com.android.aaptcompiler.XmlResource;
import com.android.aaptcompiler.proto.ProtoSerializeKt;
import com.android.resources.ResourceType;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007\u001a*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a*\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a*\u0010\u0015\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a*\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a*\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a:\u0010\u0018\u001a\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"PATCH_9_EXTENSION", "", "PNG_EXTENSION", "RESOURCE_TABLE_EXTENSION", "VALUES_DIRECTORY_PREFIX", "XML_EXTENSION", "canCompileResourceInJvm", "", "file", "Ljava/io/File;", "requirePngCrunching", "compileFile", "", "pathData", "Lcom/android/aaptcompiler/ResourcePathData;", "outputDirectory", "options", "Lcom/android/aaptcompiler/ResourceCompilerOptions;", "logger", "Lcom/android/aaptcompiler/BlameLogger;", "compilePng", "compileResource", "compileTable", "compileXml", "getCompileMethod", "Lkotlin/Function4;", "aaptcompiler"})
@JvmName(name="ResourceCompiler")
public final class ResourceCompiler {
    @NotNull
    private static final String VALUES_DIRECTORY_PREFIX = "values";
    @NotNull
    private static final String XML_EXTENSION = "xml";
    @NotNull
    private static final String RESOURCE_TABLE_EXTENSION = "arsc";
    @NotNull
    private static final String PATCH_9_EXTENSION = "9.png";
    @NotNull
    private static final String PNG_EXTENSION = "png";

    public static final boolean canCompileResourceInJvm(@NotNull File file, boolean requirePngCrunching) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isHidden()) {
            return true;
        }
        ResourcePathData pathData = ResourcePathDataKt.extractPathData$default(file, null, 2, null);
        if (Intrinsics.areEqual((Object)pathData.getResourceDirectory(), (Object)VALUES_DIRECTORY_PREFIX) && Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION)) {
            return true;
        }
        ResourceType resourceType = ResourceType.fromFolderName((String)pathData.getResourceDirectory());
        if (resourceType == null) {
            return false;
        }
        ResourceType type = resourceType;
        if (type != ResourceType.RAW) {
            if (Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION)) {
                return true;
            }
            if (StringsKt.endsWith$default((String)pathData.getExtension(), (String)PNG_EXTENSION, (boolean)false, (int)2, null)) {
                return !Intrinsics.areEqual((Object)pathData.getExtension(), (Object)PATCH_9_EXTENSION) && !requirePngCrunching;
            }
        }
        return true;
    }

    public static final void compileResource(@NotNull File file, @NotNull File outputDirectory, @NotNull ResourceCompilerOptions options, @Nullable BlameLogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        if (file.isHidden()) {
            BlameLogger blameLogger = logger;
            if (blameLogger != null) {
                BlameLogger.warning$default(blameLogger, "Omitting file " + file.getAbsolutePath() + " because it is hidden.", null, 2, null);
            }
            return;
        }
        String string = options.getSourcePath();
        String string2 = string == null ? file.getAbsolutePath() : string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"options.sourcePath ?: file.absolutePath");
        ResourcePathData pathData = ResourcePathDataKt.extractPathData(file, string2);
        Function4<ResourcePathData, File, ResourceCompilerOptions, BlameLogger, Unit> compileFunction = ResourceCompiler.getCompileMethod(pathData, logger);
        try {
            compileFunction.invoke((Object)pathData, (Object)outputDirectory, (Object)options, (Object)logger);
        }
        catch (Exception e) {
            BlameLogger blameLogger = logger;
            if (blameLogger != null) {
                blameLogger.info("Failed to compile file", BlameLoggerKt.blameSource$default(pathData.getSource(), null, null, 6, null));
            }
            throw new ResourceCompilationException("Resource compilation failed. Check logs for details.", e);
        }
    }

    public static /* synthetic */ void compileResource$default(File file, File file2, ResourceCompilerOptions resourceCompilerOptions, BlameLogger blameLogger, int n, Object object) {
        if ((n & 8) != 0) {
            blameLogger = null;
        }
        ResourceCompiler.compileResource(file, file2, resourceCompilerOptions, blameLogger);
    }

    private static final Function4<ResourcePathData, File, ResourceCompilerOptions, BlameLogger, Unit> getCompileMethod(ResourcePathData pathData, BlameLogger logger) {
        if (Intrinsics.areEqual((Object)pathData.getResourceDirectory(), (Object)VALUES_DIRECTORY_PREFIX) && Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION)) {
            pathData.setExtension(RESOURCE_TABLE_EXTENSION);
            return getCompileMethod.1.INSTANCE;
        }
        ResourceType type = ResourceType.fromFolderName((String)pathData.getResourceDirectory());
        if (type == null) {
            String errorMsg = "Invalid resource type '" + pathData.getResourceDirectory() + "' for file " + pathData.getFile().getAbsolutePath();
            BlameLogger blameLogger = logger;
            if (blameLogger != null) {
                BlameLogger.warning$default(blameLogger, errorMsg, null, 2, null);
            }
            boolean bl = false;
            throw (Throwable)new IllegalStateException(errorMsg.toString());
        }
        if (type != ResourceType.RAW) {
            if (Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION)) {
                return getCompileMethod.2.INSTANCE;
            }
            if (StringsKt.endsWith$default((String)pathData.getExtension(), (String)PNG_EXTENSION, (boolean)false, (int)2, null)) {
                return getCompileMethod.3.INSTANCE;
            }
        }
        return getCompileMethod.4.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void compileTable(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        File outputFile = new File(outputDirectory, pathData.getIntermediateContainerFilename());
        BlameLogger blameLogger = logger;
        if (blameLogger != null) {
            BlameLogger.info$default(blameLogger, "Compiling XML table " + pathData.getFile().getAbsolutePath() + " to " + outputFile, null, 2, null);
        }
        ResourceTable table = new ResourceTable(false, logger, 1, null);
        TableExtractorOptions extractorOptions = new TableExtractorOptions(!StringsKt.contains$default((CharSequence)pathData.getName(), (CharSequence)"donottranslate", (boolean)false, (int)2, null), !options.getLegacyMode(), options.getVisibility());
        TableExtractor tableExtractor = new TableExtractor(table, pathData.getSource(), pathData.getConfig(), extractorOptions, logger);
        Object object = pathData.getFile();
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl3 = false;
            if (!tableExtractor.extract(it)) {
                Object object2 = logger;
                if (object2 != null) {
                    BlameLogger.info$default((BlameLogger)object2, Intrinsics.stringPlus((String)"Failed to extract resources for ", (Object)pathData.getFile().getAbsolutePath()), null, 2, null);
                }
                object2 = "Failed to compile values file.";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            if (options.getPseudolocalize() && extractorOptions.getTranslatable()) {
                new PseudolocaleGenerator().consume(table);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        ResourceTable.createPackage$default(table, "", (byte)0, 2, null);
        table.sort();
        File file = outputFile;
        boolean bl5 = false;
        Container container = new Container(new FileOutputStream(file), 1);
        Resources.ResourceTable pbTable = ProtoSerializeKt.serializeTableToPb$default(table, null, 2, null);
        container.addResTableEntry(pbTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void compileFile(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        File outputFile = new File(outputDirectory, pathData.getIntermediateContainerFilename());
        Object object = logger;
        if (object != null) {
            BlameLogger.info$default((BlameLogger)object, "Compiling file " + pathData.getFile().getAbsolutePath() + " to " + outputFile, null, 2, null);
        }
        object = pathData.getFile();
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl3 = false;
            AaptResourceType aaptResourceType = AaptResourceTypeKt.resourceTypeFromTag(pathData.getResourceDirectory());
            if (aaptResourceType == null) {
                Intrinsics.throwNpe();
            }
            ResourceFile resourceFile = new ResourceFile(new ResourceName("", aaptResourceType, pathData.getName()), pathData.getConfig(), pathData.getSource(), ResourceFile.Type.Unknown, null, 16, null);
            File file = outputFile;
            boolean bl4 = false;
            Container container = new Container(new FileOutputStream(file), 1);
            container.addFileEntry(it, resourceFile);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void compileXml(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        File outputFile = new File(outputDirectory, pathData.getIntermediateContainerFilename());
        BlameLogger blameLogger = logger;
        if (blameLogger != null) {
            BlameLogger.info$default(blameLogger, "Compiling xml file " + pathData.getFile().getAbsolutePath() + " to " + outputFile, null, 2, null);
        }
        Object object = pathData.getType();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        ResourceFile fileToProcess = new ResourceFile(new ResourceName("", (AaptResourceType)((Object)object), pathData.getName()), pathData.getConfig(), pathData.getSource(), ResourceFile.Type.ProtoXml, null, 16, null);
        object = pathData.getFile();
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl3 = false;
            XmlProcessor xmlProcessor = new XmlProcessor(pathData.getSource(), logger);
            if (!xmlProcessor.process(fileToProcess, it)) {
                Object object2 = logger;
                if (object2 != null) {
                    ((BlameLogger)object2).warning("Failure to compile the resource file.", BlameLoggerKt.blameSource$default(pathData.getSource(), null, null, 6, null));
                }
                object2 = "Failed to compile resource file.";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            File file = outputFile;
            boolean bl5 = false;
            Container container = new Container(new FileOutputStream(file), xmlProcessor.getXmlResources().size());
            for (XmlResource resource : xmlProcessor.getXmlResources()) {
                container.addXmlEntry(resource);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private static final void compilePng(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        Object object = logger;
        if (object != null) {
            BlameLogger.info$default((BlameLogger)object, Intrinsics.stringPlus((String)"Compiling image file ", (Object)pathData.getFile().getAbsolutePath()), null, 2, null);
        }
        if (Intrinsics.areEqual((Object)pathData.getExtension(), (Object)PATCH_9_EXTENSION)) {
            object = "Patch 9 PNG processing is not supported with the JVM Android resource compiler.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        if (options.getRequirePngCrunching()) {
            object = "PNG crunching is not supported with the JVM Android resource compiler.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        ResourceCompiler.compileFile(pathData, outputDirectory, options, logger);
    }

    public static final /* synthetic */ void access$compileTable(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        ResourceCompiler.compileTable(pathData, outputDirectory, options, logger);
    }

    public static final /* synthetic */ void access$compileXml(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        ResourceCompiler.compileXml(pathData, outputDirectory, options, logger);
    }

    public static final /* synthetic */ void access$compilePng(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        ResourceCompiler.compilePng(pathData, outputDirectory, options, logger);
    }

    public static final /* synthetic */ void access$compileFile(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        ResourceCompiler.compileFile(pathData, outputDirectory, options, logger);
    }
}

