/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.BasicString;
import com.android.aaptcompiler.ConfigDescription;
import com.android.aaptcompiler.Plural;
import com.android.aaptcompiler.PseudolocaleGeneratorKt;
import com.android.aaptcompiler.Pseudolocalizer;
import com.android.aaptcompiler.ResourceConfigValue;
import com.android.aaptcompiler.ResourceEntry;
import com.android.aaptcompiler.ResourceGroup;
import com.android.aaptcompiler.ResourceTable;
import com.android.aaptcompiler.ResourceTablePackage;
import com.android.aaptcompiler.StringPool;
import com.android.aaptcompiler.StyledString;
import com.android.aaptcompiler.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/aaptcompiler/PseudolocaleGenerator;", "", "()V", "consume", "", "table", "Lcom/android/aaptcompiler/ResourceTable;", "isPseudolocalizable", "", "configValue", "Lcom/android/aaptcompiler/ResourceConfigValue;", "modifyForLocale", "Lcom/android/aaptcompiler/ConfigDescription;", "config", "method", "Lcom/android/aaptcompiler/Pseudolocalizer$Method;", "pseudolocalizeIfNeeded", "originalValue", "pool", "Lcom/android/aaptcompiler/StringPool;", "entry", "Lcom/android/aaptcompiler/ResourceEntry;", "aaptcompiler"})
@SourceDebugExtension(value={"SMAP\nPseudolocaleGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PseudolocaleGenerator.kt\ncom/android/aaptcompiler/PseudolocaleGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n774#2:270\n865#2,2:271\n*S KotlinDebug\n*F\n+ 1 PseudolocaleGenerator.kt\ncom/android/aaptcompiler/PseudolocaleGenerator\n*L\n258#1:270\n258#1:271,2\n*E\n"})
public final class PseudolocaleGenerator {
    private final ConfigDescription modifyForLocale(ConfigDescription config, Pseudolocalizer.Method method) {
        ConfigDescription modified = new ConfigDescription(config);
        switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: {
                modified.getLanguage()[0] = 101;
                modified.getLanguage()[1] = 110;
                modified.getCountry()[0] = 88;
                modified.getCountry()[1] = 65;
                break;
            }
            case 2: {
                modified.getLanguage()[0] = 97;
                modified.getLanguage()[1] = 114;
                modified.getCountry()[0] = 88;
                modified.getCountry()[1] = 66;
            }
        }
        return modified;
    }

    private final boolean isPseudolocalizable(ResourceConfigValue configValue) {
        int diff = configValue.getConfig().diff(new ConfigDescription(null, 1, null));
        if ((diff & 4) != 0) {
            return false;
        }
        Value value = configValue.getValue();
        Intrinsics.checkNotNull((Object)value);
        return value.getTranslatable();
    }

    private final void pseudolocalizeIfNeeded(Pseudolocalizer.Method method, ResourceConfigValue originalValue, StringPool pool, ResourceEntry entry) {
        Value value;
        Value valueToLocalize = originalValue.getValue();
        if (valueToLocalize == null) {
            return;
        }
        Value value2 = valueToLocalize;
        if (value2 instanceof BasicString) {
            value = PseudolocaleGeneratorKt.pseudolocalizeBasicString((BasicString)valueToLocalize, method, pool);
        } else if (value2 instanceof StyledString) {
            value = PseudolocaleGeneratorKt.pseudolocalizeStyledString((StyledString)valueToLocalize, method, pool);
        } else if (value2 instanceof Plural) {
            value = PseudolocaleGeneratorKt.pseudolocalizePlural((Plural)valueToLocalize, method, pool);
        } else {
            return;
        }
        Value localizedValue = value;
        localizedValue.setSource(valueToLocalize.getSource());
        localizedValue.setWeak(valueToLocalize.getWeak());
        ConfigDescription modifiedConfig = this.modifyForLocale(originalValue.getConfig(), method);
        ResourceConfigValue newConfigValue = entry.findOrCreateValue(modifiedConfig, originalValue.getProduct());
        if (newConfigValue.getValue() == null) {
            newConfigValue.setValue(localizedValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void consume(@NotNull ResourceTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        for (ResourceTablePackage resourcePackage : table.getPackages$aaptcompiler()) {
            for (ResourceGroup resourceGroup : resourcePackage.getGroups$aaptcompiler()) {
                for (SortedMap<Short, ResourceEntry> idToEntry : resourceGroup.getEntries$aaptcompiler().values()) {
                    for (ResourceEntry entry : idToEntry.values()) {
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv = entry.getValues$aaptcompiler();
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            ResourceConfigValue it = (ResourceConfigValue)element$iv$iv;
                            boolean bl = false;
                            if (!this.isPseudolocalizable(it)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List valuesToLocalize = (List)destination$iv$iv;
                        for (ResourceConfigValue value : valuesToLocalize) {
                            StringPool stringPool = table.getStringPool();
                            Intrinsics.checkNotNull((Object)entry);
                            this.pseudolocalizeIfNeeded(Pseudolocalizer.Method.ACCENT, value, stringPool, entry);
                            this.pseudolocalizeIfNeeded(Pseudolocalizer.Method.BIDI, value, table.getStringPool(), entry);
                        }
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Pseudolocalizer.Method.values().length];
            try {
                nArray[Pseudolocalizer.Method.ACCENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Pseudolocalizer.Method.BIDI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

