/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkSignerEngine;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.v1.DigestAlgorithm;
import com.android.apksig.internal.apk.v1.V1SchemeSigner;
import com.android.apksig.internal.apk.v1.V1SchemeVerifier;
import com.android.apksig.internal.apk.v2.V2SchemeSigner;
import com.android.apksig.internal.apk.v3.V3SchemeSigner;
import com.android.apksig.internal.jar.ManifestParser;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.util.TeeDataSink;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSinks;
import com.android.apksig.util.DataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DefaultApkSignerEngine
implements ApkSignerEngine {
    private final boolean mV1SigningEnabled;
    private final boolean mV2SigningEnabled;
    private final boolean mV3SigningEnabled;
    private final boolean mDebuggableApkPermitted;
    private final boolean mOtherSignersSignaturesPreserved;
    private final String mCreatedBy;
    private final List<SignerConfig> mSignerConfigs;
    private final int mMinSdkVersion;
    private final SigningCertificateLineage mSigningCertificateLineage;
    private List<V1SchemeSigner.SignerConfig> mV1SignerConfigs = Collections.emptyList();
    private DigestAlgorithm mV1ContentDigestAlgorithm;
    private boolean mClosed;
    private boolean mV1SignaturePending;
    private Set<String> mSignatureExpectedOutputJarEntryNames = Collections.emptySet();
    private final Map<String, GetJarEntryDataDigestRequest> mOutputJarEntryDigestRequests = new HashMap<String, GetJarEntryDataDigestRequest>();
    private final Map<String, byte[]> mOutputJarEntryDigests = new HashMap<String, byte[]>();
    private final Map<String, byte[]> mEmittedSignatureJarEntryData = new HashMap<String, byte[]>();
    private final Map<String, GetJarEntryDataRequest> mOutputSignatureJarEntryDataRequests = new HashMap<String, GetJarEntryDataRequest>();
    private GetJarEntryDataRequest mInputJarManifestEntryDataRequest;
    private GetJarEntryDataRequest mOutputAndroidManifestEntryDataRequest;
    private Boolean mDebuggable;
    private OutputJarSignatureRequestImpl mAddV1SignatureRequest;
    private boolean mV2SignaturePending;
    private boolean mV3SignaturePending;
    private OutputApkSigningBlockRequestImpl mAddSigningBlockRequest;

    private DefaultApkSignerEngine(List<SignerConfig> signerConfigs, int minSdkVersion, boolean v1SigningEnabled, boolean v2SigningEnabled, boolean v3SigningEnabled, boolean debuggableApkPermitted, boolean otherSignersSignaturesPreserved, String createdBy, SigningCertificateLineage signingCertificateLineage) throws InvalidKeyException {
        if (signerConfigs.isEmpty()) {
            throw new IllegalArgumentException("At least one signer config must be provided");
        }
        if (otherSignersSignaturesPreserved) {
            throw new UnsupportedOperationException("Preserving other signer's signatures is not yet implemented");
        }
        this.mV1SigningEnabled = v1SigningEnabled;
        this.mV2SigningEnabled = v2SigningEnabled;
        this.mV3SigningEnabled = v3SigningEnabled;
        this.mV1SignaturePending = v1SigningEnabled;
        this.mV2SignaturePending = v2SigningEnabled;
        this.mV3SignaturePending = v3SigningEnabled;
        this.mDebuggableApkPermitted = debuggableApkPermitted;
        this.mOtherSignersSignaturesPreserved = otherSignersSignaturesPreserved;
        this.mCreatedBy = createdBy;
        this.mSignerConfigs = signerConfigs;
        this.mMinSdkVersion = minSdkVersion;
        this.mSigningCertificateLineage = signingCertificateLineage;
        if (v1SigningEnabled) {
            if (v3SigningEnabled) {
                SigningCertificateLineage subLineage;
                SignerConfig oldestConfig = signerConfigs.get(0);
                if (signingCertificateLineage != null && (subLineage = signingCertificateLineage.getSubLineage((X509Certificate)oldestConfig.mCertificates.get(0))).size() != 1) {
                    throw new IllegalArgumentException("v1 signing enabled but the oldest signer in the SigningCertificateLineage is missing.  Please provide the oldest signer to enable v1 signing");
                }
                this.createV1SignerConfigs(Collections.singletonList(oldestConfig), minSdkVersion);
            } else {
                this.createV1SignerConfigs(signerConfigs, minSdkVersion);
            }
        }
    }

    private void createV1SignerConfigs(List<SignerConfig> signerConfigs, int minSdkVersion) throws InvalidKeyException {
        this.mV1SignerConfigs = new ArrayList<V1SchemeSigner.SignerConfig>(signerConfigs.size());
        HashMap<String, Integer> v1SignerNameToSignerIndex = new HashMap<String, Integer>(signerConfigs.size());
        DigestAlgorithm v1ContentDigestAlgorithm = null;
        for (int i = 0; i < signerConfigs.size(); ++i) {
            SignerConfig signerConfig = signerConfigs.get(i);
            List<X509Certificate> certificates = signerConfig.getCertificates();
            PublicKey publicKey = certificates.get(0).getPublicKey();
            String v1SignerName = V1SchemeSigner.getSafeSignerName(signerConfig.getName());
            Integer indexOfOtherSignerWithSameName = v1SignerNameToSignerIndex.put(v1SignerName, i);
            if (indexOfOtherSignerWithSameName != null) {
                throw new IllegalArgumentException("Signers #" + (indexOfOtherSignerWithSameName + 1) + " and #" + (i + 1) + " have the same name: " + v1SignerName + ". v1 signer names must be unique");
            }
            DigestAlgorithm v1SignatureDigestAlgorithm = V1SchemeSigner.getSuggestedSignatureDigestAlgorithm(publicKey, minSdkVersion);
            V1SchemeSigner.SignerConfig v1SignerConfig = new V1SchemeSigner.SignerConfig();
            v1SignerConfig.name = v1SignerName;
            v1SignerConfig.privateKey = signerConfig.getPrivateKey();
            v1SignerConfig.certificates = certificates;
            v1SignerConfig.signatureDigestAlgorithm = v1SignatureDigestAlgorithm;
            if (v1ContentDigestAlgorithm == null) {
                v1ContentDigestAlgorithm = v1SignatureDigestAlgorithm;
            } else if (DigestAlgorithm.BY_STRENGTH_COMPARATOR.compare(v1SignatureDigestAlgorithm, v1ContentDigestAlgorithm) > 0) {
                v1ContentDigestAlgorithm = v1SignatureDigestAlgorithm;
            }
            this.mV1SignerConfigs.add(v1SignerConfig);
        }
        this.mV1ContentDigestAlgorithm = v1ContentDigestAlgorithm;
        this.mSignatureExpectedOutputJarEntryNames = V1SchemeSigner.getOutputEntryNames(this.mV1SignerConfigs);
    }

    private List<ApkSigningBlockUtils.SignerConfig> createV2SignerConfigs(boolean apkSigningBlockPaddingSupported) throws InvalidKeyException {
        if (this.mV3SigningEnabled) {
            SigningCertificateLineage subLineage;
            ArrayList<ApkSigningBlockUtils.SignerConfig> signerConfig = new ArrayList<ApkSigningBlockUtils.SignerConfig>();
            SignerConfig oldestConfig = this.mSignerConfigs.get(0);
            if (this.mSigningCertificateLineage != null && (subLineage = this.mSigningCertificateLineage.getSubLineage((X509Certificate)oldestConfig.mCertificates.get(0))).size() != 1) {
                throw new IllegalArgumentException("v2 signing enabled but the oldest signer in the SigningCertificateLineage is missing.  Please provide the oldest signer to enable v2 signing.");
            }
            signerConfig.add(this.createSigningBlockSignerConfig(this.mSignerConfigs.get(0), apkSigningBlockPaddingSupported, 2));
            return signerConfig;
        }
        return this.createSigningBlockSignerConfigs(apkSigningBlockPaddingSupported, 2);
    }

    private List<ApkSigningBlockUtils.SignerConfig> createV3SignerConfigs(boolean apkSigningBlockPaddingSupported) throws InvalidKeyException {
        List<ApkSigningBlockUtils.SignerConfig> rawConfigs = this.createSigningBlockSignerConfigs(apkSigningBlockPaddingSupported, 3);
        ArrayList<ApkSigningBlockUtils.SignerConfig> processedConfigs = new ArrayList<ApkSigningBlockUtils.SignerConfig>();
        int currentMinSdk = Integer.MAX_VALUE;
        for (int i = rawConfigs.size() - 1; i >= 0; --i) {
            ApkSigningBlockUtils.SignerConfig config = rawConfigs.get(i);
            if (config.signatureAlgorithms == null) {
                String keyAlgorithm = config.certificates.get(0).getPublicKey().getAlgorithm();
                throw new InvalidKeyException("Unsupported key algorithm " + keyAlgorithm + " is not supported for APK Signature Scheme v3 signing");
            }
            config.maxSdkVersion = i == rawConfigs.size() - 1 ? Integer.MAX_VALUE : currentMinSdk - 1;
            config.minSdkVersion = this.getMinSdkFromV3SignatureAlgorithms(config.signatureAlgorithms);
            if (this.mSigningCertificateLineage != null) {
                config.mSigningCertificateLineage = this.mSigningCertificateLineage.getSubLineage(config.certificates.get(0));
            }
            processedConfigs.add(config);
            currentMinSdk = config.minSdkVersion;
            if (currentMinSdk <= this.mMinSdkVersion || currentMinSdk <= 28) break;
        }
        if (currentMinSdk > 28 && currentMinSdk > this.mMinSdkVersion) {
            throw new InvalidKeyException("Provided key algorithms not supported on all desired Android SDK versions");
        }
        return processedConfigs;
    }

    private int getMinSdkFromV3SignatureAlgorithms(List<SignatureAlgorithm> algorithms) {
        int min = Integer.MAX_VALUE;
        for (SignatureAlgorithm algorithm : algorithms) {
            int current = algorithm.getMinSdkVersion();
            if (current >= min) continue;
            if (current <= this.mMinSdkVersion || current <= 28) {
                return current;
            }
            min = current;
        }
        return min;
    }

    private List<ApkSigningBlockUtils.SignerConfig> createSigningBlockSignerConfigs(boolean apkSigningBlockPaddingSupported, int schemeId) throws InvalidKeyException {
        ArrayList<ApkSigningBlockUtils.SignerConfig> signerConfigs = new ArrayList<ApkSigningBlockUtils.SignerConfig>(this.mSignerConfigs.size());
        for (int i = 0; i < this.mSignerConfigs.size(); ++i) {
            SignerConfig signerConfig = this.mSignerConfigs.get(i);
            signerConfigs.add(this.createSigningBlockSignerConfig(signerConfig, apkSigningBlockPaddingSupported, schemeId));
        }
        return signerConfigs;
    }

    private ApkSigningBlockUtils.SignerConfig createSigningBlockSignerConfig(SignerConfig signerConfig, boolean apkSigningBlockPaddingSupported, int schemeId) throws InvalidKeyException {
        List<X509Certificate> certificates = signerConfig.getCertificates();
        PublicKey publicKey = certificates.get(0).getPublicKey();
        ApkSigningBlockUtils.SignerConfig newSignerConfig = new ApkSigningBlockUtils.SignerConfig();
        newSignerConfig.privateKey = signerConfig.getPrivateKey();
        newSignerConfig.certificates = certificates;
        switch (schemeId) {
            case 2: {
                newSignerConfig.signatureAlgorithms = V2SchemeSigner.getSuggestedSignatureAlgorithms(publicKey, this.mMinSdkVersion, apkSigningBlockPaddingSupported);
                break;
            }
            case 3: {
                try {
                    newSignerConfig.signatureAlgorithms = V3SchemeSigner.getSuggestedSignatureAlgorithms(publicKey, this.mMinSdkVersion, apkSigningBlockPaddingSupported);
                }
                catch (InvalidKeyException e) {
                    newSignerConfig.signatureAlgorithms = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown APK Signature Scheme ID requested");
            }
        }
        return newSignerConfig;
    }

    private boolean isDebuggable(String entryName) {
        return this.mDebuggableApkPermitted || !"AndroidManifest.xml".equals(entryName);
    }

    @Override
    public Set<String> initWith(byte[] manifestBytes, Set<String> entryNames) {
        V1SchemeVerifier.Result dummyResult = new V1SchemeVerifier.Result();
        Pair<ManifestParser.Section, Map<String, ManifestParser.Section>> sections = V1SchemeVerifier.parseManifest(manifestBytes, entryNames, dummyResult);
        String alg = V1SchemeSigner.getJcaMessageDigestAlgorithm(this.mV1ContentDigestAlgorithm);
        for (Map.Entry<String, ManifestParser.Section> entry : sections.getSecond().entrySet()) {
            String entryName = entry.getKey();
            if (!V1SchemeSigner.isJarEntryDigestNeededInManifest(entry.getKey()) || !this.isDebuggable(entryName)) continue;
            Optional<V1SchemeVerifier.NamedDigest> extractedDigest = V1SchemeVerifier.getDigestsToVerify(entry.getValue(), "-Digest", this.mMinSdkVersion, Integer.MAX_VALUE).stream().filter(d -> d.jcaDigestAlgorithm == alg).findFirst();
            extractedDigest.ifPresent(namedDigest -> this.mOutputJarEntryDigests.put(entryName, namedDigest.digest));
        }
        return this.mOutputJarEntryDigests.keySet();
    }

    @Override
    public void inputApkSigningBlock(DataSource apkSigningBlock) {
        this.checkNotClosed();
        if (apkSigningBlock == null || apkSigningBlock.size() == 0L) {
            return;
        }
        if (this.mOtherSignersSignaturesPreserved) {
            return;
        }
    }

    @Override
    public ApkSignerEngine.InputJarEntryInstructions inputJarEntry(String entryName) {
        this.checkNotClosed();
        ApkSignerEngine.InputJarEntryInstructions.OutputPolicy outputPolicy = this.getInputJarEntryOutputPolicy(entryName);
        switch (outputPolicy) {
            case SKIP: {
                return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.SKIP);
            }
            case OUTPUT: {
                return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT);
            }
            case OUTPUT_BY_ENGINE: {
                if ("META-INF/MANIFEST.MF".equals(entryName)) {
                    this.mInputJarManifestEntryDataRequest = new GetJarEntryDataRequest(entryName);
                    return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT_BY_ENGINE, this.mInputJarManifestEntryDataRequest);
                }
                return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT_BY_ENGINE);
            }
        }
        throw new RuntimeException("Unsupported output policy: " + (Object)((Object)outputPolicy));
    }

    @Override
    public ApkSignerEngine.InspectJarEntryRequest outputJarEntry(String entryName) {
        this.checkNotClosed();
        this.invalidateV2Signature();
        if (!this.isDebuggable(entryName)) {
            this.forgetOutputApkDebuggableStatus();
        }
        if (!this.mV1SigningEnabled) {
            if (!this.isDebuggable(entryName)) {
                this.mOutputAndroidManifestEntryDataRequest = new GetJarEntryDataRequest(entryName);
                return this.mOutputAndroidManifestEntryDataRequest;
            }
            return null;
        }
        if (V1SchemeSigner.isJarEntryDigestNeededInManifest(entryName)) {
            this.invalidateV1Signature();
            GetJarEntryDataDigestRequest dataDigestRequest = new GetJarEntryDataDigestRequest(entryName, V1SchemeSigner.getJcaMessageDigestAlgorithm(this.mV1ContentDigestAlgorithm));
            this.mOutputJarEntryDigestRequests.put(entryName, dataDigestRequest);
            this.mOutputJarEntryDigests.remove(entryName);
            if (!this.mDebuggableApkPermitted && "AndroidManifest.xml".equals(entryName)) {
                this.mOutputAndroidManifestEntryDataRequest = new GetJarEntryDataRequest(entryName);
                return new CompoundInspectJarEntryRequest(entryName, new ApkSignerEngine.InspectJarEntryRequest[]{this.mOutputAndroidManifestEntryDataRequest, dataDigestRequest});
            }
            return dataDigestRequest;
        }
        if (this.mSignatureExpectedOutputJarEntryNames.contains(entryName)) {
            GetJarEntryDataRequest dataRequest;
            this.invalidateV1Signature();
            if ("META-INF/MANIFEST.MF".equals(entryName)) {
                this.mInputJarManifestEntryDataRequest = dataRequest = new GetJarEntryDataRequest(entryName);
            } else {
                GetJarEntryDataRequest getJarEntryDataRequest = dataRequest = this.mEmittedSignatureJarEntryData.containsKey(entryName) ? new GetJarEntryDataRequest(entryName) : null;
            }
            if (dataRequest != null) {
                this.mOutputSignatureJarEntryDataRequests.put(entryName, dataRequest);
            }
            return dataRequest;
        }
        return null;
    }

    @Override
    public ApkSignerEngine.InputJarEntryInstructions.OutputPolicy inputJarEntryRemoved(String entryName) {
        this.checkNotClosed();
        return this.getInputJarEntryOutputPolicy(entryName);
    }

    @Override
    public void outputJarEntryRemoved(String entryName) {
        this.checkNotClosed();
        this.invalidateV2Signature();
        if (!this.mV1SigningEnabled) {
            return;
        }
        if (V1SchemeSigner.isJarEntryDigestNeededInManifest(entryName)) {
            this.invalidateV1Signature();
            this.mOutputJarEntryDigests.remove(entryName);
            this.mOutputJarEntryDigestRequests.remove(entryName);
            this.mOutputSignatureJarEntryDataRequests.remove(entryName);
            return;
        }
        if (this.mSignatureExpectedOutputJarEntryNames.contains(entryName)) {
            this.invalidateV1Signature();
            return;
        }
    }

    @Override
    public ApkSignerEngine.OutputJarSignatureRequest outputJarEntries() throws ApkFormatException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        List<Pair<String, byte[]>> signatureZipEntries;
        this.checkNotClosed();
        if (!this.mV1SignaturePending) {
            return null;
        }
        if (this.mInputJarManifestEntryDataRequest != null && !this.mInputJarManifestEntryDataRequest.isDone()) {
            throw new IllegalStateException("Still waiting to inspect input APK's " + this.mInputJarManifestEntryDataRequest.getEntryName());
        }
        for (GetJarEntryDataDigestRequest digestRequest : this.mOutputJarEntryDigestRequests.values()) {
            String entryName = digestRequest.getEntryName();
            if (!digestRequest.isDone()) {
                throw new IllegalStateException("Still waiting to inspect output APK's " + entryName);
            }
            this.mOutputJarEntryDigests.put(entryName, digestRequest.getDigest());
        }
        this.mOutputJarEntryDigestRequests.clear();
        for (GetJarEntryDataRequest dataRequest : this.mOutputSignatureJarEntryDataRequests.values()) {
            if (dataRequest.isDone()) continue;
            throw new IllegalStateException("Still waiting to inspect output APK's " + dataRequest.getEntryName());
        }
        ArrayList<Integer> apkSigningSchemeIds = new ArrayList<Integer>();
        if (this.mV2SigningEnabled) {
            apkSigningSchemeIds.add(2);
        }
        if (this.mV3SigningEnabled) {
            apkSigningSchemeIds.add(3);
        }
        byte[] inputJarManifest = this.mInputJarManifestEntryDataRequest != null ? this.mInputJarManifestEntryDataRequest.getData() : null;
        this.checkOutputApkNotDebuggableIfDebuggableMustBeRejected();
        if (this.mAddV1SignatureRequest == null || !this.mAddV1SignatureRequest.isDone()) {
            try {
                signatureZipEntries = V1SchemeSigner.sign(this.mV1SignerConfigs, this.mV1ContentDigestAlgorithm, this.mOutputJarEntryDigests, apkSigningSchemeIds, inputJarManifest, this.mCreatedBy);
            }
            catch (CertificateException e) {
                throw new SignatureException("Failed to generate v1 signature", e);
            }
        } else {
            V1SchemeSigner.OutputManifestFile newManifest = V1SchemeSigner.generateManifestFile(this.mV1ContentDigestAlgorithm, this.mOutputJarEntryDigests, inputJarManifest);
            byte[] emittedSignatureManifest = this.mEmittedSignatureJarEntryData.get("META-INF/MANIFEST.MF");
            if (!Arrays.equals(newManifest.contents, emittedSignatureManifest)) {
                try {
                    signatureZipEntries = V1SchemeSigner.signManifest(this.mV1SignerConfigs, this.mV1ContentDigestAlgorithm, apkSigningSchemeIds, this.mCreatedBy, newManifest);
                }
                catch (CertificateException e) {
                    throw new SignatureException("Failed to generate v1 signature", e);
                }
            } else {
                signatureZipEntries = new ArrayList<Pair<String, byte[]>>();
                for (Map.Entry<String, byte[]> expectedOutputEntry : this.mEmittedSignatureJarEntryData.entrySet()) {
                    String entryName = expectedOutputEntry.getKey();
                    byte[] expectedData = expectedOutputEntry.getValue();
                    GetJarEntryDataRequest actualDataRequest = this.mOutputSignatureJarEntryDataRequests.get(entryName);
                    if (actualDataRequest == null) {
                        signatureZipEntries.add(Pair.of(entryName, expectedData));
                        continue;
                    }
                    byte[] actualData = actualDataRequest.getData();
                    if (Arrays.equals(expectedData, actualData)) continue;
                    signatureZipEntries.add(Pair.of(entryName, expectedData));
                }
                if (signatureZipEntries.isEmpty()) {
                    return null;
                }
            }
        }
        if (signatureZipEntries.isEmpty()) {
            this.mV1SignaturePending = false;
            return null;
        }
        ArrayList<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> sigEntries = new ArrayList<ApkSignerEngine.OutputJarSignatureRequest.JarEntry>(signatureZipEntries.size());
        for (Pair<String, byte[]> entry : signatureZipEntries) {
            String entryName = entry.getFirst();
            byte[] entryData = entry.getSecond();
            sigEntries.add(new ApkSignerEngine.OutputJarSignatureRequest.JarEntry(entryName, entryData));
            this.mEmittedSignatureJarEntryData.put(entryName, entryData);
        }
        this.mAddV1SignatureRequest = new OutputJarSignatureRequestImpl(sigEntries);
        return this.mAddV1SignatureRequest;
    }

    @Override
    @Deprecated
    public ApkSignerEngine.OutputApkSigningBlockRequest outputZipSections(DataSource zipEntries, DataSource zipCentralDirectory, DataSource zipEocd) throws IOException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        return this.outputZipSectionsInternal(zipEntries, zipCentralDirectory, zipEocd, false);
    }

    @Override
    public ApkSignerEngine.OutputApkSigningBlockRequest2 outputZipSections2(DataSource zipEntries, DataSource zipCentralDirectory, DataSource zipEocd) throws IOException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        return this.outputZipSectionsInternal(zipEntries, zipCentralDirectory, zipEocd, true);
    }

    private OutputApkSigningBlockRequestImpl outputZipSectionsInternal(DataSource zipEntries, DataSource zipCentralDirectory, DataSource zipEocd, boolean apkSigningBlockPaddingSupported) throws IOException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        this.checkNotClosed();
        this.checkV1SigningDoneIfEnabled();
        if (!this.mV2SigningEnabled && !this.mV3SigningEnabled) {
            return null;
        }
        this.checkOutputApkNotDebuggableIfDebuggableMustBeRejected();
        Pair<DataSource, Integer> paddingPair = ApkSigningBlockUtils.generateApkSigningBlockPadding(zipEntries, apkSigningBlockPaddingSupported);
        DataSource beforeCentralDir = paddingPair.getFirst();
        int padSizeBeforeApkSigningBlock = paddingPair.getSecond();
        DataSource eocd = ApkSigningBlockUtils.copyWithModifiedCDOffset(beforeCentralDir, zipEocd);
        ArrayList<Pair<byte[], Integer>> signingSchemeBlocks = new ArrayList<Pair<byte[], Integer>>();
        if (this.mV2SigningEnabled) {
            this.invalidateV2Signature();
            List<ApkSigningBlockUtils.SignerConfig> v2SignerConfigs = this.createV2SignerConfigs(apkSigningBlockPaddingSupported);
            signingSchemeBlocks.add(V2SchemeSigner.generateApkSignatureSchemeV2Block(beforeCentralDir, zipCentralDirectory, eocd, v2SignerConfigs, this.mV3SigningEnabled));
        }
        if (this.mV3SigningEnabled) {
            this.invalidateV3Signature();
            List<ApkSigningBlockUtils.SignerConfig> v3SignerConfigs = this.createV3SignerConfigs(apkSigningBlockPaddingSupported);
            signingSchemeBlocks.add(V3SchemeSigner.generateApkSignatureSchemeV3Block(beforeCentralDir, zipCentralDirectory, eocd, v3SignerConfigs));
        }
        byte[] apkSigningBlock = ApkSigningBlockUtils.generateApkSigningBlock(signingSchemeBlocks);
        this.mAddSigningBlockRequest = new OutputApkSigningBlockRequestImpl(apkSigningBlock, padSizeBeforeApkSigningBlock);
        return this.mAddSigningBlockRequest;
    }

    @Override
    public void outputDone() {
        this.checkNotClosed();
        this.checkV1SigningDoneIfEnabled();
        this.checkSigningBlockDoneIfEnabled();
    }

    @Override
    public void close() {
        this.mClosed = true;
        this.mAddV1SignatureRequest = null;
        this.mInputJarManifestEntryDataRequest = null;
        this.mOutputAndroidManifestEntryDataRequest = null;
        this.mDebuggable = null;
        this.mOutputJarEntryDigestRequests.clear();
        this.mOutputJarEntryDigests.clear();
        this.mEmittedSignatureJarEntryData.clear();
        this.mOutputSignatureJarEntryDataRequests.clear();
        this.mAddSigningBlockRequest = null;
    }

    private void invalidateV1Signature() {
        if (this.mV1SigningEnabled) {
            this.mV1SignaturePending = true;
        }
        this.invalidateV2Signature();
    }

    private void invalidateV2Signature() {
        if (this.mV2SigningEnabled) {
            this.mV2SignaturePending = true;
            this.mAddSigningBlockRequest = null;
        }
    }

    private void invalidateV3Signature() {
        if (this.mV3SigningEnabled) {
            this.mV3SignaturePending = true;
            this.mAddSigningBlockRequest = null;
        }
    }

    private void checkNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Engine closed");
        }
    }

    private void checkV1SigningDoneIfEnabled() {
        if (!this.mV1SignaturePending) {
            return;
        }
        if (this.mAddV1SignatureRequest == null) {
            throw new IllegalStateException("v1 signature (JAR signature) not yet generated. Skipped outputJarEntries()?");
        }
        if (!this.mAddV1SignatureRequest.isDone()) {
            throw new IllegalStateException("v1 signature (JAR signature) addition requested by outputJarEntries() hasn't been fulfilled");
        }
        for (Map.Entry<String, byte[]> expectedOutputEntry : this.mEmittedSignatureJarEntryData.entrySet()) {
            String entryName = expectedOutputEntry.getKey();
            byte[] expectedData = expectedOutputEntry.getValue();
            GetJarEntryDataRequest actualDataRequest = this.mOutputSignatureJarEntryDataRequests.get(entryName);
            if (actualDataRequest == null) {
                throw new IllegalStateException("APK entry " + entryName + " not yet output despite this having been requested");
            }
            if (!actualDataRequest.isDone()) {
                throw new IllegalStateException("Still waiting to inspect output APK's " + entryName);
            }
            byte[] actualData = actualDataRequest.getData();
            if (Arrays.equals(expectedData, actualData)) continue;
            throw new IllegalStateException("Output APK entry " + entryName + " data differs from what was requested");
        }
        this.mV1SignaturePending = false;
    }

    private void checkSigningBlockDoneIfEnabled() {
        if (!this.mV2SignaturePending && !this.mV3SignaturePending) {
            return;
        }
        if (this.mAddSigningBlockRequest == null) {
            throw new IllegalStateException("Signed APK Signing BLock not yet generated. Skipped outputZipSections()?");
        }
        if (!this.mAddSigningBlockRequest.isDone()) {
            throw new IllegalStateException("APK Signing Block addition of signature(s) requested by outputZipSections() hasn't been fulfilled yet");
        }
        this.mAddSigningBlockRequest = null;
        this.mV2SignaturePending = false;
        this.mV3SignaturePending = false;
    }

    private void checkOutputApkNotDebuggableIfDebuggableMustBeRejected() throws SignatureException {
        if (this.mDebuggableApkPermitted) {
            return;
        }
        try {
            if (this.isOutputApkDebuggable()) {
                throw new SignatureException("APK is debuggable (see android:debuggable attribute) and this engine is configured to refuse to sign debuggable APKs");
            }
        }
        catch (ApkFormatException e) {
            throw new SignatureException("Failed to determine whether the APK is debuggable", e);
        }
    }

    private boolean isOutputApkDebuggable() throws ApkFormatException {
        if (this.mDebuggable != null) {
            return this.mDebuggable;
        }
        if (this.mOutputAndroidManifestEntryDataRequest == null) {
            throw new IllegalStateException("Cannot determine debuggable status of output APK because AndroidManifest.xml entry contents have not yet been requested");
        }
        if (!this.mOutputAndroidManifestEntryDataRequest.isDone()) {
            throw new IllegalStateException("Still waiting to inspect output APK's " + this.mOutputAndroidManifestEntryDataRequest.getEntryName());
        }
        this.mDebuggable = ApkUtils.getDebuggableFromBinaryAndroidManifest(ByteBuffer.wrap(this.mOutputAndroidManifestEntryDataRequest.getData()));
        return this.mDebuggable;
    }

    private void forgetOutputApkDebuggableStatus() {
        this.mDebuggable = null;
    }

    private ApkSignerEngine.InputJarEntryInstructions.OutputPolicy getInputJarEntryOutputPolicy(String entryName) {
        if (this.mSignatureExpectedOutputJarEntryNames.contains(entryName)) {
            return ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT_BY_ENGINE;
        }
        if (this.mOtherSignersSignaturesPreserved || V1SchemeSigner.isJarEntryDigestNeededInManifest(entryName)) {
            return ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT;
        }
        return ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.SKIP;
    }

    public static class Builder {
        private List<SignerConfig> mSignerConfigs;
        private final int mMinSdkVersion;
        private boolean mV1SigningEnabled = true;
        private boolean mV2SigningEnabled = true;
        private boolean mV3SigningEnabled = true;
        private boolean mDebuggableApkPermitted = true;
        private boolean mOtherSignersSignaturesPreserved;
        private String mCreatedBy = "1.0 (Android)";
        private SigningCertificateLineage mSigningCertificateLineage;
        private boolean mV3SigningExplicitlyDisabled = false;
        private boolean mV3SigningExplicitlyEnabled = false;

        public Builder(List<SignerConfig> signerConfigs, int minSdkVersion) {
            if (signerConfigs.isEmpty()) {
                throw new IllegalArgumentException("At least one signer config must be provided");
            }
            if (signerConfigs.size() > 1) {
                this.mV3SigningEnabled = false;
            }
            this.mSignerConfigs = new ArrayList<SignerConfig>(signerConfigs);
            this.mMinSdkVersion = minSdkVersion;
        }

        public DefaultApkSignerEngine build() throws InvalidKeyException {
            block9: {
                if (this.mV3SigningExplicitlyDisabled && this.mV3SigningExplicitlyEnabled) {
                    throw new IllegalStateException("Builder configured to both enable and disable APK Signature Scheme v3 signing");
                }
                if (this.mV3SigningExplicitlyDisabled) {
                    this.mV3SigningEnabled = false;
                } else if (this.mV3SigningExplicitlyEnabled) {
                    this.mV3SigningEnabled = true;
                }
                if (this.mSigningCertificateLineage != null) {
                    try {
                        this.mSignerConfigs = this.mSigningCertificateLineage.sortSignerConfigs(this.mSignerConfigs);
                        if (!this.mV3SigningEnabled && this.mSignerConfigs.size() > 1) {
                            throw new IllegalStateException("Provided multiple signers which are part of the SigningCertificateLineage, but not signing with APK Signature Scheme v3");
                        }
                        break block9;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException("Provided signer configs do not match the provided SigningCertificateLineage", e);
                    }
                }
                if (this.mV3SigningEnabled && this.mSignerConfigs.size() > 1) {
                    throw new IllegalStateException("Multiple signing certificates provided for use with APK Signature Scheme v3 without an accompanying SigningCertificateLineage");
                }
            }
            return new DefaultApkSignerEngine(this.mSignerConfigs, this.mMinSdkVersion, this.mV1SigningEnabled, this.mV2SigningEnabled, this.mV3SigningEnabled, this.mDebuggableApkPermitted, this.mOtherSignersSignaturesPreserved, this.mCreatedBy, this.mSigningCertificateLineage);
        }

        public Builder setV1SigningEnabled(boolean enabled) {
            this.mV1SigningEnabled = enabled;
            return this;
        }

        public Builder setV2SigningEnabled(boolean enabled) {
            this.mV2SigningEnabled = enabled;
            return this;
        }

        public Builder setV3SigningEnabled(boolean enabled) {
            this.mV3SigningEnabled = enabled;
            if (enabled) {
                this.mV3SigningExplicitlyEnabled = true;
            } else {
                this.mV3SigningExplicitlyDisabled = true;
            }
            return this;
        }

        public Builder setDebuggableApkPermitted(boolean permitted) {
            this.mDebuggableApkPermitted = permitted;
            return this;
        }

        public Builder setOtherSignersSignaturesPreserved(boolean preserved) {
            this.mOtherSignersSignaturesPreserved = preserved;
            return this;
        }

        public Builder setCreatedBy(String createdBy) {
            if (createdBy == null) {
                throw new NullPointerException();
            }
            this.mCreatedBy = createdBy;
            return this;
        }

        public Builder setSigningCertificateLineage(SigningCertificateLineage signingCertificateLineage) {
            if (signingCertificateLineage != null) {
                this.mV3SigningEnabled = true;
                this.mSigningCertificateLineage = signingCertificateLineage;
            }
            return this;
        }
    }

    public static class SignerConfig {
        private final String mName;
        private final PrivateKey mPrivateKey;
        private final List<X509Certificate> mCertificates;

        private SignerConfig(String name, PrivateKey privateKey, List<X509Certificate> certificates) {
            this.mName = name;
            this.mPrivateKey = privateKey;
            this.mCertificates = Collections.unmodifiableList(new ArrayList<X509Certificate>(certificates));
        }

        public String getName() {
            return this.mName;
        }

        public PrivateKey getPrivateKey() {
            return this.mPrivateKey;
        }

        public List<X509Certificate> getCertificates() {
            return this.mCertificates;
        }

        public static class Builder {
            private final String mName;
            private final PrivateKey mPrivateKey;
            private final List<X509Certificate> mCertificates;

            public Builder(String name, PrivateKey privateKey, List<X509Certificate> certificates) {
                if (name.isEmpty()) {
                    throw new IllegalArgumentException("Empty name");
                }
                this.mName = name;
                this.mPrivateKey = privateKey;
                this.mCertificates = new ArrayList<X509Certificate>(certificates);
            }

            public SignerConfig build() {
                return new SignerConfig(this.mName, this.mPrivateKey, this.mCertificates);
            }
        }
    }

    private static class CompoundInspectJarEntryRequest
    implements ApkSignerEngine.InspectJarEntryRequest {
        private final String mEntryName;
        private final ApkSignerEngine.InspectJarEntryRequest[] mRequests;
        private final Object mLock = new Object();
        private DataSink mSink;

        private CompoundInspectJarEntryRequest(String entryName, ApkSignerEngine.InspectJarEntryRequest ... requests) {
            this.mEntryName = entryName;
            this.mRequests = requests;
        }

        @Override
        public String getEntryName() {
            return this.mEntryName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataSink getDataSink() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSink == null) {
                    DataSink[] sinks = new DataSink[this.mRequests.length];
                    for (int i = 0; i < sinks.length; ++i) {
                        sinks[i] = this.mRequests[i].getDataSink();
                    }
                    this.mSink = new TeeDataSink(sinks);
                }
                return this.mSink;
            }
        }

        @Override
        public void done() {
            for (ApkSignerEngine.InspectJarEntryRequest request : this.mRequests) {
                request.done();
            }
        }
    }

    private static class GetJarEntryDataDigestRequest
    implements ApkSignerEngine.InspectJarEntryRequest {
        private final String mEntryName;
        private final String mJcaDigestAlgorithm;
        private final Object mLock = new Object();
        private boolean mDone;
        private DataSink mDataSink;
        private MessageDigest mMessageDigest;
        private byte[] mDigest;

        private GetJarEntryDataDigestRequest(String entryName, String jcaDigestAlgorithm) {
            this.mEntryName = entryName;
            this.mJcaDigestAlgorithm = jcaDigestAlgorithm;
        }

        @Override
        public String getEntryName() {
            return this.mEntryName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataSink getDataSink() {
            Object object = this.mLock;
            synchronized (object) {
                this.checkNotDone();
                if (this.mDataSink == null) {
                    this.mDataSink = DataSinks.asDataSink(this.getMessageDigest());
                }
                return this.mDataSink;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MessageDigest getMessageDigest() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mMessageDigest == null) {
                    try {
                        this.mMessageDigest = MessageDigest.getInstance(this.mJcaDigestAlgorithm);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(this.mJcaDigestAlgorithm + " MessageDigest not available", e);
                    }
                }
                return this.mMessageDigest;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    return;
                }
                this.mDone = true;
                this.mDigest = this.getMessageDigest().digest();
                this.mMessageDigest = null;
                this.mDataSink = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isDone() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mDone;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNotDone() throws IllegalStateException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    throw new IllegalStateException("Already done");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getDigest() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDone) {
                    throw new IllegalStateException("Not yet done");
                }
                return (byte[])this.mDigest.clone();
            }
        }
    }

    private static class GetJarEntryDataRequest
    implements ApkSignerEngine.InspectJarEntryRequest {
        private final String mEntryName;
        private final Object mLock = new Object();
        private boolean mDone;
        private DataSink mDataSink;
        private ByteArrayOutputStream mDataSinkBuf;

        private GetJarEntryDataRequest(String entryName) {
            this.mEntryName = entryName;
        }

        @Override
        public String getEntryName() {
            return this.mEntryName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataSink getDataSink() {
            Object object = this.mLock;
            synchronized (object) {
                this.checkNotDone();
                if (this.mDataSinkBuf == null) {
                    this.mDataSinkBuf = new ByteArrayOutputStream();
                }
                if (this.mDataSink == null) {
                    this.mDataSink = DataSinks.asDataSink(this.mDataSinkBuf);
                }
                return this.mDataSink;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    return;
                }
                this.mDone = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isDone() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mDone;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNotDone() throws IllegalStateException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    throw new IllegalStateException("Already done");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getData() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDone) {
                    throw new IllegalStateException("Not yet done");
                }
                return this.mDataSinkBuf != null ? this.mDataSinkBuf.toByteArray() : new byte[]{};
            }
        }
    }

    private static class OutputApkSigningBlockRequestImpl
    implements ApkSignerEngine.OutputApkSigningBlockRequest,
    ApkSignerEngine.OutputApkSigningBlockRequest2 {
        private final byte[] mApkSigningBlock;
        private final int mPaddingBeforeApkSigningBlock;
        private volatile boolean mDone;

        private OutputApkSigningBlockRequestImpl(byte[] apkSigingBlock, int paddingBefore) {
            this.mApkSigningBlock = (byte[])apkSigingBlock.clone();
            this.mPaddingBeforeApkSigningBlock = paddingBefore;
        }

        @Override
        public byte[] getApkSigningBlock() {
            return (byte[])this.mApkSigningBlock.clone();
        }

        @Override
        public void done() {
            this.mDone = true;
        }

        private boolean isDone() {
            return this.mDone;
        }

        @Override
        public int getPaddingSizeBeforeApkSigningBlock() {
            return this.mPaddingBeforeApkSigningBlock;
        }
    }

    private static class OutputJarSignatureRequestImpl
    implements ApkSignerEngine.OutputJarSignatureRequest {
        private final List<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> mAdditionalJarEntries;
        private volatile boolean mDone;

        private OutputJarSignatureRequestImpl(List<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> additionalZipEntries) {
            this.mAdditionalJarEntries = Collections.unmodifiableList(new ArrayList<ApkSignerEngine.OutputJarSignatureRequest.JarEntry>(additionalZipEntries));
        }

        @Override
        public List<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> getAdditionalJarEntries() {
            return this.mAdditionalJarEntries;
        }

        @Override
        public void done() {
            this.mDone = true;
        }

        private boolean isDone() {
            return this.mDone;
        }
    }
}

