/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk;

import com.android.apksig.ApkVerificationIssue;
import com.android.apksig.internal.apk.ApkSignerInfo;
import java.util.ArrayList;
import java.util.List;

public class ApkSigResult {
    public final int signatureSchemeVersion;
    public boolean verified;
    public final List<ApkSignerInfo> mSigners = new ArrayList<ApkSignerInfo>();
    private final List<ApkVerificationIssue> mWarnings = new ArrayList<ApkVerificationIssue>();
    private final List<ApkVerificationIssue> mErrors = new ArrayList<ApkVerificationIssue>();

    public ApkSigResult(int signatureSchemeVersion) {
        this.signatureSchemeVersion = signatureSchemeVersion;
    }

    public boolean containsErrors() {
        if (!this.mErrors.isEmpty()) {
            return true;
        }
        if (!this.mSigners.isEmpty()) {
            for (ApkSignerInfo signer : this.mSigners) {
                if (!signer.containsErrors()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsWarnings() {
        if (!this.mWarnings.isEmpty()) {
            return true;
        }
        if (!this.mSigners.isEmpty()) {
            for (ApkSignerInfo signer : this.mSigners) {
                if (!signer.containsWarnings()) continue;
                return true;
            }
        }
        return false;
    }

    public void addError(int issueId, Object ... parameters) {
        this.mErrors.add(new ApkVerificationIssue(issueId, parameters));
    }

    public void addWarning(int issueId, Object ... parameters) {
        this.mWarnings.add(new ApkVerificationIssue(issueId, parameters));
    }

    public List<? extends ApkVerificationIssue> getErrors() {
        return this.mErrors;
    }

    public List<? extends ApkVerificationIssue> getWarnings() {
        return this.mWarnings;
    }
}

