/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.internal.apk.ApkSigningBlockUtilsLite;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SourceStampCertificateLineage {
    private static final int FIRST_VERSION = 1;
    private static final int CURRENT_VERSION = 1;

    public static List<SigningCertificateNode> readSigningCertificateLineage(ByteBuffer inputBytes) throws IOException {
        CertificateFactory certFactory;
        ArrayList<SigningCertificateNode> result = new ArrayList<SigningCertificateNode>();
        int nodeCount = 0;
        if (inputBytes == null || !inputBytes.hasRemaining()) {
            return null;
        }
        ApkSigningBlockUtilsLite.checkByteOrderLittleEndian(inputBytes);
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Failed to obtain X.509 CertificateFactory", e);
        }
        Certificate lastCert = null;
        int lastSigAlgorithmId = 0;
        try {
            int version = inputBytes.getInt();
            if (version != 1) {
                throw new IllegalArgumentException("Encoded SigningCertificateLineage has a version different than any of which we are aware");
            }
            HashSet<Certificate> certHistorySet = new HashSet<Certificate>();
            while (inputBytes.hasRemaining()) {
                ++nodeCount;
                ByteBuffer nodeBytes = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(inputBytes);
                ByteBuffer signedData = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(nodeBytes);
                int flags = nodeBytes.getInt();
                int sigAlgorithmId = nodeBytes.getInt();
                SignatureAlgorithm sigAlgorithm = SignatureAlgorithm.findById(lastSigAlgorithmId);
                byte[] signature = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray(nodeBytes);
                if (lastCert != null) {
                    String jcaSignatureAlgorithm = sigAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
                    AlgorithmParameterSpec jcaSignatureAlgorithmParams = sigAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
                    PublicKey publicKey = lastCert.getPublicKey();
                    Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
                    sig.initVerify(publicKey);
                    if (jcaSignatureAlgorithmParams != null) {
                        sig.setParameter(jcaSignatureAlgorithmParams);
                    }
                    sig.update(signedData);
                    if (!sig.verify(signature)) {
                        throw new SecurityException("Unable to verify signature of certificate #" + nodeCount + " using " + jcaSignatureAlgorithm + " when verifying SourceStampCertificateLineage object");
                    }
                }
                signedData.rewind();
                byte[] encodedCert = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray(signedData);
                int signedSigAlgorithm = signedData.getInt();
                if (lastCert != null && lastSigAlgorithmId != signedSigAlgorithm) {
                    throw new SecurityException("Signing algorithm ID mismatch for certificate #" + nodeBytes + " when verifying SourceStampCertificateLineage object");
                }
                lastCert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(encodedCert));
                if (certHistorySet.contains(lastCert = new GuaranteedEncodedFormX509Certificate((X509Certificate)lastCert, encodedCert))) {
                    throw new SecurityException("Encountered duplicate entries in SigningCertificateLineage at certificate #" + nodeCount + ".  All signing certificates should be unique");
                }
                certHistorySet.add(lastCert);
                lastSigAlgorithmId = sigAlgorithmId;
                result.add(new SigningCertificateNode((X509Certificate)lastCert, SignatureAlgorithm.findById(signedSigAlgorithm), SignatureAlgorithm.findById(sigAlgorithmId), signature, flags));
            }
        }
        catch (ApkFormatException | BufferUnderflowException e) {
            throw new IOException("Failed to parse SourceStampCertificateLineage object", e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SecurityException("Failed to verify signature over signed data for certificate #" + nodeCount + " when parsing SourceStampCertificateLineage object", e);
        }
        catch (CertificateException e) {
            throw new SecurityException("Failed to decode certificate #" + nodeCount + " when parsing SourceStampCertificateLineage object", e);
        }
        return result;
    }

    public static class SigningCertificateNode {
        public final X509Certificate signingCert;
        public final SignatureAlgorithm parentSigAlgorithm;
        public SignatureAlgorithm sigAlgorithm;
        public final byte[] signature;
        public int flags;

        public SigningCertificateNode(X509Certificate signingCert, SignatureAlgorithm parentSigAlgorithm, SignatureAlgorithm sigAlgorithm, byte[] signature, int flags) {
            this.signingCert = signingCert;
            this.parentSigAlgorithm = parentSigAlgorithm;
            this.sigAlgorithm = sigAlgorithm;
            this.signature = signature;
            this.flags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SigningCertificateNode)) {
                return false;
            }
            SigningCertificateNode that = (SigningCertificateNode)o;
            if (!this.signingCert.equals(that.signingCert)) {
                return false;
            }
            if (this.parentSigAlgorithm != that.parentSigAlgorithm) {
                return false;
            }
            if (this.sigAlgorithm != that.sigAlgorithm) {
                return false;
            }
            if (!Arrays.equals(this.signature, that.signature)) {
                return false;
            }
            return this.flags == that.flags;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.signingCert == null ? 0 : this.signingCert.hashCode());
            result = 31 * result + (this.parentSigAlgorithm == null ? 0 : this.parentSigAlgorithm.hashCode());
            result = 31 * result + (this.sigAlgorithm == null ? 0 : this.sigAlgorithm.hashCode());
            result = 31 * result + Arrays.hashCode(this.signature);
            result = 31 * result + this.flags;
            return result;
        }
    }
}

