/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessEnvBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.sdklib.BuildToolInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DexProcessBuilder
extends ProcessEnvBuilder<DexProcessBuilder> {
    private final File outputFile;
    private boolean verbose = false;
    private boolean multiDex = false;
    private File mainDexList = null;
    private Set<File> inputs = Sets.newHashSet();
    private Integer minSdkVersion;

    public DexProcessBuilder(File outputFile) {
        this.outputFile = outputFile;
    }

    public DexProcessBuilder setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public DexProcessBuilder setMultiDex(boolean multiDex) {
        this.multiDex = multiDex;
        return this;
    }

    public DexProcessBuilder setMainDexList(File mainDexList) {
        this.mainDexList = mainDexList;
        return this;
    }

    public DexProcessBuilder addInput(File input) {
        this.inputs.add(input);
        return this;
    }

    public DexProcessBuilder addInputs(Collection<File> inputs) {
        this.inputs.addAll(inputs);
        return this;
    }

    public Integer getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public DexProcessBuilder setMinSdkVersion(Integer minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
        return this;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isMultiDex() {
        return this.multiDex;
    }

    public File getMainDexList() {
        return this.mainDexList;
    }

    public Set<File> getInputs() {
        return this.inputs;
    }

    public JavaProcessInfo build(BuildToolInfo buildToolInfo, DexOptions dexOptions) throws ProcessException {
        Integer threadCount;
        Preconditions.checkState((buildToolInfo.getRevision().compareTo(AndroidBuilder.MIN_BUILD_TOOLS_REV) >= 0 ? 1 : 0) != 0);
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.addEnvironments(this.mEnvironment);
        String dx = buildToolInfo.getPath(BuildToolInfo.PathId.DX_JAR);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx.jar is missing");
        }
        builder.setClasspath(dx);
        builder.setMain("com.android.dx.command.Main");
        if (dexOptions.getJavaMaxHeapSize() != null) {
            builder.addJvmArg("-Xmx" + dexOptions.getJavaMaxHeapSize());
        } else {
            builder.addJvmArg("-Xmx1024M");
        }
        builder.addArgs("--dex");
        if (this.verbose) {
            builder.addArgs("--verbose");
        }
        if (dexOptions.getJumboMode()) {
            builder.addArgs("--force-jumbo");
        }
        if ((threadCount = dexOptions.getThreadCount()) == null) {
            builder.addArgs("--num-threads=4");
        } else {
            builder.addArgs("--num-threads=" + threadCount);
        }
        if (this.multiDex) {
            builder.addArgs("--multi-dex");
            if (this.mainDexList != null) {
                builder.addArgs("--main-dex-list", this.mainDexList.getAbsolutePath());
            }
        }
        for (String arg : dexOptions.getAdditionalParameters()) {
            builder.addArgs(arg);
        }
        builder.addArgs("--output", this.outputFile.getAbsolutePath());
        builder.addArgs(this.getFilesToAdd());
        return builder.createJavaProcess();
    }

    public List<String> getFilesToAdd() throws ProcessException {
        Set existingFiles = Sets.filter(this.inputs, input -> input != null && input.exists());
        if (existingFiles.isEmpty()) {
            throw new ProcessException("No files to pass to dex.");
        }
        Set files = existingFiles;
        ArrayList filePathList = Lists.newArrayListWithCapacity((int)files.size());
        for (File f : files) {
            filePathList.add(f.getAbsolutePath());
        }
        return filePathList;
    }
}

