/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexArchiveMergerCallable;
import com.android.builder.dexing.DexArchives;
import com.android.builder.dexing.DexMergerConfig;
import com.android.builder.dexing.DexMergingStrategy;
import com.android.builder.dexing.DexingType;
import com.android.builder.dexing.ReferenceCountMergingStrategy;
import com.android.dex.Dex;
import com.android.utils.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class DexArchiveMerger {
    private final DexMergerConfig config;
    private final DexMergingStrategy mergingStrategy;
    private final ForkJoinPool forkJoinPool;

    public DexArchiveMerger(DexMergerConfig config, ForkJoinPool forkJoinPool) {
        this(config, new ReferenceCountMergingStrategy(), forkJoinPool);
    }

    public DexArchiveMerger(DexMergerConfig config, DexMergingStrategy mergingStrategy, ForkJoinPool forkJoinPool) {
        this.config = config;
        this.mergingStrategy = mergingStrategy;
        this.forkJoinPool = forkJoinPool;
    }

    public void merge(Collection<Path> inputs, Path outputDir, Set<String> mainDexClasses) throws IOException {
        if (inputs.isEmpty()) {
            return;
        }
        List inputPaths = Ordering.natural().sortedCopy(inputs);
        switch (this.config.getDexingType()) {
            case MONO_DEX: {
                Preconditions.checkState((mainDexClasses == null ? 1 : 0) != 0, (Object)"Main dex list cannot be set for monodex.");
                this.mergeMonoDex(inputPaths, outputDir);
                break;
            }
            case LEGACY_MULTIDEX: {
                Preconditions.checkNotNull(mainDexClasses, (Object)"Main dex list must be set for legacy multidex.");
                this.mergeMultidex(inputPaths, outputDir, mainDexClasses);
                break;
            }
            case NATIVE_MULTIDEX: {
                Preconditions.checkState((mainDexClasses == null ? 1 : 0) != 0, (Object)"Main dex list cannot be set for native multidex.");
                this.mergeMultidex(inputPaths, outputDir, Collections.emptySet());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown dexing type" + (Object)((Object)this.config.getDexingType()));
            }
        }
    }

    private void mergeMonoDex(Collection<Path> inputs, Path output) throws IOException {
        ConcurrentMap dexesFromArchives = Maps.newConcurrentMap();
        AtomicInteger inputsToProcess = new AtomicInteger(inputs.size());
        ArrayList<Future> subTasks = new ArrayList<Future>();
        for (Path archivePath : inputs) {
            subTasks.add(this.forkJoinPool.submit(() -> {
                try (DexArchive dexArchive = DexArchives.fromInput(archivePath);){
                    List<DexArchiveEntry> entries = dexArchive.getFiles();
                    ArrayList<Dex> dexes = new ArrayList<Dex>(entries.size());
                    for (DexArchiveEntry e : entries) {
                        dexes.add(new Dex(e.getDexFileContent()));
                    }
                    dexesFromArchives.put(dexArchive.getRootPath(), dexes);
                }
                if (inputsToProcess.decrementAndGet() == 0) {
                    this.mergeMonoDexEntries(output, dexesFromArchives).join();
                }
                return null;
            }));
        }
        subTasks.forEach((Consumer<Future>)((Consumer<ForkJoinTask>)ForkJoinTask::join));
    }

    private ForkJoinTask<Void> mergeMonoDexEntries(Path output, Map<Path, List<Dex>> dexesFromArchives) {
        List sortedPaths = Ordering.natural().sortedCopy(dexesFromArchives.keySet());
        int numberOfDexFiles = dexesFromArchives.values().stream().mapToInt(List::size).sum();
        ArrayList<Dex> sortedDexes = new ArrayList<Dex>(numberOfDexFiles);
        for (Path p : sortedPaths) {
            sortedDexes.addAll((Collection<Dex>)dexesFromArchives.get(p));
        }
        return this.submitForMerging(sortedDexes, output.resolve(this.getDexFileName(0)));
    }

    private void mergeMultidex(Collection<Path> inputs, Path output, Set<String> mainDexClasses) throws IOException {
        Iterator<DexArchiveEntry> entries = this.getAllEntries(inputs);
        if (!entries.hasNext()) {
            return;
        }
        int classesDexSuffix = this.config.getDexingType() == DexingType.LEGACY_MULTIDEX ? 1 : 0;
        ArrayList<ForkJoinTask<Void>> subTasks = new ArrayList<ForkJoinTask<Void>>();
        ArrayList toMergeInMain = Lists.newArrayList();
        this.mergingStrategy.startNewDex();
        while (entries.hasNext()) {
            Path classFile;
            String unixClassFile;
            DexArchiveEntry entry = entries.next();
            Dex dex = new Dex(entry.getDexFileContent());
            if (this.config.getDexingType() == DexingType.LEGACY_MULTIDEX && mainDexClasses.contains(unixClassFile = PathUtils.toSystemIndependentPath((Path)(classFile = DexArchiveEntry.withClassExtension(entry.getRelativePathInArchive()))))) {
                toMergeInMain.add(dex);
                continue;
            }
            if (this.mergingStrategy.tryToAddForMerging(dex)) continue;
            Path dexOutput = output.resolve(this.getDexFileName(classesDexSuffix++));
            subTasks.add(this.submitForMerging((List<Dex>)this.mergingStrategy.getAllDexToMerge(), dexOutput));
            this.mergingStrategy.startNewDex();
            if (this.mergingStrategy.tryToAddForMerging(dex)) continue;
            throw new DexArchiveMergerException("A single DEX file from a dex archive has more than 64K references.");
        }
        if (this.config.getDexingType() == DexingType.LEGACY_MULTIDEX) {
            subTasks.add(this.submitForMerging(toMergeInMain, output.resolve(this.getDexFileName(0))));
        }
        if (!this.mergingStrategy.getAllDexToMerge().isEmpty()) {
            Path dexOutput = output.resolve(this.getDexFileName(classesDexSuffix));
            subTasks.add(this.submitForMerging((List<Dex>)this.mergingStrategy.getAllDexToMerge(), dexOutput));
        }
        subTasks.forEach(ForkJoinTask::join);
    }

    private Iterator<DexArchiveEntry> getAllEntries(Collection<Path> inputs) throws IOException {
        return inputs.stream().map(this::getEntriesFromSingleArchive).flatMap(Collection::stream).iterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DexArchiveEntry> getEntriesFromSingleArchive(Path archivePath) {
        try (DexArchive archive = DexArchives.fromInput(archivePath);){
            List<DexArchiveEntry> list = archive.getFiles();
            return list;
        }
        catch (IOException e) {
            throw new DexArchiveMergerException("Unable to read DEX files from dex archive " + archivePath.toString(), e);
        }
    }

    private ForkJoinTask<Void> submitForMerging(List<Dex> dexes, Path dexOutputPath) {
        return this.forkJoinPool.submit((Callable)new DexArchiveMergerCallable(dexes, dexOutputPath, this.config.getDxContext()));
    }

    private String getDexFileName(int classesDexIndex) {
        if (classesDexIndex == 0) {
            return "classes.dex";
        }
        return String.format("classes%d.dex", classesDexIndex + 1);
    }

    public static class DexArchiveMergerException
    extends RuntimeException {
        public DexArchiveMergerException(String message, Throwable cause) {
            super(message, cause);
        }

        public DexArchiveMergerException(String message) {
            super(message);
        }
    }
}

