/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.core.DefaultApiVersion;
import com.android.builder.dexing.DexingType;
import com.android.builder.model.ApiVersion;

public final class DexingMode {
    private final DexingType dexingType;
    private final ApiVersion minSdkVersion;

    public DexingMode(DexingType dexingType) {
        this.dexingType = dexingType;
        this.minSdkVersion = null;
    }

    public DexingMode(DexingType dexingType, ApiVersion minSdkVersion) {
        this.dexingType = dexingType;
        this.minSdkVersion = minSdkVersion;
    }

    public DexingType getDexingType() {
        return this.dexingType;
    }

    public boolean isMultiDex() {
        return this.dexingType.isMultiDex();
    }

    public boolean isPreDex() {
        return this.dexingType.isPreDex();
    }

    public ApiVersion getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public Integer getMinSdkVersionValue() {
        return this.minSdkVersion != null ? Integer.valueOf(DefaultApiVersion.getFeatureLevel(this.minSdkVersion)) : null;
    }
}

