/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt;

import com.android.builder.core.VariantType;
import com.android.builder.model.AaptOptions;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.ILogger;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class AaptPackageConfig
implements Cloneable {
    private File mManifestFile;
    private AaptOptions mAaptOptions;
    private File mSourceOutputDir;
    private File mResourceOutputApk;
    private ImmutableList<LibraryInfo> mLibraries = ImmutableList.of();
    private File mSymbolOutputDir;
    private boolean mVerbose = false;
    private File mResourceDir;
    private File mProguardOutputFile;
    private File mMainDexListProguardOutputFile;
    private ImmutableCollection<String> mSplits;
    private boolean mDebuggable;
    private String mPackageForR;
    private boolean mPseudoLocalize;
    private String mPreferredDensity;
    private BuildToolInfo mBuildToolInfo;
    private IAndroidTarget mAndroidTarget;
    private ILogger mLogger;
    private ImmutableSet<String> mResourceConfigs = ImmutableSet.of();
    private VariantType mVariantType;
    private File mBaseFeature;
    private ImmutableSet<File> mPreviousFeatures = ImmutableSet.of();
    private Integer mPackageId;
    private ImmutableSet<File> mDependentFeatures = ImmutableSet.of();
    private boolean mListResourceFiles;

    private AaptPackageConfig() {
    }

    public AaptPackageConfig clone() {
        try {
            return (AaptPackageConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Verify.verify((boolean)false);
            return new AaptPackageConfig();
        }
    }

    public File getManifestFile() {
        return this.mManifestFile;
    }

    public AaptOptions getOptions() {
        return this.mAaptOptions;
    }

    public File getSourceOutputDir() {
        return this.mSourceOutputDir;
    }

    public File getResourceOutputApk() {
        return this.mResourceOutputApk;
    }

    public List<LibraryInfo> getLibraries() {
        return this.mLibraries;
    }

    public File getSymbolOutputDir() {
        return this.mSymbolOutputDir;
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public File getResourceDir() {
        return this.mResourceDir;
    }

    public File getProguardOutputFile() {
        return this.mProguardOutputFile;
    }

    public File getMainDexListProguardOutputFile() {
        return this.mMainDexListProguardOutputFile;
    }

    public Collection<String> getSplits() {
        if (this.mSplits == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.mSplits);
    }

    public boolean isDebuggable() {
        return this.mDebuggable;
    }

    public String getCustomPackageForR() {
        return this.mPackageForR;
    }

    public boolean isPseudoLocalize() {
        return this.mPseudoLocalize;
    }

    public String getPreferredDensity() {
        return this.mPreferredDensity;
    }

    public BuildToolInfo getBuildToolInfo() {
        return this.mBuildToolInfo;
    }

    public IAndroidTarget getAndroidTarget() {
        return this.mAndroidTarget;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public Set<String> getResourceConfigs() {
        return Collections.unmodifiableSet(this.mResourceConfigs);
    }

    public VariantType getVariantType() {
        return this.mVariantType;
    }

    public File getBaseFeature() {
        return this.mBaseFeature;
    }

    public Set<File> getPreviousFeatures() {
        return this.mPreviousFeatures;
    }

    public Integer getPackageId() {
        return this.mPackageId;
    }

    public Set<File> getDependentFeatures() {
        return this.mDependentFeatures;
    }

    public boolean isListResourceFiles() {
        return this.mListResourceFiles;
    }

    public static class Builder {
        private final AaptPackageConfig mConfig = new AaptPackageConfig();

        public AaptPackageConfig build() {
            return this.mConfig.clone();
        }

        public Builder setManifestFile(File manifestFile) {
            if (!manifestFile.isFile()) {
                throw new IllegalArgumentException("Manifest file '{0}' is not a readable file." + manifestFile.getAbsolutePath());
            }
            this.mConfig.mManifestFile = manifestFile;
            return this;
        }

        public Builder setOptions(AaptOptions options) {
            this.mConfig.mAaptOptions = options;
            return this;
        }

        public Builder setSourceOutputDir(File sourceOutputDir) {
            this.mConfig.mSourceOutputDir = sourceOutputDir;
            return this;
        }

        public Builder setSymbolOutputDir(File symbolOutputDir) {
            this.mConfig.mSymbolOutputDir = symbolOutputDir;
            return this;
        }

        public Builder setLibraries(List<LibraryInfo> libraries) {
            if (libraries == null) {
                this.mConfig.mLibraries = ImmutableList.of();
            } else {
                this.mConfig.mLibraries = ImmutableList.copyOf(libraries);
            }
            return this;
        }

        public Builder setResourceOutputApk(File resourceOutputApk) {
            this.mConfig.mResourceOutputApk = resourceOutputApk;
            return this;
        }

        public Builder setResourceDir(File resourceDir) {
            if (resourceDir != null && !resourceDir.isDirectory()) {
                throw new IllegalArgumentException("Path '" + resourceDir.getAbsolutePath() + "' is not a readable directory.");
            }
            this.mConfig.mResourceDir = resourceDir;
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            this.mConfig.mVerbose = verbose;
            return this;
        }

        public Builder setProguardOutputFile(File proguardOutputFile) {
            this.mConfig.mProguardOutputFile = proguardOutputFile;
            return this;
        }

        public Builder setMainDexListProguardOutputFile(File mainDexListProguardOutputFile) {
            this.mConfig.mMainDexListProguardOutputFile = mainDexListProguardOutputFile;
            return this;
        }

        public Builder setSplits(Collection<String> splits) {
            if (splits == null) {
                this.mConfig.mSplits = null;
            } else {
                this.mConfig.mSplits = (ImmutableCollection)ImmutableList.copyOf(splits);
            }
            return this;
        }

        public Builder setDebuggable(boolean debuggable) {
            this.mConfig.mDebuggable = debuggable;
            return this;
        }

        public Builder setPseudoLocalize(boolean pseudoLocalize) {
            this.mConfig.mPseudoLocalize = pseudoLocalize;
            return this;
        }

        public Builder setPreferredDensity(String preferredDensity) {
            this.mConfig.mPreferredDensity = preferredDensity;
            return this;
        }

        public Builder setBuildToolInfo(BuildToolInfo buildToolInfo) {
            this.mConfig.mBuildToolInfo = buildToolInfo;
            return this;
        }

        public Builder setAndroidTarget(IAndroidTarget androidTarget) {
            this.mConfig.mAndroidTarget = androidTarget;
            return this;
        }

        public Builder setLogger(ILogger logger) {
            this.mConfig.mLogger = logger;
            return this;
        }

        public Builder setResourceConfigs(Collection<String> resourceConfigs) {
            this.mConfig.mResourceConfigs = ImmutableSet.copyOf(resourceConfigs);
            return this;
        }

        public Builder setVariantType(VariantType variantType) {
            this.mConfig.mVariantType = variantType;
            return this;
        }

        public Builder setCustomPackageForR(String packageForR) {
            this.mConfig.mPackageForR = packageForR;
            return this;
        }

        public Builder setBaseFeature(File baseFeature) {
            this.mConfig.mBaseFeature = baseFeature;
            return this;
        }

        public Builder setPreviousFeatures(Collection<File> previousFeatures) {
            this.mConfig.mPreviousFeatures = ImmutableSet.copyOf(previousFeatures);
            return this;
        }

        public Builder setPackageId(Integer packageId) {
            this.mConfig.mPackageId = packageId;
            return this;
        }

        public Builder setDependentFeatures(Collection<File> dependentFeatures) {
            this.mConfig.mDependentFeatures = ImmutableSet.copyOf(dependentFeatures);
            return this;
        }

        public Builder setListResourceFiles(boolean listResourceFiles) {
            this.mConfig.mListResourceFiles = listResourceFiles;
            return this;
        }
    }

    public static class LibraryInfo {
        private final File manifest;
        private final File symbolFile;

        public LibraryInfo(File manifest, File symbolFile) {
            this.manifest = manifest;
            this.symbolFile = symbolFile;
        }

        public File getManifest() {
            return this.manifest;
        }

        public File getSymbolFile() {
            return this.symbolFile;
        }
    }
}

