/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DxDexArchiveBuilder;
import com.google.common.base.Verify;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public abstract class DexArchiveBuilder {
    public static DexArchiveBuilder createDxDexBuilder(DexArchiveBuilderConfig config) {
        return new DxDexArchiveBuilder(config);
    }

    public void convert(ClassFileInput input, DexArchive output) throws DexArchiveBuilderException {
        try {
            DexArchiveBuilder.ensureOutputArchiveExists(output);
            List<DexArchiveEntry> convertedEntries = this.convertClassFileInput(input);
            DexArchiveBuilder.writeToArchive(convertedEntries, output);
        }
        catch (IOException e) {
            throw new DexArchiveBuilderException(e);
        }
    }

    protected abstract List<DexArchiveEntry> convertClassFileInput(ClassFileInput var1);

    private static void writeToArchive(List<DexArchiveEntry> entries, DexArchive output) throws IOException {
        for (DexArchiveEntry dexEntry : entries) {
            Verify.verifyNotNull((Object)dexEntry);
            ByteArrayInputStream dexContent = new ByteArrayInputStream(dexEntry.getDexFileContent());
            Throwable throwable = null;
            try {
                Path dexFilePath = ClassFileEntry.withDexExtension(dexEntry.getRelativePathInArchive());
                output.addFile(dexFilePath, dexContent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dexContent == null) continue;
                if (throwable != null) {
                    try {
                        dexContent.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dexContent.close();
            }
        }
    }

    private static void ensureOutputArchiveExists(DexArchive dexArchive) throws IOException {
        if (Files.notExists(dexArchive.getRootPath(), new LinkOption[0])) {
            if (ClassFileInputs.jarMatcher.matches(dexArchive.getRootPath())) {
                Files.createDirectories(dexArchive.getRootPath().getParent(), new FileAttribute[0]);
                Files.createFile(dexArchive.getRootPath(), new FileAttribute[0]);
            } else {
                Files.createDirectories(dexArchive.getRootPath(), new FileAttribute[0]);
            }
        }
    }
}

