/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.aapt2;

import com.android.SdkConstants;
import com.android.tools.aapt2.Aapt2Exception;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.io.Resources;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

enum Aapt2JniPlatform {
    WIN_64("win64", HashCode.fromString((String)"e019c1d14f9cf7e30cdec20198c257cf990f0a33da6fe31c0afce47592893e7f"), "libwinpthread-1.dll", "libaapt2_jni.dll"),
    WIN_32("win32", HashCode.fromString((String)"dab006dbcd663b441eacd4c9060cf06704e35a091f5ad897df489d77d7964047"), "libwinpthread-1.dll", "libaapt2_jni.dll"),
    MAC_64("mac64", HashCode.fromString((String)"919fafbbdd26a48972189da1ba761866f7b568bbc714eac300af7df7c07323e1"), "libc++.dylib", "libaapt2_jni.dylib"),
    LINUX_64("linux64", HashCode.fromString((String)"c46dbbff8861113aa2bb470bf698dd9315bc5c7e35c25db965acb8e1e796b83b"), "libc++.so", "libaapt2_jni.so");

    private final String directoryName;
    private final HashCode cacheKey;
    private final ImmutableList<String> fileNames;

    private Aapt2JniPlatform(String directoryName, HashCode cacheKey, String ... fileNames) {
        this.directoryName = directoryName;
        this.cacheKey = cacheKey;
        this.fileNames = ImmutableList.copyOf((Object[])fileNames);
    }

    static Aapt2JniPlatform getCurrentPlatform() {
        boolean is64Bit = System.getProperty("os.arch").contains("64");
        switch (SdkConstants.CURRENT_PLATFORM) {
            case 2: {
                return is64Bit ? WIN_64 : WIN_32;
            }
            case 3: {
                if (!is64Bit) {
                    throw new Aapt2Exception("32-bit JVM is not supported");
                }
                return MAC_64;
            }
            case 1: {
                if (!is64Bit) {
                    throw new Aapt2Exception("32-bit JVM is not supported");
                }
                return LINUX_64;
            }
        }
        throw new IllegalStateException("Unknown platform");
    }

    HashCode getCacheKey() {
        return this.cacheKey;
    }

    void writeToDirectory(Path directory) throws IOException {
        for (String fileName : this.fileNames) {
            URL url = this.getResource(fileName);
            BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
            Throwable throwable = null;
            try {
                Files.copy(inputStream, directory.resolve(fileName), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)inputStream).close();
            }
        }
    }

    List<Path> getFiles(Path cacheDirectory) {
        return this.fileNames.stream().map(cacheDirectory::resolve).collect(Collectors.toList());
    }

    private URL getResource(String fileName) {
        return Resources.getResource((String)(this.directoryName + "/" + fileName));
    }
}

