/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.dex.DexFileReader;
import com.android.tools.r8.dex.Segment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class BSPatch {
    private static final char[] BSDIFF_MAGIC = "BSDIFF40".toCharArray();
    private static final int BSDIFF_HEADER_LENGTH = 32;
    private final ByteBuffer patchInput;
    private final ByteBuffer oldInput;
    private final Path output;
    private final Path dexPath;
    private InputStream controlStream;
    private InputStream diffStream;
    private InputStream extraStream;
    private long controlBytesRead;
    private long diffBytesRead;
    private long extraBytesRead;
    private int controlBlockLen;
    private int diffBlockLen;
    private int extraBlockLen;

    public static void main(String[] args) {
        int argOffset;
        boolean imageMode = args.length > 1 && args[0].equals("-i");
        int n = argOffset = imageMode ? 1 : 0;
        if (args.length < argOffset + 3) {
            System.out.println("Usage: [-i] <patch file> <original dex> <output file> [target dex]");
            System.exit(1);
        }
        try {
            new BSPatch(Paths.get(args[argOffset], new String[0]), Paths.get(args[argOffset + 1], new String[0]), Paths.get(args[argOffset + 2], new String[0]), args.length != argOffset + 4 ? null : Paths.get(args[argOffset + 3], new String[0])).apply(imageMode);
        }
        catch (IOException e) {
            System.err.println("File I/O error: " + e.toString());
        }
        catch (CompressorException e) {
            System.err.println("BZIP error: " + e.toString());
        }
    }

    private BSPatch(Path patchInput, Path oldInput, Path output, Path dexPath) throws IOException {
        this.patchInput = ByteBuffer.wrap(Files.readAllBytes(patchInput));
        this.oldInput = ByteBuffer.wrap(Files.readAllBytes(oldInput));
        this.output = output;
        this.dexPath = dexPath;
    }

    public void apply(boolean imageMode) throws CompressorException, IOException {
        PatchExecutor executor = imageMode ? new ImageExecutor(this.dexPath) : new FileExecutor();
        this.checkHeader();
        this.setupSegmentsAndOutput(executor);
        this.processControl(executor);
        executor.writeResult();
        this.printStats();
    }

    private int percentOf(long a, long b) {
        return (int)((double)a / (double)b * 100.0);
    }

    private void printStats() {
        System.out.println("Size of control block (compressed bytes): " + this.controlBlockLen);
        System.out.println("Size of control block (read bytes): " + this.controlBytesRead);
        System.out.println("Compression of control block: " + this.percentOf(this.controlBlockLen, this.controlBytesRead));
        System.out.println("Size of diff data block (compressed bytes): " + this.diffBlockLen);
        System.out.println("Size of diff data block (read bytes): " + this.diffBytesRead);
        System.out.println("Compression of diff data block: " + this.percentOf(this.diffBlockLen, this.diffBytesRead));
        System.out.println("Size of extra data block (compressed bytes): " + this.extraBlockLen);
        System.out.println("Size of extra data block (read bytes): " + this.extraBytesRead);
        System.out.println("Compression of extra data block: " + this.percentOf(this.extraBlockLen, this.extraBytesRead));
    }

    private void processControl(PatchExecutor executor) throws IOException {
        int blockSize;
        while ((blockSize = this.readNextControlEntry()) != Integer.MIN_VALUE) {
            int extraSize = this.readNextControlEntry();
            int advanceOld = this.readNextControlEntry();
            executor.copyDiff(blockSize);
            executor.copyOld(blockSize);
            executor.submitBlock(blockSize);
            executor.copyExtra(extraSize);
            executor.skipOld(advanceOld);
        }
    }

    private void checkHeader() {
        for (int i = 0; i < BSDIFF_MAGIC.length; ++i) {
            if (this.patchInput.get() == BSDIFF_MAGIC[i]) continue;
            throw new RuntimeException("Illegal patch, wrong magic!");
        }
    }

    private void setupSegmentsAndOutput(PatchExecutor executor) throws CompressorException, IOException {
        this.controlBlockLen = this.readOffset();
        this.diffBlockLen = this.readOffset();
        int newFileSize = this.readOffset();
        this.extraBlockLen = this.patchInput.array().length - (32 + this.controlBlockLen + this.diffBlockLen);
        executor.createOutput(newFileSize);
        this.controlStream = new BZip2CompressorInputStream((InputStream)new ByteArrayInputStream(this.patchInput.array(), 32, this.controlBlockLen));
        this.diffStream = new BZip2CompressorInputStream((InputStream)new ByteArrayInputStream(this.patchInput.array(), 32 + this.controlBlockLen, this.diffBlockLen));
        this.extraStream = new BZip2CompressorInputStream((InputStream)new ByteArrayInputStream(this.patchInput.array(), 32 + this.controlBlockLen + this.diffBlockLen, this.extraBlockLen));
    }

    private int readOffset() {
        byte[] buffer = new byte[8];
        this.patchInput.get(buffer);
        return BSPatch.decodeOffset(buffer);
    }

    private int readNextControlEntry() throws IOException {
        byte[] buffer = new byte[8];
        int read = this.controlStream.read(buffer);
        if (read == -1) {
            return Integer.MIN_VALUE;
        }
        this.controlBytesRead += (long)read;
        assert (read == buffer.length);
        return BSPatch.decodeOffset(buffer);
    }

    private static int decodeOffset(byte[] buffer) {
        long offset = buffer[7] & 0x7F;
        for (int i = 6; i >= 0; --i) {
            offset = offset << 8 | (long)(buffer[i] & 0xFF);
        }
        if ((buffer[7] & 0x80) != 0) {
            offset = -offset;
        }
        assert (offset < Integer.MAX_VALUE && offset > Integer.MIN_VALUE);
        return (int)offset;
    }

    private class ImageExecutor
    extends PatchExecutor {
        private final Path dexPath;
        BufferedImage image;
        int position;
        int width;
        int height;

        private ImageExecutor(Path dexPath) {
            this.position = 0;
            this.dexPath = dexPath;
        }

        @Override
        public void createOutput(int newFileSize) {
            int root = (int)Math.sqrt(newFileSize);
            this.width = newFileSize / root;
            this.height = newFileSize / this.width + 1;
            this.image = new BufferedImage(this.width, this.height, 5);
        }

        @Override
        public void copyDiff(int blockSize) throws IOException {
            byte[] buffer = new byte[blockSize];
            int read = BSPatch.this.diffStream.read(buffer);
            assert (read == blockSize);
            BSPatch.this.diffBytesRead = BSPatch.this.diffBytesRead + (long)read;
            for (int i = 0; i < buffer.length; ++i) {
                if (buffer[i] == 0) continue;
                int y = (this.position + i) / this.width;
                int x = (this.position + i) % this.width;
                int rgb = this.image.getRGB(x, y);
                this.image.setRGB(x, y, rgb |= 0xFF0000);
            }
        }

        @Override
        public void copyOld(int blockSize) throws IOException {
            for (int i = 0; i < blockSize; ++i) {
                int x = (this.position + i) % this.width;
                int y = (this.position + i) / this.width;
                int rgb = this.image.getRGB(x, y);
                if ((rgb & 0xFF0000) == 0) {
                    rgb |= 0xFF00;
                }
                this.image.setRGB(x, y, rgb);
            }
        }

        @Override
        public void submitBlock(int blockSize) {
            this.position += blockSize;
        }

        @Override
        public void copyExtra(int extraSize) throws IOException {
            long skipped = BSPatch.this.extraStream.skip(extraSize);
            assert (skipped == (long)extraSize);
            BSPatch.this.extraBytesRead = BSPatch.this.extraBytesRead + skipped;
            for (int i = 0; i < extraSize; ++i) {
                int y = (this.position + i) / this.width;
                int x = (this.position + i) % this.width;
                int rgb = this.image.getRGB(x, y);
                this.image.setRGB(x, y, rgb |= 0xFF);
            }
            this.position += extraSize;
        }

        @Override
        public void skipOld(int advanceOld) throws IOException {
        }

        @Override
        public void writeResult() throws IOException {
            if (this.dexPath != null) {
                Segment[] segments;
                for (Segment segment : segments = DexFileReader.parseMapFrom(this.dexPath)) {
                    int y = segment.offset / this.width;
                    for (int x = 0; x < this.width; ++x) {
                        int val = x / 10 % 2 == 0 ? 0 : 0xFFFFFF;
                        this.image.setRGB(x, y, val);
                    }
                    System.out.println(segment);
                }
            }
            ImageIO.write((RenderedImage)this.image, "png", BSPatch.this.output.toFile());
        }
    }

    private class FileExecutor
    extends PatchExecutor {
        private ByteBuffer resultBuffer;
        private byte[] mergeBuffer;

        private FileExecutor() {
            this.mergeBuffer = null;
        }

        @Override
        public void createOutput(int newFileSize) {
            this.resultBuffer = ByteBuffer.allocate(newFileSize);
        }

        @Override
        public void copyDiff(int blockSize) throws IOException {
            assert (this.mergeBuffer == null);
            this.mergeBuffer = new byte[blockSize];
            int read = BSPatch.this.diffStream.read(this.mergeBuffer);
            BSPatch.this.diffBytesRead = BSPatch.this.diffBytesRead + (long)read;
            assert (read == blockSize);
        }

        @Override
        public void copyOld(int blockSize) throws IOException {
            assert (this.mergeBuffer != null);
            assert (this.mergeBuffer.length == blockSize);
            byte[] data = new byte[blockSize];
            BSPatch.this.oldInput.get(data);
            for (int i = 0; i < this.mergeBuffer.length; ++i) {
                this.mergeBuffer[i] = (byte)((this.mergeBuffer[i] & 0xFF) + (data[i] & 0xFF));
            }
        }

        @Override
        public void submitBlock(int blockSize) {
            assert (this.mergeBuffer != null);
            assert (this.mergeBuffer.length == blockSize);
            this.resultBuffer.put(this.mergeBuffer);
            this.mergeBuffer = null;
        }

        @Override
        public void copyExtra(int extraSize) throws IOException {
            byte[] data = new byte[extraSize];
            int read = BSPatch.this.extraStream.read(data);
            assert (read == extraSize);
            BSPatch.this.extraBytesRead = BSPatch.this.extraBytesRead + (long)read;
            this.resultBuffer.put(data);
        }

        @Override
        public void skipOld(int delta) throws IOException {
            BSPatch.this.oldInput.position(BSPatch.this.oldInput.position() + delta);
        }

        @Override
        public void writeResult() throws IOException {
            OutputStream outputStream = Files.newOutputStream(BSPatch.this.output, new OpenOption[0]);
            outputStream.write(this.resultBuffer.array());
            outputStream.close();
        }
    }

    private abstract class PatchExecutor {
        private PatchExecutor() {
        }

        public abstract void createOutput(int var1);

        public abstract void copyDiff(int var1) throws IOException;

        public abstract void copyOld(int var1) throws IOException;

        public abstract void submitBlock(int var1);

        public abstract void copyExtra(int var1) throws IOException;

        public abstract void skipOld(int var1) throws IOException;

        public abstract void writeResult() throws IOException;
    }
}

