/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base4Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.ClassNameMapper;
import java.nio.ShortBuffer;
import java.util.function.BiPredicate;

public abstract class Format4rcc
extends Base4Format {
    public final int AA;
    public final int CCCC;
    public DexMethod BBBB;
    public DexProto HHHH;

    Format4rcc(int high, BytecodeStream stream, DexMethod[] methodMap, DexProto[] protoMap) {
        super(stream);
        this.AA = high;
        this.BBBB = methodMap[Format4rcc.read16BitValue(stream)];
        this.CCCC = Format4rcc.read16BitValue(stream);
        this.HHHH = protoMap[Format4rcc.read16BitValue(stream)];
    }

    Format4rcc(int firstArgumentRegister, int argumentCount, DexMethod method, DexProto proto) {
        assert (0 <= firstArgumentRegister && firstArgumentRegister <= 65535);
        assert (0 <= argumentCount && argumentCount <= 255);
        this.CCCC = firstArgumentRegister;
        this.AA = argumentCount;
        this.BBBB = method;
        this.HHHH = proto;
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        this.writeFirst(this.AA, dest);
        this.write16BitReference(this.BBBB, dest, mapping);
        this.write16BitValue(this.CCCC, dest);
        this.write16BitReference(this.HHHH, dest, mapping);
    }

    @Override
    public final int hashCode() {
        return (this.CCCC << 24 | this.HHHH.hashCode() << 12 | this.BBBB.hashCode() << 4 | this.AA) ^ this.getClass().hashCode();
    }

    @Override
    public final boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format4rcc o = (Format4rcc)other;
        return o.AA == this.AA && o.CCCC == this.CCCC && o.BBBB.equals(this.BBBB) & o.HHHH.equals(this.HHHH);
    }

    @Override
    public String toString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        this.appendRegisterRange(builder);
        builder.append(" ");
        if (naming == null) {
            builder.append(this.BBBB.toSmaliString());
        } else {
            builder.append(naming.originalNameOf(this.BBBB));
        }
        if (naming == null) {
            builder.append(this.HHHH.toSmaliString());
        } else {
            builder.append(naming.originalNameOf(this.HHHH));
        }
        return this.formatString(builder.toString());
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        this.appendRegisterRange(builder);
        builder.append(", ");
        builder.append(this.BBBB.toSmaliString());
        builder.append(", ");
        builder.append(this.HHHH.toSmaliString());
        return this.formatSmaliString(builder.toString());
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.BBBB.collectIndexedItems(indexedItems);
        this.HHHH.collectIndexedItems(indexedItems);
    }

    @Override
    public boolean equals(Instruction other, BiPredicate<IndexedDexItem, IndexedDexItem> equality) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format4rcc o = (Format4rcc)other;
        return o.AA == this.AA && o.CCCC == this.CCCC && equality.test(this.BBBB, o.BBBB) && equality.test(this.HHHH, o.HHHH);
    }

    private void appendRegisterRange(StringBuilder builder) {
        builder.append("{ ");
        builder.append("v").append(this.CCCC);
        if (this.AA != 1) {
            builder.append(" .. v").append(this.CCCC + this.AA - 1);
        }
        builder.append(" }");
    }

    @Override
    public DexMethod getMethod() {
        return this.BBBB;
    }

    @Override
    public DexProto getProto() {
        return this.HHHH;
    }
}

