/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;

public abstract class ClassAndMemberPublicizer {
    private static void publicizeAllMethods(DexEncodedMethod[] methods) {
        for (DexEncodedMethod method : methods) {
            method.accessFlags.promoteNonPrivateToPublic();
        }
    }

    private static void publicizeAllFields(DexEncodedField[] fields) {
        for (DexEncodedField field : fields) {
            field.accessFlags.promoteToPublic();
        }
    }

    public static DexApplication run(DexApplication application) {
        for (DexClass dexClass : application.classes()) {
            dexClass.accessFlags.promoteToPublic();
            ClassAndMemberPublicizer.publicizeAllFields(dexClass.staticFields());
            ClassAndMemberPublicizer.publicizeAllFields(dexClass.instanceFields());
            ClassAndMemberPublicizer.publicizeAllMethods(dexClass.directMethods());
            ClassAndMemberPublicizer.publicizeAllMethods(dexClass.virtualMethods());
        }
        return application;
    }
}

