/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.naming.NamingLens;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class DexItemFactory {
    private final Map<String, DexString> strings = new HashMap<String, DexString>();
    private final Map<DexType, DexType> types = new HashMap<DexType, DexType>();
    private final Map<DexField, DexField> fields = new HashMap<DexField, DexField>();
    private final Map<DexProto, DexProto> protos = new HashMap<DexProto, DexProto>();
    private final Map<DexMethod, DexMethod> methods = new HashMap<DexMethod, DexMethod>();
    private final Map<DexCallSite, DexCallSite> callSites = new HashMap<DexCallSite, DexCallSite>();
    private final Map<DexMethodHandle, DexMethodHandle> methodHandles = new HashMap<DexMethodHandle, DexMethodHandle>();
    private final Int2ObjectMap<DexDebugEvent.AdvanceLine> advanceLines = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<DexDebugEvent.AdvancePC> advancePCs = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<DexDebugEvent.Default> defaults = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<DexDebugEvent.EndLocal> endLocals = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<DexDebugEvent.RestartLocal> restartLocals = new Int2ObjectOpenHashMap();
    private final DexDebugEvent.SetEpilogueBegin setEpilogueBegin = new DexDebugEvent.SetEpilogueBegin();
    private final DexDebugEvent.SetPrologueEnd setPrologueEnd = new DexDebugEvent.SetPrologueEnd();
    private final Map<DexString, DexDebugEvent.SetFile> setFiles = new HashMap<DexString, DexDebugEvent.SetFile>();
    boolean sorted = false;
    public static final DexType catchAllType = new DexType(new DexString("CATCH_ALL"));
    private static final Set<DexItem> internalSentinels = ImmutableSet.of((Object)catchAllType);
    public DexString booleanDescriptor = this.createString("Z");
    public DexString byteDescriptor = this.createString("B");
    public DexString charDescriptor = this.createString("C");
    public DexString doubleDescriptor = this.createString("D");
    public DexString floatDescriptor = this.createString("F");
    public DexString intDescriptor = this.createString("I");
    public DexString longDescriptor = this.createString("J");
    public DexString shortDescriptor = this.createString("S");
    public DexString voidDescriptor = this.createString("V");
    public DexString boxedBooleanDescriptor = this.createString("Ljava/lang/Boolean;");
    public DexString boxedByteDescriptor = this.createString("Ljava/lang/Byte;");
    public DexString boxedCharDescriptor = this.createString("Ljava/lang/Character;");
    public DexString boxedDoubleDescriptor = this.createString("Ljava/lang/Double;");
    public DexString boxedFloatDescriptor = this.createString("Ljava/lang/Float;");
    public DexString boxedIntDescriptor = this.createString("Ljava/lang/Integer;");
    public DexString boxedLongDescriptor = this.createString("Ljava/lang/Long;");
    public DexString boxedShortDescriptor = this.createString("Ljava/lang/Short;");
    public DexString boxedNumberDescriptor = this.createString("Ljava/lang/Number;");
    public DexString unboxBooleanMethodName = this.createString("booleanValue");
    public DexString unboxByteMethodName = this.createString("byteValue");
    public DexString unboxCharMethodName = this.createString("charValue");
    public DexString unboxShortMethodName = this.createString("shortValue");
    public DexString unboxIntMethodName = this.createString("intValue");
    public DexString unboxLongMethodName = this.createString("longValue");
    public DexString unboxFloatMethodName = this.createString("floatValue");
    public DexString unboxDoubleMethodName = this.createString("doubleValue");
    public DexString valueOfMethodName = this.createString("valueOf");
    public DexString getClassMethodName = this.createString("getClass");
    public DexString ordinalMethodName = this.createString("ordinal");
    public final DexString desiredAssertionStatusMethodName = this.createString("desiredAssertionStatus");
    public final DexString assertionsDisabled = this.createString("$assertionsDisabled");
    public DexString stringDescriptor = this.createString("Ljava/lang/String;");
    public DexString objectDescriptor = this.createString("Ljava/lang/Object;");
    public DexString classDescriptor = this.createString("Ljava/lang/Class;");
    public DexString enumDescriptor = this.createString("Ljava/lang/Enum;");
    public DexString annotationDescriptor = this.createString("Ljava/lang/annotation/Annotation;");
    public DexString throwableDescriptor = this.createString("Ljava/lang/Throwable;");
    public DexString objectsDescriptor = this.createString("Ljava/util/Objects;");
    public DexString constructorMethodName = this.createString("<init>");
    public DexString classConstructorMethodName = this.createString("<clinit>");
    public DexString thisName = this.createString("this");
    private DexString charArrayDescriptor = this.createString("[C");
    private DexType charArrayType = this.createType(this.charArrayDescriptor);
    public DexString throwableArrayDescriptor = this.createString("[Ljava/lang/Throwable;");
    public DexType booleanType = this.createType(this.booleanDescriptor);
    public DexType byteType = this.createType(this.byteDescriptor);
    public DexType charType = this.createType(this.charDescriptor);
    public DexType doubleType = this.createType(this.doubleDescriptor);
    public DexType floatType = this.createType(this.floatDescriptor);
    public DexType intType = this.createType(this.intDescriptor);
    public DexType longType = this.createType(this.longDescriptor);
    public DexType shortType = this.createType(this.shortDescriptor);
    public DexType voidType = this.createType(this.voidDescriptor);
    public DexType boxedBooleanType = this.createType(this.boxedBooleanDescriptor);
    public DexType boxedByteType = this.createType(this.boxedByteDescriptor);
    public DexType boxedCharType = this.createType(this.boxedCharDescriptor);
    public DexType boxedDoubleType = this.createType(this.boxedDoubleDescriptor);
    public DexType boxedFloatType = this.createType(this.boxedFloatDescriptor);
    public DexType boxedIntType = this.createType(this.boxedIntDescriptor);
    public DexType boxedLongType = this.createType(this.boxedLongDescriptor);
    public DexType boxedShortType = this.createType(this.boxedShortDescriptor);
    public DexType boxedNumberType = this.createType(this.boxedNumberDescriptor);
    public DexType stringType = this.createType(this.stringDescriptor);
    public DexType objectType = this.createType(this.objectDescriptor);
    public DexType enumType = this.createType(this.enumDescriptor);
    public DexType annotationType = this.createType(this.annotationDescriptor);
    public DexType throwableType = this.createType(this.throwableDescriptor);
    public DexType stringBuilderType = this.createType(this.createString("Ljava/lang/StringBuilder;"));
    public DexType stringBufferType = this.createType(this.createString("Ljava/lang/StringBuffer;"));
    public StringBuildingMethods stringBuilderMethods = new StringBuildingMethods(this.stringBuilderType);
    public StringBuildingMethods stringBufferMethods = new StringBuildingMethods(this.stringBufferType);
    public ObjectsMethods objectsMethods = new ObjectsMethods();
    public ObjectMethods objectMethods = new ObjectMethods();
    public LongMethods longMethods = new LongMethods();
    public ThrowableMethods throwableMethods = new ThrowableMethods();
    public ClassMethods classMethods = new ClassMethods();

    public void clearSubtypeInformation() {
        this.types.values().forEach(DexType::clearSubtypeInformation);
    }

    private static synchronized <T extends DexItem> T canonicalize(Map<T, T> map, T item) {
        assert (item != null);
        assert (!internalSentinels.contains(item));
        DexItem previous = (DexItem)map.putIfAbsent(item, item);
        return (T)(previous == null ? item : previous);
    }

    private synchronized DexString canonicalizeString(String key) {
        assert (key != null);
        return this.strings.computeIfAbsent(key, k -> new DexString((String)k));
    }

    public DexString createString(int size, byte[] content) {
        assert (!this.sorted);
        return this.canonicalizeString(new DexString(size, content).toString());
    }

    public DexString createString(String source) {
        assert (!this.sorted);
        return this.canonicalizeString(source);
    }

    public DexType createType(DexString descriptor) {
        assert (!this.sorted);
        DexType type = new DexType(descriptor);
        return DexItemFactory.canonicalize(this.types, type);
    }

    public DexType createType(String descriptor) {
        return this.createType(this.createString(descriptor));
    }

    public DexField createField(DexType clazz, DexType type, DexString name) {
        assert (!this.sorted);
        DexField field = new DexField(clazz, type, name);
        return DexItemFactory.canonicalize(this.fields, field);
    }

    public DexField createField(DexType clazz, DexType type, String name) {
        return this.createField(clazz, type, this.createString(name));
    }

    public DexProto createProto(DexString shorty, DexType returnType, DexTypeList parameters) {
        assert (!this.sorted);
        DexProto proto = new DexProto(shorty, returnType, parameters);
        return DexItemFactory.canonicalize(this.protos, proto);
    }

    public DexProto createProto(DexString shorty, DexType returnType, DexType[] parameters) {
        assert (!this.sorted);
        return this.createProto(shorty, returnType, parameters.length == 0 ? DexTypeList.empty() : new DexTypeList(parameters));
    }

    public DexProto createProto(DexType returnType, DexType ... parameters) {
        return this.createProto(this.createShorty(returnType, parameters), returnType, parameters);
    }

    public DexString createShorty(DexType returnType, DexType[] argumentTypes) {
        StringBuilder shortyBuilder = new StringBuilder();
        shortyBuilder.append(returnType.toShorty());
        for (DexType argumentType : argumentTypes) {
            shortyBuilder.append(argumentType.toShorty());
        }
        return this.createString(shortyBuilder.toString());
    }

    public DexMethod createMethod(DexType holder, DexProto proto, DexString name) {
        assert (!this.sorted);
        DexMethod method = new DexMethod(holder, proto, name);
        return DexItemFactory.canonicalize(this.methods, method);
    }

    public DexMethod createMethod(DexType holder, DexProto proto, String name) {
        return this.createMethod(holder, proto, this.createString(name));
    }

    public DexMethodHandle createMethodHandle(DexMethodHandle.MethodHandleType type, Descriptor<? extends DexItem, ? extends Descriptor> fieldOrMethod) {
        assert (!this.sorted);
        DexMethodHandle methodHandle = new DexMethodHandle(type, fieldOrMethod);
        return DexItemFactory.canonicalize(this.methodHandles, methodHandle);
    }

    public DexCallSite createCallSite(DexString methodName, DexProto methodProto, DexMethodHandle bootstrapMethod, List<DexValue> bootstrapArgs) {
        assert (!this.sorted);
        DexCallSite callSite = new DexCallSite(methodName, methodProto, bootstrapMethod, bootstrapArgs);
        return DexItemFactory.canonicalize(this.callSites, callSite);
    }

    public DexMethod createMethod(DexString clazzDescriptor, DexString name, DexString returnTypeDescriptor, DexString[] parameterDescriptors) {
        assert (!this.sorted);
        DexType clazz = this.createType(clazzDescriptor);
        DexType returnType = this.createType(returnTypeDescriptor);
        DexType[] parameterTypes = new DexType[parameterDescriptors.length];
        for (int i = 0; i < parameterDescriptors.length; ++i) {
            parameterTypes[i] = this.createType(parameterDescriptors[i]);
        }
        DexProto proto = this.createProto(this.shorty(returnType, parameterTypes), returnType, parameterTypes);
        return this.createMethod(clazz, proto, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.AdvanceLine createAdvanceLine(int delta) {
        Int2ObjectMap<DexDebugEvent.AdvanceLine> int2ObjectMap = this.advanceLines;
        synchronized (int2ObjectMap) {
            DexDebugEvent.AdvanceLine result = (DexDebugEvent.AdvanceLine)this.advanceLines.get(delta);
            if (result == null) {
                result = new DexDebugEvent.AdvanceLine(delta);
                this.advanceLines.put(delta, (Object)result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.AdvancePC createAdvancePC(int delta) {
        Int2ObjectMap<DexDebugEvent.AdvancePC> int2ObjectMap = this.advancePCs;
        synchronized (int2ObjectMap) {
            DexDebugEvent.AdvancePC result = (DexDebugEvent.AdvancePC)this.advancePCs.get(delta);
            if (result == null) {
                result = new DexDebugEvent.AdvancePC(delta);
                this.advancePCs.put(delta, (Object)result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.Default createDefault(int value) {
        Int2ObjectMap<DexDebugEvent.Default> int2ObjectMap = this.defaults;
        synchronized (int2ObjectMap) {
            DexDebugEvent.Default result = (DexDebugEvent.Default)this.defaults.get(value);
            if (result == null) {
                result = new DexDebugEvent.Default(value);
                this.defaults.put(value, (Object)result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.EndLocal createEndLocal(int registerNum) {
        Int2ObjectMap<DexDebugEvent.EndLocal> int2ObjectMap = this.endLocals;
        synchronized (int2ObjectMap) {
            DexDebugEvent.EndLocal result = (DexDebugEvent.EndLocal)this.endLocals.get(registerNum);
            if (result == null) {
                result = new DexDebugEvent.EndLocal(registerNum);
                this.endLocals.put(registerNum, (Object)result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.RestartLocal createRestartLocal(int registerNum) {
        Int2ObjectMap<DexDebugEvent.RestartLocal> int2ObjectMap = this.restartLocals;
        synchronized (int2ObjectMap) {
            DexDebugEvent.RestartLocal result = (DexDebugEvent.RestartLocal)this.restartLocals.get(registerNum);
            if (result == null) {
                result = new DexDebugEvent.RestartLocal(registerNum);
                this.restartLocals.put(registerNum, (Object)result);
            }
            return result;
        }
    }

    public DexDebugEvent.SetEpilogueBegin createSetEpilogueBegin() {
        return this.setEpilogueBegin;
    }

    public DexDebugEvent.SetPrologueEnd createSetPrologueEnd() {
        return this.setPrologueEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.SetFile createSetFile(DexString fileName) {
        Map<DexString, DexDebugEvent.SetFile> map = this.setFiles;
        synchronized (map) {
            DexDebugEvent.SetFile result = this.setFiles.get(fileName);
            if (result == null) {
                result = new DexDebugEvent.SetFile(fileName);
                this.setFiles.put(fileName, result);
            }
            return result;
        }
    }

    public boolean isConstructor(DexMethod method) {
        return method.name == this.constructorMethodName;
    }

    public boolean isClassConstructor(DexMethod method) {
        return method.name == this.classConstructorMethodName;
    }

    private DexString shorty(DexType returnType, DexType[] parameters) {
        StringBuilder builder = new StringBuilder();
        this.addToShorty(builder, returnType);
        for (DexType parameter : parameters) {
            this.addToShorty(builder, parameter);
        }
        return this.createString(builder.toString());
    }

    private void addToShorty(StringBuilder builder, DexType type) {
        char first = type.toDescriptorString().charAt(0);
        builder.append(first == '[' ? (char)'L' : (char)first);
    }

    private static <S extends PresortedComparable<S>> void assignSortedIndices(Collection<S> items, NamingLens namingLens) {
        ArrayList<S> sorted = new ArrayList<S>(items);
        sorted.sort((a, b) -> a.layeredCompareTo(b, namingLens));
        int i = 0;
        for (PresortedComparable value : sorted) {
            value.setSortedIndex(i++);
        }
    }

    public synchronized void sort(NamingLens namingLens) {
        assert (!this.sorted);
        DexItemFactory.assignSortedIndices(this.strings.values(), namingLens);
        DexItemFactory.assignSortedIndices(this.types.values(), namingLens);
        DexItemFactory.assignSortedIndices(this.fields.values(), namingLens);
        DexItemFactory.assignSortedIndices(this.protos.values(), namingLens);
        DexItemFactory.assignSortedIndices(this.methods.values(), namingLens);
        this.sorted = true;
    }

    public synchronized void resetSortedIndices() {
        if (!this.sorted) {
            return;
        }
        this.strings.values().forEach(IndexedDexItem::resetSortedIndex);
        this.types.values().forEach(IndexedDexItem::resetSortedIndex);
        this.fields.values().forEach(IndexedDexItem::resetSortedIndex);
        this.protos.values().forEach(IndexedDexItem::resetSortedIndex);
        this.methods.values().forEach(IndexedDexItem::resetSortedIndex);
        this.sorted = false;
    }

    public synchronized void forAllTypes(Consumer<DexType> f) {
        new ArrayList<DexType>(this.types.values()).forEach(f);
    }

    public class StringBuildingMethods {
        public DexMethod appendBoolean;
        public DexMethod appendChar;
        public DexMethod appendCharArray;
        public DexMethod appendSubCharArray;
        public DexMethod appendCharSequence;
        public DexMethod appendSubCharSequence;
        public DexMethod appendInt;
        public DexMethod appendDouble;
        public DexMethod appendFloat;
        public DexMethod appendLong;
        public DexMethod appendObject;
        public DexMethod appendString;
        public DexMethod appendStringBuffer;
        public DexMethod toString;

        private StringBuildingMethods(DexType receiver) {
            DexType sbufType = DexItemFactory.this.createType(DexItemFactory.this.createString("Ljava/lang/StringBuffer;"));
            DexType charSequenceType = DexItemFactory.this.createType(DexItemFactory.this.createString("Ljava/lang/CharSequence;"));
            DexString append = DexItemFactory.this.createString("append");
            DexString toStringMethodName = DexItemFactory.this.createString("toString");
            this.appendBoolean = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.booleanType), append);
            this.appendChar = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charType), append);
            this.appendCharArray = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charArrayType), append);
            this.appendSubCharArray = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charArrayType, DexItemFactory.this.intType, DexItemFactory.this.intType), append);
            this.appendCharSequence = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, charSequenceType), append);
            this.appendSubCharSequence = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, charSequenceType, DexItemFactory.this.intType, DexItemFactory.this.intType), append);
            this.appendInt = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.intType), append);
            this.appendDouble = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.doubleType), append);
            this.appendFloat = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.floatType), append);
            this.appendLong = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.longType), append);
            this.appendObject = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.objectType), append);
            this.appendString = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.stringType), append);
            this.appendStringBuffer = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, sbufType), append);
            this.toString = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), toStringMethodName);
        }

        public void forEachAppendMethod(Consumer<DexMethod> consumer) {
            consumer.accept(this.appendBoolean);
            consumer.accept(this.appendChar);
            consumer.accept(this.appendCharArray);
            consumer.accept(this.appendSubCharArray);
            consumer.accept(this.appendCharSequence);
            consumer.accept(this.appendSubCharSequence);
            consumer.accept(this.appendInt);
            consumer.accept(this.appendDouble);
            consumer.accept(this.appendFloat);
            consumer.accept(this.appendLong);
            consumer.accept(this.appendObject);
            consumer.accept(this.appendString);
            consumer.accept(this.appendStringBuffer);
            consumer.accept(this.appendBoolean);
        }
    }

    public class ClassMethods {
        public DexMethod desiredAssertionStatus;

        private ClassMethods() {
            this.desiredAssertionStatus = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.desiredAssertionStatusMethodName, DexItemFactory.this.booleanDescriptor, new DexString[0]);
        }
    }

    public class ObjectsMethods {
        public DexMethod requireNonNull;

        private ObjectsMethods() {
            this.requireNonNull = DexItemFactory.this.createMethod(DexItemFactory.this.objectsDescriptor, DexItemFactory.this.createString("requireNonNull"), DexItemFactory.this.objectDescriptor, new DexString[]{DexItemFactory.this.objectDescriptor});
        }
    }

    public class ObjectMethods {
        public DexMethod getClass;

        private ObjectMethods() {
            this.getClass = DexItemFactory.this.createMethod(DexItemFactory.this.objectsDescriptor, DexItemFactory.this.getClassMethodName, DexItemFactory.this.classDescriptor, new DexString[0]);
        }
    }

    public class ThrowableMethods {
        public final DexMethod addSuppressed;
        public final DexMethod getSuppressed;

        private ThrowableMethods() {
            this.addSuppressed = DexItemFactory.this.createMethod(DexItemFactory.this.throwableDescriptor, DexItemFactory.this.createString("addSuppressed"), DexItemFactory.this.voidDescriptor, new DexString[]{DexItemFactory.this.throwableDescriptor});
            this.getSuppressed = DexItemFactory.this.createMethod(DexItemFactory.this.throwableDescriptor, DexItemFactory.this.createString("getSuppressed"), DexItemFactory.this.throwableArrayDescriptor, DexString.EMPTY_ARRAY);
        }
    }

    public class LongMethods {
        public DexMethod compare;

        private LongMethods() {
            this.compare = DexItemFactory.this.createMethod(DexItemFactory.this.boxedLongDescriptor, DexItemFactory.this.createString("compare"), DexItemFactory.this.intDescriptor, new DexString[]{DexItemFactory.this.longDescriptor, DexItemFactory.this.longDescriptor});
        }
    }
}

