/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.ir.conversion.CallGraph;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.Inliner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OptimizationFeedbackDelayed
implements OptimizationFeedback {
    private Reference2IntMap<DexEncodedMethod> returnsArgument = new Reference2IntOpenHashMap();
    private Reference2LongMap<DexEncodedMethod> returnsConstant = new Reference2LongOpenHashMap();
    private Set<DexEncodedMethod> neverReturnsNull = Sets.newIdentityHashSet();
    private Map<DexEncodedMethod, Inliner.Constraint> inliningConstraints = Maps.newIdentityHashMap();

    @Override
    public synchronized void methodReturnsArgument(DexEncodedMethod method, int argument) {
        if (method.getOptimizationInfo().returnsArgument()) {
            assert (method.getOptimizationInfo().getReturnedArgument() == argument);
            return;
        }
        assert (!this.returnsArgument.containsKey((Object)method));
        this.returnsArgument.put((Object)method, argument);
    }

    @Override
    public synchronized void methodReturnsConstant(DexEncodedMethod method, long value) {
        if (method.getOptimizationInfo().returnsConstant()) {
            assert (method.getOptimizationInfo().getReturnedConstant() == value);
            return;
        }
        assert (!this.returnsConstant.containsKey((Object)method));
        this.returnsConstant.put((Object)method, value);
    }

    @Override
    public synchronized void methodNeverReturnsNull(DexEncodedMethod method) {
        if (method.getOptimizationInfo().neverReturnsNull()) {
            return;
        }
        assert (!this.neverReturnsNull.contains(method));
        this.neverReturnsNull.add(method);
    }

    @Override
    public void markProcessed(DexEncodedMethod method, Inliner.Constraint state) {
        if (state == Inliner.Constraint.NEVER) {
            assert (method.cannotInline());
            method.markProcessed(state);
        } else {
            this.inliningConstraints.put(method, state);
        }
    }

    private <T> boolean setsOverlap(Set<T> set1, Set<T> set2) {
        for (T element : set1) {
            if (!set2.contains(element)) continue;
            return true;
        }
        return false;
    }

    public List<DexEncodedMethod> applyAndClear(List<DexEncodedMethod> processed, CallGraph.Leaves leaves) {
        this.returnsArgument.forEach(DexEncodedMethod::markReturnsArgument);
        this.returnsConstant.forEach(DexEncodedMethod::markReturnsConstant);
        this.neverReturnsNull.forEach(DexEncodedMethod::markNeverReturnsNull);
        Set all = Sets.newIdentityHashSet();
        all.addAll(this.returnsArgument.keySet());
        all.addAll(this.returnsConstant.keySet());
        all.addAll(this.neverReturnsNull);
        this.inliningConstraints.forEach((method, constraint) -> {
            boolean changed = method.markProcessed((Inliner.Constraint)((Object)constraint));
            if (changed) {
                all.add(method);
            }
        });
        ArrayList<DexEncodedMethod> result = new ArrayList<DexEncodedMethod>();
        for (DexEncodedMethod method2 : processed) {
            Set<DexEncodedMethod> calls = leaves.getCycleBreakingCalls().get(method2);
            if (!this.setsOverlap(calls, all)) continue;
            result.add(method2);
        }
        this.returnsArgument.clear();
        this.returnsConstant.clear();
        this.neverReturnsNull.clear();
        this.inliningConstraints.clear();
        return result;
    }
}

