/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.SwitchPayload;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SwitchPayloadResolver {
    private final Map<Integer, SwitchPayload> unresolvedPayload = new HashMap<Integer, SwitchPayload>();
    private final Map<Integer, PayloadData> payloadToData = new HashMap<Integer, PayloadData>();

    public void addPayloadUser(Instruction dex) {
        int offset = dex.getOffset();
        int payloadOffset = offset + dex.getPayloadOffset();
        this.payloadToData.put(payloadOffset, new PayloadData(offset, offset + dex.getSize()));
        if (this.unresolvedPayload.containsKey(payloadOffset)) {
            SwitchPayload payload = this.unresolvedPayload.remove(payloadOffset);
            this.resolve(payload);
        }
    }

    public void resolve(SwitchPayload payload) {
        int payloadOffset = payload.getOffset();
        PayloadData data = this.payloadToData.get(payloadOffset);
        if (data == null) {
            this.unresolvedPayload.put(payloadOffset, payload);
            return;
        }
        int[] targets = payload.switchTargetOffsets();
        int[] absoluteTargets = new int[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            absoluteTargets[i] = data.userOffset + targets[i];
        }
        data.absoluteTargets = absoluteTargets;
        data.keys = payload.keys();
        data.size = payload.numberOfKeys();
    }

    public int[] absoluteTargets(Instruction dex) {
        assert (dex.isSwitch());
        return this.absoluteTargets(dex.getOffset() + dex.getPayloadOffset());
    }

    public int[] absoluteTargets(int payloadOffset) {
        return this.payloadToData.get((Object)Integer.valueOf((int)payloadOffset)).absoluteTargets;
    }

    public int[] getKeys(int payloadOffset) {
        return this.payloadToData.get((Object)Integer.valueOf((int)payloadOffset)).keys;
    }

    public int getSize(int payloadOffset) {
        return this.payloadToData.get((Object)Integer.valueOf((int)payloadOffset)).size;
    }

    public Collection<PayloadData> payloadDataSet() {
        return this.payloadToData.values();
    }

    public void clear() {
        this.payloadToData.clear();
    }

    public static class PayloadData {
        public static final int NO_SIZE = -1;
        public int userOffset;
        public int fallthroughOffset;
        public int[] absoluteTargets = null;
        public int[] keys = null;
        public int size = -1;

        public PayloadData(int userOffset, int fallthroughOffset) {
            this.userOffset = userOffset;
            this.fallthroughOffset = fallthroughOffset;
        }
    }
}

