/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.StringUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassNameMinifier {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final RootSetBuilder.RootSet rootSet;
    private final String packagePrefix;
    private final Set<DexString> usedTypeNames = Sets.newIdentityHashSet();
    private final Map<DexType, DexString> renaming = Maps.newIdentityHashMap();
    private final Map<String, NamingState> states = new HashMap<String, NamingState>();
    final List<String> dictionary;

    public ClassNameMinifier(Enqueuer.AppInfoWithLiveness appInfo, RootSetBuilder.RootSet rootSet, String packagePrefix, List<String> dictionary) {
        this.appInfo = appInfo;
        this.rootSet = rootSet;
        this.packagePrefix = packagePrefix;
        this.dictionary = dictionary;
    }

    public Map<DexType, DexString> computeRenaming() {
        for (DexClass dexClass : this.appInfo.classes()) {
            if (!this.rootSet.noObfuscation.contains(dexClass)) continue;
            assert (!this.renaming.containsKey(dexClass.type));
            this.renaming.put(dexClass.type, dexClass.type.descriptor);
            this.usedTypeNames.add(dexClass.type.descriptor);
        }
        for (DexClass dexClass : this.appInfo.classes()) {
            if (this.renaming.containsKey(dexClass.type)) continue;
            String packageName = this.getPackageNameFor(dexClass);
            NamingState state = this.getStateFor(packageName);
            this.renaming.put(dexClass.type, state.nextTypeName());
        }
        this.appInfo.dexItemFactory.forAllTypes(this::renameArrayTypeIfNeeded);
        return Collections.unmodifiableMap(this.renaming);
    }

    private String getPackageNameFor(DexClass clazz) {
        if (this.packagePrefix == null || this.rootSet.keepPackageName.contains(clazz)) {
            return clazz.type.getPackageDescriptor();
        }
        return this.packagePrefix;
    }

    private NamingState getStateFor(String packageName) {
        return this.states.computeIfAbsent(packageName, x$0 -> new NamingState((String)x$0));
    }

    private void renameArrayTypeIfNeeded(DexType type) {
        DexType base;
        DexString value;
        if (type.isArrayType() && (value = this.renaming.get(base = type.toBaseType(this.appInfo.dexItemFactory))) != null) {
            int dimensions = type.descriptor.numberOfLeadingSquareBrackets();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < dimensions; ++i) {
                builder.append('[');
            }
            builder.append(value.toString());
            DexString descriptor = this.appInfo.dexItemFactory.createString(builder.toString());
            this.renaming.put(type, descriptor);
        }
    }

    private class NamingState {
        private final char[] packagePrefix;
        private int typeCounter = 1;
        private Iterator<String> dictionaryIterator;

        NamingState(String packageName) {
            this.packagePrefix = ("L" + packageName + (packageName.isEmpty() ? "" : "/")).toCharArray();
            this.dictionaryIterator = ClassNameMinifier.this.dictionary.iterator();
        }

        public char[] getPackagePrefix() {
            return this.packagePrefix;
        }

        protected String nextSuggestedName() {
            StringBuilder nextName = new StringBuilder();
            if (this.dictionaryIterator.hasNext()) {
                nextName.append(this.getPackagePrefix()).append(this.dictionaryIterator.next()).append(';');
                return nextName.toString();
            }
            return StringUtils.numberToIdentifier(this.packagePrefix, this.typeCounter++, true);
        }

        private DexString nextTypeName() {
            DexString candidate;
            do {
                candidate = ((ClassNameMinifier)ClassNameMinifier.this).appInfo.dexItemFactory.createString(this.nextSuggestedName());
            } while (ClassNameMinifier.this.usedTypeNames.contains(candidate));
            return candidate;
        }
    }
}

