/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.NamingState;
import com.android.tools.r8.shaking.RootSetBuilder;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class FieldNameMinifier {
    private final AppInfoWithSubtyping appInfo;
    private final RootSetBuilder.RootSet rootSet;
    private final Map<DexField, DexString> renaming = new IdentityHashMap<DexField, DexString>();
    private final List<String> dictionary;
    private final Map<DexType, NamingState<DexType>> states = new IdentityHashMap<DexType, NamingState<DexType>>();

    public FieldNameMinifier(AppInfoWithSubtyping appInfo, RootSetBuilder.RootSet rootSet, List<String> dictionary) {
        this.appInfo = appInfo;
        this.rootSet = rootSet;
        this.dictionary = dictionary;
    }

    Map<DexField, DexString> computeRenaming() {
        NamingState<DexType> rootState = NamingState.createRoot(this.appInfo.dexItemFactory, this.dictionary);
        this.reserveNamesInSubtypes(this.appInfo.dexItemFactory.objectType, rootState);
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, iface -> this.reserveNamesInSubtypes((DexType)iface, rootState));
        this.renameFieldsInSubtypes(this.appInfo.dexItemFactory.objectType);
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, this::renameFieldsInSubtypes);
        return this.renaming;
    }

    private void reserveNamesInSubtypes(DexType type, NamingState<DexType> state) {
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder == null) {
            return;
        }
        NamingState newState = this.states.computeIfAbsent(type, t -> state.createChild());
        this.reserveFieldNames(newState, holder.instanceFields(), holder.isLibraryClass());
        this.reserveFieldNames(newState, holder.staticFields(), holder.isLibraryClass());
        type.forAllExtendsSubtypes(subtype -> this.reserveNamesInSubtypes((DexType)subtype, newState));
    }

    private void reserveFieldNames(NamingState<DexType> state, DexEncodedField[] fields, boolean isLibrary) {
        for (DexEncodedField encodedField : fields) {
            if (!isLibrary && !this.rootSet.noObfuscation.contains(encodedField)) continue;
            DexField field = encodedField.field;
            state.reserveName(field.name, field.type);
        }
    }

    private void renameFieldsInSubtypes(DexType type) {
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null) {
            return;
        }
        NamingState<DexType> state = this.states.get(clazz.type);
        assert (state != null);
        this.renameFields(clazz.instanceFields(), state);
        this.renameFields(clazz.staticFields(), state);
        type.forAllExtendsSubtypes(this::renameFieldsInSubtypes);
    }

    private void renameFields(DexEncodedField[] fields, NamingState<DexType> state) {
        for (DexEncodedField encodedField : fields) {
            DexField field = encodedField.field;
            if (state.isReserved(field.name, field.type)) continue;
            this.renaming.put(field, state.assignNewNameFor(field.name, field.type, false));
        }
    }
}

