/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.shaking.RootSetBuilder;
import java.util.Arrays;
import java.util.Set;

public class DiscardedChecker {
    private final Set<DexItem> checkDiscarded;
    private final DexApplication application;
    private boolean fail = false;

    public DiscardedChecker(RootSetBuilder.RootSet rootSet, DexApplication application) {
        this.checkDiscarded = rootSet.checkDiscarded;
        this.application = application;
    }

    public void run() {
        for (DexProgramClass clazz : this.application.classes()) {
            if (this.checkDiscarded.contains(clazz)) {
                this.report(clazz);
            }
            this.processSubItems(clazz.directMethods());
            this.processSubItems(clazz.virtualMethods());
            this.processSubItems(clazz.staticFields());
            this.processSubItems(clazz.instanceFields());
        }
        if (this.fail) {
            throw new CompilationError("Discard checks failed.");
        }
    }

    private void processSubItems(DexItem[] items) {
        Arrays.stream(items).filter(this.checkDiscarded::contains).forEach(this::report);
    }

    private void report(DexItem item) {
        System.err.println("Item " + item.toSourceString() + " was not discarded.");
        this.fail = true;
    }
}

