/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.Resource;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OutputMode;
import com.android.tools.r8.utils.PreloadedClassFileProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class AndroidApp {
    public static final String DEFAULT_PROGUARD_MAP_FILE = "proguard.map";
    private final ImmutableList<Resource> programResources;
    private final ImmutableList<Resource> classpathResources;
    private final ImmutableList<Resource> libraryResources;
    private final ImmutableList<ClassFileResourceProvider> classpathResourceProviders;
    private final ImmutableList<ClassFileResourceProvider> libraryResourceProviders;
    private final Resource proguardMap;
    private final Resource proguardSeeds;
    private final Resource packageDistribution;
    private final Resource mainDexList;

    private AndroidApp(ImmutableList<Resource> programResources, ImmutableList<Resource> classpathResources, ImmutableList<Resource> libraryResources, ImmutableList<ClassFileResourceProvider> classpathResourceProviders, ImmutableList<ClassFileResourceProvider> libraryResourceProviders, Resource proguardMap, Resource proguardSeeds, Resource packageDistribution, Resource mainDexList) {
        this.programResources = programResources;
        this.classpathResources = classpathResources;
        this.libraryResources = libraryResources;
        this.classpathResourceProviders = classpathResourceProviders;
        this.libraryResourceProviders = libraryResourceProviders;
        this.proguardMap = proguardMap;
        this.proguardSeeds = proguardSeeds;
        this.packageDistribution = packageDistribution;
        this.mainDexList = mainDexList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static AndroidApp fromProgramFiles(Path ... files) throws IOException {
        return AndroidApp.fromProgramFiles(Arrays.asList(files));
    }

    public static AndroidApp fromProgramFiles(List<Path> files) throws IOException {
        return AndroidApp.builder().addProgramFiles(files, false).build();
    }

    public static AndroidApp fromProgramDirectory(Path directory) throws IOException {
        return AndroidApp.builder().addProgramDirectory(directory).build();
    }

    public static AndroidApp fromDexProgramData(byte[] ... data) {
        return AndroidApp.fromDexProgramData(Arrays.asList(data));
    }

    public static AndroidApp fromDexProgramData(List<byte[]> data) {
        return AndroidApp.builder().addDexProgramData(data).build();
    }

    public static AndroidApp fromClassProgramData(byte[] ... data) {
        return AndroidApp.fromClassProgramData(Arrays.asList(data));
    }

    public static AndroidApp fromClassProgramData(List<byte[]> data) {
        return AndroidApp.builder().addClassProgramData(data).build();
    }

    public List<Resource> getDexProgramResources() {
        return this.filter((List<Resource>)this.programResources, Resource.Kind.DEX);
    }

    public List<Resource> getClassProgramResources() {
        return this.filter((List<Resource>)this.programResources, Resource.Kind.CLASSFILE);
    }

    public List<Resource> getDexClasspathResources() {
        return this.filter((List<Resource>)this.classpathResources, Resource.Kind.DEX);
    }

    public List<Resource> getClassClasspathResources() {
        return this.filter((List<Resource>)this.classpathResources, Resource.Kind.CLASSFILE);
    }

    public List<Resource> getDexLibraryResources() {
        return this.filter((List<Resource>)this.libraryResources, Resource.Kind.DEX);
    }

    public List<Resource> getClassLibraryResources() {
        return this.filter((List<Resource>)this.libraryResources, Resource.Kind.CLASSFILE);
    }

    public List<ClassFileResourceProvider> getClasspathResourceProviders() {
        return this.classpathResourceProviders;
    }

    public List<ClassFileResourceProvider> getLibraryResourceProviders() {
        return this.libraryResourceProviders;
    }

    private List<Resource> filter(List<Resource> resources, Resource.Kind kind) {
        ArrayList<Resource> out = new ArrayList<Resource>(resources.size());
        for (Resource resource : resources) {
            if (kind != resource.kind) continue;
            out.add(resource);
        }
        return out;
    }

    public boolean hasProguardMap() {
        return this.proguardMap != null;
    }

    public InputStream getProguardMap(Closer closer) throws IOException {
        return this.proguardMap == null ? null : this.proguardMap.getStream(closer);
    }

    public boolean hasProguardSeeds() {
        return this.proguardSeeds != null;
    }

    public InputStream getProguardSeeds(Closer closer) throws IOException {
        return this.proguardSeeds == null ? null : this.proguardSeeds.getStream(closer);
    }

    public boolean hasPackageDistribution() {
        return this.packageDistribution != null;
    }

    public InputStream getPackageDistribution(Closer closer) throws IOException {
        return this.packageDistribution == null ? null : this.packageDistribution.getStream(closer);
    }

    public boolean hasMainDexList() {
        return this.mainDexList != null;
    }

    public InputStream getMainDexList(Closer closer) throws IOException {
        return this.mainDexList == null ? null : this.mainDexList.getStream(closer);
    }

    public void write(Path output, OutputMode outputMode) throws IOException {
        if (FileUtils.isArchive(output)) {
            this.writeToZip(output, outputMode);
        } else {
            this.writeToDirectory(output, outputMode);
        }
    }

    public void writeToDirectory(Path directory, OutputMode outputMode) throws IOException {
        if (outputMode == OutputMode.Indexed) {
            for (Path path : Files.list(directory).collect(Collectors.toList())) {
                if (!AndroidApp.isClassesDexFile(path)) continue;
                Files.delete(path);
            }
        }
        CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        try (Closer closer = Closer.create();){
            List<Resource> dexProgramSources = this.getDexProgramResources();
            for (int i = 0; i < dexProgramSources.size(); ++i) {
                Path filePath = directory.resolve(outputMode.getOutputPath(dexProgramSources.get(i), i));
                if (!Files.exists(filePath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                }
                Files.copy(dexProgramSources.get(i).getStream(closer), filePath, options);
            }
        }
    }

    private static boolean isClassesDexFile(Path file) {
        String name = file.getFileName().toString().toLowerCase();
        if (!name.startsWith("classes") || !name.endsWith(".dex")) {
            return false;
        }
        String numeral = name.substring("classes".length(), name.length() - ".dex".length());
        if (numeral.isEmpty()) {
            return true;
        }
        char c0 = numeral.charAt(0);
        if (numeral.length() == 1) {
            return '2' <= c0 && c0 <= '9';
        }
        if (c0 < '1' || '9' < c0) {
            return false;
        }
        for (int i = 1; i < numeral.length(); ++i) {
            char c = numeral.charAt(i);
            if (c >= '0' && '9' >= c) continue;
            return false;
        }
        return true;
    }

    public List<byte[]> writeToMemory() throws IOException {
        ArrayList<byte[]> dex = new ArrayList<byte[]>();
        try (Closer closer = Closer.create();){
            List<Resource> dexProgramSources = this.getDexProgramResources();
            for (int i = 0; i < dexProgramSources.size(); ++i) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteStreams.copy((InputStream)dexProgramSources.get(i).getStream(closer), (OutputStream)out);
                dex.add(out.toByteArray());
            }
        }
        return dex;
    }

    public void writeToZip(Path archive, OutputMode outputMode) throws IOException {
        OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        try (Closer closer = Closer.create();
             ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(archive, options));){
            List<Resource> dexProgramSources = this.getDexProgramResources();
            for (int i = 0; i < dexProgramSources.size(); ++i) {
                ZipEntry zipEntry = new ZipEntry(outputMode.getOutputPath(dexProgramSources.get(i), i));
                byte[] bytes = ByteStreams.toByteArray((InputStream)dexProgramSources.get(i).getStream(closer));
                zipEntry.setSize(bytes.length);
                out.putNextEntry(zipEntry);
                out.write(bytes);
                out.closeEntry();
            }
        }
    }

    public void writeProguardMap(Closer closer, OutputStream out) throws IOException {
        InputStream input = this.getProguardMap(closer);
        assert (input != null);
        out.write(ByteStreams.toByteArray((InputStream)input));
    }

    public void writeProguardSeeds(Closer closer, OutputStream out) throws IOException {
        InputStream input = this.getProguardSeeds(closer);
        assert (input != null);
        out.write(ByteStreams.toByteArray((InputStream)input));
    }

    public void writeMainDexList(Closer closer, OutputStream out) throws IOException {
        InputStream input = this.getMainDexList(closer);
        assert (input != null);
        out.write(ByteStreams.toByteArray((InputStream)input));
    }

    public static class Builder {
        private final List<Resource> programResources = new ArrayList<Resource>();
        private final List<Resource> classpathResources = new ArrayList<Resource>();
        private final List<Resource> libraryResources = new ArrayList<Resource>();
        private final List<ClassFileResourceProvider> classpathResourceProviders = new ArrayList<ClassFileResourceProvider>();
        private final List<ClassFileResourceProvider> libraryResourceProviders = new ArrayList<ClassFileResourceProvider>();
        private Resource proguardMap;
        private Resource proguardSeeds;
        private Resource packageDistribution;
        private Resource mainDexList;

        private Builder() {
        }

        private Builder(AndroidApp app) {
            this.programResources.addAll((Collection<Resource>)app.programResources);
            this.classpathResources.addAll((Collection<Resource>)app.classpathResources);
            this.libraryResources.addAll((Collection<Resource>)app.libraryResources);
            this.classpathResourceProviders.addAll((Collection<ClassFileResourceProvider>)app.classpathResourceProviders);
            this.libraryResourceProviders.addAll((Collection<ClassFileResourceProvider>)app.libraryResourceProviders);
            this.proguardMap = app.proguardMap;
            this.proguardSeeds = app.proguardSeeds;
            this.packageDistribution = app.packageDistribution;
            this.mainDexList = app.mainDexList;
        }

        public Builder addProgramDirectory(Path directory) throws IOException {
            File[] resources;
            for (File source : resources = directory.toFile().listFiles(file -> FileUtils.isDexFile(file.toPath()))) {
                this.addFile(source.toPath(), ClassKind.PROGRAM, false);
            }
            File mapFile = new File(directory.toFile(), AndroidApp.DEFAULT_PROGUARD_MAP_FILE);
            if (mapFile.exists()) {
                this.setProguardMapFile(mapFile.toPath());
            }
            return this;
        }

        public Builder addProgramFiles(Path ... files) throws IOException {
            return this.addProgramFiles(Arrays.asList(files), false);
        }

        public Builder addProgramFiles(Collection<Path> files, boolean skipDex) throws IOException {
            for (Path file : files) {
                this.addFile(file, ClassKind.PROGRAM, skipDex);
            }
            return this;
        }

        public Builder addClasspathFiles(Path ... files) throws IOException {
            return this.addClasspathFiles(Arrays.asList(files));
        }

        public Builder addClasspathFiles(Collection<Path> files) throws IOException {
            for (Path file : files) {
                this.addFile(file, ClassKind.CLASSPATH, false);
            }
            return this;
        }

        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider) {
            this.classpathResourceProviders.add(provider);
            return this;
        }

        public Builder addLibraryFiles(Path ... files) throws IOException {
            return this.addLibraryFiles(Arrays.asList(files));
        }

        public Builder addLibraryFiles(Collection<Path> files) throws IOException {
            for (Path file : files) {
                this.addFile(file, ClassKind.LIBRARY, false);
            }
            return this;
        }

        public Builder addLibraryResourceProvider(ClassFileResourceProvider provider) {
            this.libraryResourceProviders.add(provider);
            return this;
        }

        public Builder addDexProgramData(byte[] data, Set<String> classDescriptors) {
            this.resources(ClassKind.PROGRAM).add(Resource.fromBytes(Resource.Kind.DEX, data, classDescriptors));
            return this;
        }

        public Builder addDexProgramData(byte[] ... data) {
            return this.addDexProgramData(Arrays.asList(data));
        }

        public Builder addDexProgramData(Collection<byte[]> data) {
            for (byte[] datum : data) {
                this.resources(ClassKind.PROGRAM).add(Resource.fromBytes(Resource.Kind.DEX, datum));
            }
            return this;
        }

        public Builder addClassProgramData(byte[] ... data) {
            return this.addClassProgramData(Arrays.asList(data));
        }

        public Builder addClassProgramData(Collection<byte[]> data) {
            for (byte[] datum : data) {
                this.resources(ClassKind.PROGRAM).add(Resource.fromBytes(Resource.Kind.CLASSFILE, datum));
            }
            return this;
        }

        public Builder setProguardMapFile(Path file) {
            this.proguardMap = file == null ? null : Resource.fromFile(null, file);
            return this;
        }

        public Builder setProguardMapData(String content) {
            return this.setProguardMapData(content == null ? null : content.getBytes(StandardCharsets.UTF_8));
        }

        public Builder setProguardMapData(byte[] content) {
            this.proguardMap = content == null ? null : Resource.fromBytes(null, content);
            return this;
        }

        public Builder setProguardSeedsData(byte[] content) {
            this.proguardSeeds = content == null ? null : Resource.fromBytes(null, content);
            return this;
        }

        public Builder setPackageDistributionFile(Path file) {
            this.packageDistribution = file == null ? null : Resource.fromFile(null, file);
            return this;
        }

        public Builder setMainDexListFile(Path file) {
            this.mainDexList = file == null ? null : Resource.fromFile(null, file);
            return this;
        }

        public Builder setMainDexListData(byte[] content) {
            this.mainDexList = content == null ? null : Resource.fromBytes(null, content);
            return this;
        }

        public AndroidApp build() {
            return new AndroidApp(ImmutableList.copyOf(this.programResources), ImmutableList.copyOf(this.classpathResources), ImmutableList.copyOf(this.libraryResources), ImmutableList.copyOf(this.classpathResourceProviders), ImmutableList.copyOf(this.libraryResourceProviders), this.proguardMap, this.proguardSeeds, this.packageDistribution, this.mainDexList);
        }

        private List<Resource> resources(ClassKind classKind) {
            switch (classKind) {
                case PROGRAM: {
                    return this.programResources;
                }
                case CLASSPATH: {
                    return this.classpathResources;
                }
                case LIBRARY: {
                    return this.libraryResources;
                }
            }
            throw new Unreachable();
        }

        private void addFile(Path file, ClassKind classKind, boolean skipDex) throws IOException {
            if (!Files.exists(file, new LinkOption[0])) {
                throw new FileNotFoundException("Non-existent input file: " + file);
            }
            if (FileUtils.isDexFile(file) && !skipDex) {
                this.resources(classKind).add(Resource.fromFile(Resource.Kind.DEX, file));
            } else if (FileUtils.isClassFile(file)) {
                this.resources(classKind).add(Resource.fromFile(Resource.Kind.CLASSFILE, file));
            } else if (FileUtils.isArchive(file)) {
                this.addArchive(file, classKind, skipDex);
            } else {
                throw new CompilationError("Unsupported source file type for file: " + file);
            }
        }

        private void addArchive(Path archive, ClassKind classKind, boolean skipDex) throws IOException {
            assert (FileUtils.isArchive(archive));
            boolean containsDexData = false;
            boolean containsClassData = false;
            try (ZipInputStream stream = new ZipInputStream(new FileInputStream(archive.toFile()));){
                ZipEntry entry;
                while ((entry = stream.getNextEntry()) != null) {
                    Path name = Paths.get(entry.getName(), new String[0]);
                    if (FileUtils.isDexFile(name) && !skipDex) {
                        containsDexData = true;
                        this.resources(classKind).add(Resource.fromBytes(Resource.Kind.DEX, ByteStreams.toByteArray((InputStream)stream)));
                        continue;
                    }
                    if (!FileUtils.isClassFile(name)) continue;
                    containsClassData = true;
                    String descriptor = PreloadedClassFileProvider.guessTypeDescriptor(name);
                    this.resources(classKind).add(Resource.fromBytes(Resource.Kind.CLASSFILE, ByteStreams.toByteArray((InputStream)stream), Collections.singleton(descriptor)));
                }
            }
            catch (ZipException e) {
                throw new CompilationError("Zip error while reading '" + archive + "': " + e.getMessage(), e);
            }
            if (containsDexData && containsClassData) {
                throw new CompilationError("Cannot create android app from an archive '" + archive + "' containing both DEX and Java-bytecode content");
            }
        }
    }
}

