/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.ClassProvider;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public abstract class ClassMap<T extends DexClass> {
    private final Map<DexType, Value<T>> classes;
    private final ClassProvider<T> classProvider;

    ClassMap(Map<DexType, Value<T>> classes, ClassProvider<T> classProvider) {
        this.classes = classes == null ? new IdentityHashMap() : classes;
        this.classProvider = classProvider;
        assert (this.classProvider == null || this.classProvider.getClassKind() == this.getClassKind());
    }

    abstract T resolveClassConflict(T var1, T var2);

    abstract ClassKind getClassKind();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<DexType, Value<T>> map = this.classes;
        synchronized (map) {
            return this.classes.size() + " loaded, provider: " + (this.classProvider == null ? "none" : this.classProvider.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(DexType type) {
        Value<T> value = this.getOrCreateValue(type);
        if (value == null) {
            return null;
        }
        if (!value.ready) {
            Value<T> value2 = value;
            synchronized (value2) {
                if (!value.ready) {
                    assert (this.classProvider != null) : "getOrCreateValue() created Value for missing type when there is no classProvider.";
                    this.classProvider.collectClass(type, clazz -> {
                        assert (clazz != null);
                        assert (this.getClassKind().isOfKind((DexClass)clazz));
                        assert (!value.ready);
                        if (clazz.type != type) {
                            throw new CompilationError("Class content provided for type descriptor " + type.toSourceString() + " actually defines class " + clazz.type.toSourceString());
                        }
                        if (value.clazz == null) {
                            value.clazz = clazz;
                        } else {
                            DexClass oldClass = (DexClass)value.clazz;
                            value.clazz = null;
                            value.clazz = this.resolveClassConflict(oldClass, clazz);
                        }
                    });
                    value.ready = true;
                }
            }
        }
        assert (value.ready);
        return (T)((DexClass)value.clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value<T> getOrCreateValue(DexType type) {
        Map<DexType, Value<T>> map = this.classes;
        synchronized (map) {
            Value<T> value = this.classes.get(type);
            if (value == null && this.classProvider != null) {
                value = new Value();
                this.classes.put(type, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> collectLoadedClasses() {
        ArrayList loadedClasses = new ArrayList();
        Map<DexType, Value<T>> map = this.classes;
        synchronized (map) {
            for (Value<T> value : this.classes.values()) {
                if (!value.ready || value.clazz == null) continue;
                loadedClasses.add(value.clazz);
            }
        }
        return loadedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLoad(Predicate<DexType> load) {
        if (this.classProvider != null) {
            Set loaded = Sets.newIdentityHashSet();
            Map<DexType, Value<T>> map = this.classes;
            synchronized (map) {
                loaded.addAll(this.classes.keySet());
            }
            Collection<DexType> types = this.classProvider.collectTypes();
            for (DexType type : types) {
                if (!load.test(type) || loaded.contains(type)) continue;
                this.get(type);
            }
        }
    }

    static final class Value<T> {
        volatile boolean ready;
        T clazz;

        Value() {
            this.ready = false;
            this.clazz = null;
        }

        Value(T clazz) {
            this.clazz = clazz;
            this.ready = true;
        }
    }
}

