/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.Resource;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.utils.ClassMap;
import java.util.IdentityHashMap;
import java.util.List;

public class ProgramClassCollection
extends ClassMap<DexProgramClass> {
    public static ProgramClassCollection create(List<DexProgramClass> classes) {
        IdentityHashMap<DexType, ClassMap.Value<DexProgramClass>> map = new IdentityHashMap<DexType, ClassMap.Value<DexProgramClass>>();
        for (DexProgramClass clazz : classes) {
            ClassMap.Value<DexProgramClass> value = map.get(clazz.type);
            if (value == null) {
                value = new ClassMap.Value<DexProgramClass>(clazz);
                map.put(clazz.type, value);
                continue;
            }
            value.clazz = ProgramClassCollection.resolveClassConflictImpl((DexProgramClass)value.clazz, clazz);
        }
        return new ProgramClassCollection(map);
    }

    private ProgramClassCollection(IdentityHashMap<DexType, ClassMap.Value<DexProgramClass>> classes) {
        super(classes, null);
    }

    @Override
    public String toString() {
        return "program classes: " + super.toString();
    }

    @Override
    DexProgramClass resolveClassConflict(DexProgramClass a, DexProgramClass b) {
        return ProgramClassCollection.resolveClassConflictImpl(a, b);
    }

    @Override
    ClassKind getClassKind() {
        return ClassKind.PROGRAM;
    }

    private static DexProgramClass resolveClassConflictImpl(DexProgramClass a, DexProgramClass b) {
        if (a.getOrigin() == Resource.Kind.DEX && b.getOrigin() == Resource.Kind.DEX && a.accessFlags.isSynthetic() && b.accessFlags.isSynthetic() && LambdaRewriter.hasLambdaClassPrefix(a.type) && LambdaRewriter.hasLambdaClassPrefix(b.type)) {
            return a;
        }
        throw new CompilationError("Program type already present: " + a.type.toSourceString());
    }
}

