/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.D8;
import com.android.tools.r8.compatdx.CompatDx;
import com.google.common.collect.ImmutableList;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;

public final class D8Logger {
    private static final int STATUS_ERROR = 1;
    private static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: java -jar d8logger.jar <compiler-options>", (Object)" where <compiler-options> will be", (Object)"", (Object)" 1. forwarded to the 'd8' or 'compatdx' tool (depending on the presence of the '--dex'", (Object)"    option), and also", (Object)" 2. appended to the file in the environment variable 'D8LOGGER_OUTPUT'", (Object)"", (Object)" The options will be appended as a new line with TAB characters between the arguments."));

    public static void main(String[] args) throws IOException {
        String output;
        if (args.length == 0) {
            System.err.println(USAGE_MESSAGE);
            System.exit(1);
        }
        if ((output = System.getenv("D8LOGGER_OUTPUT")) == null) {
            throw new IOException("D8Logger: D8LOGGER_OUTPUT environment variable must be set.");
        }
        if (output.length() > 0) {
            CharSequence[] absArgs = (String[])Arrays.stream(args).map(s -> s.startsWith("-") ? s : Paths.get(s, new String[0]).toAbsolutePath().toString()).toArray(String[]::new);
            FileWriter fw = new FileWriter(output, true);
            fw.write(String.join((CharSequence)"\t", absArgs) + "\n");
            fw.close();
        }
        if (Arrays.stream(args).anyMatch(s -> s.equals("--dex"))) {
            CompatDx.main(args);
        } else {
            D8.main(args);
        }
    }
}

