/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

public class DexAccessFlags {
    private static final String[] ACC_NAMES = new String[]{"public", "private", "protected", "static", "final", "synchronized", "volatile(bridge)", "transient(varargs)", "native", "interface", "abstract", "strictfp", "synthetic", "annotation", "enum", "<unused>", "<init>", "synchronized"};
    private int flags;

    public DexAccessFlags(int flags) {
        this.flags = flags;
    }

    public DexAccessFlags(int ... flags) {
        this(DexAccessFlags.combineFlags(flags));
    }

    private static int combineFlags(int[] flags) {
        int combined = 0;
        for (int flag : flags) {
            combined |= flag;
        }
        return combined;
    }

    public boolean equals(Object other) {
        if (other instanceof DexAccessFlags) {
            return this.flags == ((DexAccessFlags)other).flags;
        }
        return false;
    }

    public int hashCode() {
        return this.get();
    }

    public int get() {
        return this.flags;
    }

    public boolean containsAllOf(DexAccessFlags other) {
        return (this.flags & other.get()) == other.get();
    }

    public boolean containsNoneOf(DexAccessFlags other) {
        return (this.flags & other.get()) == 0;
    }

    public boolean isPublic() {
        return this.isSet(1);
    }

    public void setPublic() {
        this.set(1);
    }

    public void unsetPublic() {
        this.unset(1);
    }

    public boolean isPrivate() {
        return this.isSet(2);
    }

    public void setPrivate() {
        this.set(2);
    }

    public void unsetPrivate() {
        this.unset(2);
    }

    public boolean isProtected() {
        return this.isSet(4);
    }

    public void setProtected() {
        this.set(4);
    }

    public void unsetProtected() {
        this.unset(4);
    }

    public boolean isStatic() {
        return this.isSet(8);
    }

    public void setStatic() {
        this.set(8);
    }

    public boolean isFinal() {
        return this.isSet(16);
    }

    public void setFinal() {
        this.set(16);
    }

    public void unsetFinal() {
        this.unset(16);
    }

    public boolean isSynchronized() {
        return this.isSet(32);
    }

    public void setSynchronized() {
        this.set(32);
    }

    public void unsetSynchronized() {
        this.unset(32);
    }

    public boolean isVolatile() {
        return this.isSet(64);
    }

    public void setVolatile() {
        this.set(64);
    }

    public boolean isBridge() {
        return this.isSet(64);
    }

    public void setBridge() {
        this.set(64);
    }

    public void unsetBridge() {
        this.unset(64);
    }

    public boolean isTransient() {
        return this.isSet(128);
    }

    public void setTransient() {
        this.set(128);
    }

    public boolean isVarargs() {
        return this.isSet(128);
    }

    public void setVarargs() {
        this.set(128);
    }

    public boolean isNative() {
        return this.isSet(256);
    }

    public void setNative() {
        this.set(256);
    }

    public boolean isInterface() {
        return this.isSet(512);
    }

    public void setInterface() {
        this.set(512);
    }

    public void unsetInterface() {
        this.unset(512);
    }

    public boolean isAbstract() {
        return this.isSet(1024);
    }

    public void setAbstract() {
        this.set(1024);
    }

    public void unsetAbstract() {
        this.unset(1024);
    }

    public boolean isStrict() {
        return this.isSet(2048);
    }

    public void setStrict() {
        this.set(2048);
    }

    public boolean isSynthetic() {
        return this.isSet(4096);
    }

    public void setSynthetic() {
        this.set(4096);
    }

    public void unsetSynthetic() {
        this.unset(4096);
    }

    public boolean isAnnotation() {
        return this.isSet(8192);
    }

    public void setAnnotation() {
        this.set(8192);
    }

    public boolean isEnum() {
        return this.isSet(16384);
    }

    public void setEnum() {
        this.set(16384);
    }

    public boolean isConstructor() {
        return this.isSet(65536);
    }

    public void setConstructor() {
        this.set(65536);
    }

    public void unsetConstructor() {
        this.unset(65536);
    }

    public boolean isDeclaredSynchronized() {
        return this.isSet(131072);
    }

    public void setDeclaredSynchronized() {
        this.set(131072);
    }

    public void promoteNonPrivateToPublic() {
        if (!this.isPrivate()) {
            this.flags &= 0xFFFFFFFB;
            this.flags |= 1;
        }
    }

    public void promoteToPublic() {
        this.flags &= 0xFFFFFFF9;
        this.flags |= 1;
    }

    private boolean isSet(int flag) {
        return (this.flags & flag) != 0;
    }

    private void set(int flag) {
        this.flags |= flag;
    }

    private void unset(int flag) {
        this.flags &= ~flag;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int flags = this.flags;
        flags &= 0xFFFEFFFF;
        for (int i = 0; i < ACC_NAMES.length && flags != 0; ++i, flags >>= 1) {
            if ((flags & 1) == 0) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(ACC_NAMES[i]);
        }
        assert (flags == 0);
        return builder.toString();
    }

    public String toSmaliString() {
        return this.toString();
    }
}

