/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.CanonicalizedDexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.utils.StringUtils;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NamingState<T extends CanonicalizedDexItem> {
    private final NamingState<T> parent;
    private final Map<T, InternalState> usedNames = new IdentityHashMap<T, InternalState>();
    private final DexItemFactory itemFactory;
    private final List<String> dictionary;

    public static <T extends CanonicalizedDexItem> NamingState<T> createRoot(DexItemFactory itemFactory, List<String> dictionary) {
        return new NamingState<T>(null, itemFactory, dictionary);
    }

    private NamingState(NamingState<T> parent, DexItemFactory itemFactory, List<String> dictionary) {
        this.parent = parent;
        this.itemFactory = itemFactory;
        this.dictionary = dictionary;
    }

    public NamingState<T> createChild() {
        return new NamingState<T>(this, this.itemFactory, this.dictionary);
    }

    private InternalState findInternalStateFor(T proto) {
        InternalState result = this.usedNames.get(proto);
        if (result == null && this.parent != null) {
            result = super.findInternalStateFor(proto);
        }
        return result;
    }

    private InternalState getOrCreateInternalStateFor(T proto) {
        InternalState result = this.usedNames.get(proto);
        if (result == null) {
            if (this.parent != null) {
                InternalState parentState = super.getOrCreateInternalStateFor(proto);
                result = parentState.createChild();
            } else {
                result = new InternalState(this.itemFactory, null, this.dictionary);
            }
            this.usedNames.put(proto, result);
        }
        return result;
    }

    public DexString getAssignedNameFor(DexString name, T proto) {
        InternalState state = this.findInternalStateFor(proto);
        if (state == null) {
            return null;
        }
        return state.getAssignedNameFor(name);
    }

    public DexString assignNewNameFor(DexString original, T proto, boolean markAsUsed) {
        DexString result = this.getAssignedNameFor(original, proto);
        if (result == null) {
            InternalState state = this.getOrCreateInternalStateFor(proto);
            result = state.getNameFor(original, markAsUsed);
        }
        return result;
    }

    public void reserveName(DexString name, T proto) {
        InternalState state = this.getOrCreateInternalStateFor(proto);
        state.reserveName(name);
    }

    public boolean isReserved(DexString name, T proto) {
        InternalState state = this.findInternalStateFor(proto);
        if (state == null) {
            return false;
        }
        return state.isReserved(name);
    }

    public boolean isAvailable(DexString original, T proto, DexString candidate) {
        InternalState state = this.findInternalStateFor(proto);
        if (state == null) {
            return true;
        }
        assert (state.getAssignedNameFor(original) != candidate);
        return state.isAvailable(candidate);
    }

    public void addRenaming(DexString original, T proto, DexString newName) {
        InternalState state = this.getOrCreateInternalStateFor(proto);
        state.addRenaming(original, newName);
    }

    private static class InternalState {
        private static int INITIAL_NAME_COUNT = 1;
        private static final char[] EMPTY_CHAR_ARRARY = new char[0];
        protected final DexItemFactory itemFactory;
        private final InternalState parentInternalState;
        private Set<DexString> reservedNames = null;
        private Map<DexString, DexString> renamings = null;
        private int nameCount;
        private final Iterator<String> dictionaryIterator;

        private InternalState(DexItemFactory itemFactory, InternalState parentInternalState, Iterator<String> dictionaryIterator) {
            this.itemFactory = itemFactory;
            this.parentInternalState = parentInternalState;
            this.nameCount = parentInternalState == null ? INITIAL_NAME_COUNT : parentInternalState.nameCount;
            this.dictionaryIterator = dictionaryIterator;
        }

        private InternalState(DexItemFactory itemFactory, InternalState parentInternalState, List<String> dictionary) {
            this(itemFactory, parentInternalState, dictionary.iterator());
        }

        private boolean isReserved(DexString name) {
            return this.reservedNames != null && this.reservedNames.contains(name) || this.parentInternalState != null && this.parentInternalState.isReserved(name);
        }

        private boolean isAvailable(DexString name) {
            return !(this.renamings != null && this.renamings.containsValue(name) || this.reservedNames != null && this.reservedNames.contains(name) || this.parentInternalState != null && !this.parentInternalState.isAvailable(name));
        }

        public InternalState createChild() {
            return new InternalState(this.itemFactory, this, this.dictionaryIterator);
        }

        public void reserveName(DexString name) {
            if (this.reservedNames == null) {
                this.reservedNames = Sets.newIdentityHashSet();
            }
            this.reservedNames.add(name);
        }

        public DexString getAssignedNameFor(DexString original) {
            DexString result;
            DexString dexString = result = this.renamings == null ? null : this.renamings.get(original);
            if (result == null && this.parentInternalState != null) {
                result = this.parentInternalState.getAssignedNameFor(original);
            }
            return result;
        }

        public DexString getNameFor(DexString original, boolean markAsUsed) {
            DexString name = this.getAssignedNameFor(original);
            if (name != null) {
                return name;
            }
            while (!this.isAvailable(name = this.itemFactory.createString(this.nextSuggestedName()))) {
            }
            if (markAsUsed) {
                this.addRenaming(original, name);
            }
            return name;
        }

        public void addRenaming(DexString original, DexString newName) {
            if (this.renamings == null) {
                this.renamings = HashBiMap.create();
            }
            this.renamings.put(original, newName);
        }

        protected String nextSuggestedName() {
            if (this.dictionaryIterator.hasNext()) {
                return this.dictionaryIterator.next();
            }
            return StringUtils.numberToIdentifier(EMPTY_CHAR_ARRARY, this.nameCount++, false);
        }
    }
}

