/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;

public class MainDexList {
    public static Set<DexType> parse(Path path, DexItemFactory itemFactory) throws IOException {
        try (Closer closer = Closer.create();){
            Set<DexType> set = MainDexList.parse((InputStream)closer.register((Closeable)Files.newInputStream(path, new OpenOption[0])), itemFactory);
            return set;
        }
    }

    public static Set<DexType> parse(InputStream input, DexItemFactory itemFactory) {
        Set result = Sets.newIdentityHashSet();
        try {
            String line;
            BufferedReader file = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            while ((line = file.readLine()) != null) {
                if (!line.endsWith(".class")) {
                    throw new CompilationError("Illegal main-dex-list entry '" + line + "'.");
                }
                String name = line.substring(0, line.length() - ".class".length());
                if (name.contains(".")) {
                    throw new CompilationError("Illegal main-dex-list entry '" + line + "'.");
                }
                String descriptor = "L" + name + ";";
                result.add(itemFactory.createType(descriptor));
            }
        }
        catch (IOException e) {
            throw new CompilationError("Cannot load main-dex-list.");
        }
        return result;
    }
}

