/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseConfigImpl
implements Serializable,
BaseConfig {
    private static final long serialVersionUID = 1L;
    private String mApplicationIdSuffix = null;
    private String mVersionNameSuffix = null;
    private final Map<String, ClassField> mBuildConfigFields = Maps.newTreeMap();
    private final Map<String, ClassField> mResValues = Maps.newTreeMap();
    private final List<File> mProguardFiles = Lists.newArrayList();
    private final List<File> mConsumerProguardFiles = Lists.newArrayList();
    private final List<File> mTestProguardFiles = Lists.newArrayList();
    private final Map<String, Object> mManifestPlaceholders = Maps.newHashMap();
    private Boolean mMultiDexEnabled;
    private File mMultiDexKeepProguard;
    private File mMultiDexKeepFile;
    private List<File> mJarJarRuleFiles = Lists.newArrayList();
    private Map<String, String> flavorSelection;

    public BaseConfigImpl setApplicationIdSuffix(String applicationIdSuffix) {
        this.mApplicationIdSuffix = applicationIdSuffix;
        return this;
    }

    public String getApplicationIdSuffix() {
        return this.mApplicationIdSuffix;
    }

    public BaseConfigImpl setVersionNameSuffix(String versionNameSuffix) {
        this.mVersionNameSuffix = versionNameSuffix;
        return this;
    }

    public String getVersionNameSuffix() {
        return this.mVersionNameSuffix;
    }

    public void addBuildConfigField(ClassField field) {
        this.mBuildConfigFields.put(field.getName(), field);
    }

    public void addResValue(ClassField field) {
        this.mResValues.put(field.getName(), field);
    }

    public void addResValues(Map<String, ClassField> values) {
        this.mResValues.putAll(values);
    }

    public Map<String, ClassField> getBuildConfigFields() {
        return this.mBuildConfigFields;
    }

    public void addBuildConfigFields(Map<String, ClassField> fields) {
        this.mBuildConfigFields.putAll(fields);
    }

    public Map<String, ClassField> getResValues() {
        return this.mResValues;
    }

    public void flavorSelection(String dimension, String value) {
        if (this.flavorSelection == null) {
            this.flavorSelection = Maps.newHashMap();
        }
        this.flavorSelection.put(dimension, value);
    }

    public void addFlavorSelections(Map<String, String> values) {
        if (this.flavorSelection == null) {
            this.flavorSelection = Maps.newHashMap();
        }
        this.flavorSelection.putAll(values);
    }

    public Map<String, String> getFlavorSelections() {
        if (this.flavorSelection == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.flavorSelection);
    }

    public List<File> getProguardFiles() {
        return this.mProguardFiles;
    }

    public List<File> getConsumerProguardFiles() {
        return this.mConsumerProguardFiles;
    }

    public List<File> getTestProguardFiles() {
        return this.mTestProguardFiles;
    }

    public Map<String, Object> getManifestPlaceholders() {
        return this.mManifestPlaceholders;
    }

    public void addManifestPlaceholders(Map<String, Object> manifestPlaceholders) {
        this.mManifestPlaceholders.putAll(manifestPlaceholders);
    }

    public void setManifestPlaceholders(Map<String, Object> manifestPlaceholders) {
        this.mManifestPlaceholders.clear();
        this.mManifestPlaceholders.putAll(manifestPlaceholders);
    }

    protected void _initWith(BaseConfig that) {
        this.setBuildConfigFields(that.getBuildConfigFields());
        this.setResValues(that.getResValues());
        if (that.getFlavorSelections().isEmpty()) {
            this.flavorSelection = null;
        } else {
            if (this.flavorSelection == null) {
                this.flavorSelection = new HashMap<String, String>();
            }
            this.flavorSelection.clear();
            this.flavorSelection.putAll(that.getFlavorSelections());
        }
        this.mApplicationIdSuffix = that.getApplicationIdSuffix();
        this.mVersionNameSuffix = that.getVersionNameSuffix();
        this.mProguardFiles.clear();
        this.mProguardFiles.addAll(that.getProguardFiles());
        this.mConsumerProguardFiles.clear();
        this.mConsumerProguardFiles.addAll(that.getConsumerProguardFiles());
        this.mTestProguardFiles.clear();
        this.mTestProguardFiles.addAll(that.getTestProguardFiles());
        this.mManifestPlaceholders.clear();
        this.mManifestPlaceholders.putAll(that.getManifestPlaceholders());
        this.mMultiDexEnabled = that.getMultiDexEnabled();
        this.mMultiDexKeepFile = that.getMultiDexKeepFile();
        this.mMultiDexKeepProguard = that.getMultiDexKeepProguard();
        this.mJarJarRuleFiles = that.getJarJarRuleFiles();
    }

    private void setBuildConfigFields(Map<String, ClassField> fields) {
        this.mBuildConfigFields.clear();
        this.mBuildConfigFields.putAll(fields);
    }

    private void setResValues(Map<String, ClassField> fields) {
        this.mResValues.clear();
        this.mResValues.putAll(fields);
    }

    public Boolean getMultiDexEnabled() {
        return this.mMultiDexEnabled;
    }

    public void setMultiDexEnabled(Boolean multiDex) {
        this.mMultiDexEnabled = multiDex;
    }

    public File getMultiDexKeepFile() {
        return this.mMultiDexKeepFile;
    }

    public void setMultiDexKeepFile(File file) {
        this.mMultiDexKeepFile = file;
    }

    public File getMultiDexKeepProguard() {
        return this.mMultiDexKeepProguard;
    }

    public void setMultiDexKeepProguard(File file) {
        this.mMultiDexKeepProguard = file;
    }

    public void setJarJarRuleFiles(List<File> files) {
        this.mJarJarRuleFiles = files;
    }

    public List<File> getJarJarRuleFiles() {
        return this.mJarJarRuleFiles;
    }

    public String toString() {
        return "BaseConfigImpl{applicationIdSuffix=" + this.mApplicationIdSuffix + ", versionNameSuffix=" + this.mVersionNameSuffix + ", mBuildConfigFields=" + this.mBuildConfigFields + ", mResValues=" + this.mResValues + ", mProguardFiles=" + this.mProguardFiles + ", mConsumerProguardFiles=" + this.mConsumerProguardFiles + ", mManifestPlaceholders=" + this.mManifestPlaceholders + ", mMultiDexEnabled=" + this.mMultiDexEnabled + ", mMultiDexKeepFile=" + this.mMultiDexKeepFile + ", mMultiDexKeepProguard=" + this.mMultiDexKeepProguard + ", mJarJarRuleFiles=" + this.mJarJarRuleFiles + '}';
    }
}

