/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class R8Command
extends BaseCommand {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: r8 [options] <input-files>", (Object)" where <input-files> are any combination of dex, class, zip, jar, or apk files", (Object)" and options are:", (Object)"  --release               # Compile without debugging information (default).", (Object)"  --debug                 # Compile with debugging information.", (Object)"  --output <file>         # Output result in <file>.", (Object)"                          # <file> must be an existing directory or a zip file.", (Object)"  --lib <file>            # Add <file> as a library resource.", (Object)"  --min-api               # Minimum Android API level compatibility.", (Object)"  --pg-conf <file>        # Proguard configuration <file> (implies tree shaking/minification).", (Object)"  --pg-map <file>         # Proguard map <file>.", (Object)"  --no-tree-shaking       # Force disable tree shaking of unreachable classes.", (Object[])new String[]{"  --no-minification       # Force disable minification of names.", "  --multidex-rules <file> # Enable automatic classes partitioning for legacy multidex.", "                          # <file> is a Proguard configuration file (with only keep rules).", "  --version               # Print the version of r8.", "  --help                  # Print this message."}));
    private final ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
    private final boolean minimalMainDex;
    private final ProguardConfiguration proguardConfiguration;
    private final boolean useTreeShaking;
    private final boolean useMinification;
    private final boolean ignoreMissingClasses;

    public static Builder builder() {
        return new Builder();
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static Builder parse(String[] args) throws CompilationException, IOException {
        Builder builder = R8Command.builder();
        R8Command.parse(args, builder, new ParseState());
        return builder;
    }

    private static ParseState parse(String[] args, Builder builder, ParseState state) throws CompilationException, IOException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--debug")) {
                if (state.mode == CompilationMode.RELEASE) {
                    throw new CompilationException("Cannot compile in both --debug and --release mode.");
                }
                state.mode = CompilationMode.DEBUG;
                builder.setMode(state.mode);
                continue;
            }
            if (arg.equals("--release")) {
                if (state.mode == CompilationMode.DEBUG) {
                    throw new CompilationException("Cannot compile in both --debug and --release mode.");
                }
                state.mode = CompilationMode.RELEASE;
                builder.setMode(state.mode);
                continue;
            }
            if (arg.equals("--output")) {
                String outputPath = args[++i];
                if (builder.getOutputPath() != null) {
                    throw new CompilationException("Cannot output both to '" + builder.getOutputPath().toString() + "' and '" + outputPath + "'");
                }
                builder.setOutputPath(Paths.get(outputPath, new String[0]));
                continue;
            }
            if (arg.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--min-api")) {
                builder.setMinApiLevel(Integer.valueOf(args[++i]));
                continue;
            }
            if (arg.equals("--no-tree-shaking")) {
                builder.setTreeShaking(false);
                continue;
            }
            if (arg.equals("--no-minification")) {
                builder.setMinification(false);
                continue;
            }
            if (arg.equals("--multidex-rules")) {
                builder.addMainDexRules(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--minimal-maindex")) {
                builder.setMinimalMainDex(true);
                continue;
            }
            if (arg.equals("--pg-conf")) {
                builder.addProguardConfigurationFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--pg-map")) {
                builder.setProguardMapFile(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--ignore-missing-classes")) {
                builder.setIgnoreMissingClasses(true);
                continue;
            }
            if (arg.startsWith("@")) {
                String argsFile = arg.substring(1);
                try {
                    List<String> linesInFile = FileUtils.readTextFile(Paths.get(argsFile, new String[0]));
                    ArrayList<String> argsInFile = new ArrayList<String>();
                    for (String line : linesInFile) {
                        for (String word : line.split("\\s")) {
                            String trimmed = word.trim();
                            if (trimmed.isEmpty()) continue;
                            argsInFile.add(trimmed);
                        }
                    }
                    state = R8Command.parse(argsInFile.toArray(new String[argsInFile.size()]), builder, state);
                    continue;
                }
                catch (CompilationException | IOException e) {
                    throw new CompilationException("Failed to read arguments from file " + argsFile + ": " + e.getMessage());
                }
            }
            if (arg.startsWith("--")) {
                throw new CompilationException("Unknown option: " + arg);
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
        return state;
    }

    private R8Command(AndroidApp inputApp, Path outputPath, OutputMode outputMode, ImmutableList<ProguardConfigurationRule> mainDexKeepRules, boolean minimalMainDex, ProguardConfiguration proguardConfiguration, CompilationMode mode, int minApiLevel, boolean useTreeShaking, boolean useMinification, boolean ignoreMissingClasses) {
        super(inputApp, outputPath, outputMode, mode, minApiLevel);
        assert (proguardConfiguration != null);
        assert (mainDexKeepRules != null);
        assert (this.getOutputMode() == OutputMode.Indexed) : "Only regular mode is supported in R8";
        this.mainDexKeepRules = mainDexKeepRules;
        this.minimalMainDex = minimalMainDex;
        this.proguardConfiguration = proguardConfiguration;
        this.useTreeShaking = useTreeShaking;
        this.useMinification = useMinification;
        this.ignoreMissingClasses = ignoreMissingClasses;
    }

    private R8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.mainDexKeepRules = ImmutableList.of();
        this.minimalMainDex = false;
        this.proguardConfiguration = null;
        this.useTreeShaking = false;
        this.useMinification = false;
        this.ignoreMissingClasses = false;
    }

    public boolean useTreeShaking() {
        return this.useTreeShaking;
    }

    public boolean useMinification() {
        return this.useMinification;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.proguardConfiguration.getDexItemFactory());
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.minApiLevel = this.getMinApiLevel();
        assert (!internal.skipMinification);
        boolean bl = internal.skipMinification = !this.useMinification();
        assert (internal.useTreeShaking);
        internal.useTreeShaking = this.useTreeShaking();
        assert (!internal.printUsage);
        internal.printUsage = this.proguardConfiguration.isPrintUsage();
        internal.printUsageFile = this.proguardConfiguration.getPrintUsageFile();
        assert (!internal.ignoreMissingClasses);
        internal.ignoreMissingClasses = this.ignoreMissingClasses;
        assert (internal.packagePrefix.length() == 0);
        internal.packagePrefix = this.proguardConfiguration.getPackagePrefix();
        assert (internal.allowAccessModification);
        internal.allowAccessModification = this.proguardConfiguration.getAllowAccessModification();
        for (String pattern : this.proguardConfiguration.getAttributesRemovalPatterns()) {
            internal.attributeRemoval.applyPattern(pattern);
        }
        if (this.proguardConfiguration.isIgnoreWarnings()) {
            internal.ignoreMissingClasses = true;
        }
        assert (internal.seedsFile == null);
        if (this.proguardConfiguration.getSeedFile() != null) {
            internal.seedsFile = this.proguardConfiguration.getSeedFile();
        }
        assert (!internal.verbose);
        if (this.proguardConfiguration.isVerbose()) {
            internal.verbose = true;
        }
        if (!this.proguardConfiguration.isObfuscating()) {
            internal.skipMinification = true;
        }
        internal.printSeeds |= this.proguardConfiguration.getPrintSeeds();
        internal.printMapping |= this.proguardConfiguration.isPrintingMapping();
        internal.printMappingFile = this.proguardConfiguration.getPrintMappingOutput();
        internal.classObfuscationDictionary = this.proguardConfiguration.getClassObfuscationDictionary();
        internal.obfuscationDictionary = this.proguardConfiguration.getObfuscationDictionary();
        internal.mainDexKeepRules = this.mainDexKeepRules;
        internal.minimalMainDex = this.minimalMainDex;
        internal.keepRules = this.proguardConfiguration.getRules();
        internal.dontWarnPatterns = this.proguardConfiguration.getDontWarnPatterns();
        internal.outputMode = this.getOutputMode();
        if (internal.debug) {
            internal.removeSwitchMaps = false;
            internal.inlineAccessors = false;
        }
        return internal;
    }

    private static class ParseState {
        CompilationMode mode = null;

        private ParseState() {
        }
    }

    public static class Builder
    extends BaseCommand.Builder<R8Command, Builder> {
        private final List<Path> mainDexRules = new ArrayList<Path>();
        private boolean minimalMainDex = false;
        private final List<Path> proguardConfigFiles = new ArrayList<Path>();
        private Optional<Boolean> treeShaking = Optional.empty();
        private Optional<Boolean> minification = Optional.empty();
        private boolean ignoreMissingClasses = false;

        private Builder() {
            super(CompilationMode.RELEASE);
        }

        private Builder(AndroidApp app) {
            super(app, CompilationMode.RELEASE);
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setTreeShaking(boolean useTreeShaking) {
            this.treeShaking = Optional.of(useTreeShaking);
            return this;
        }

        public Builder setMinification(boolean useMinification) {
            this.minification = Optional.of(useMinification);
            return this;
        }

        public Builder addMainDexRules(Path ... paths) {
            Collections.addAll(this.mainDexRules, paths);
            return this;
        }

        public Builder addMainDexRules(List<Path> paths) {
            this.mainDexRules.addAll(paths);
            return this;
        }

        public Builder setMinimalMainDex(boolean value) {
            this.minimalMainDex = value;
            return this;
        }

        public Builder addProguardConfigurationFiles(Path ... paths) {
            Collections.addAll(this.proguardConfigFiles, paths);
            return this;
        }

        public Builder addProguardConfigurationFiles(List<Path> paths) {
            this.proguardConfigFiles.addAll(paths);
            return this;
        }

        public Builder setProguardMapFile(Path path) {
            this.getAppBuilder().setProguardMapFile(path);
            return this;
        }

        public Builder setPackageDistributionFile(Path path) {
            this.getAppBuilder().setPackageDistributionFile(path);
            return this;
        }

        Builder setIgnoreMissingClasses(boolean ignoreMissingClasses) {
            this.ignoreMissingClasses = ignoreMissingClasses;
            return this;
        }

        @Override
        public R8Command build() throws CompilationException, IOException {
            ProguardConfiguration configuration;
            ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new R8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            this.validate();
            DexItemFactory factory = new DexItemFactory();
            if (this.mainDexRules.isEmpty()) {
                mainDexKeepRules = ImmutableList.of();
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory);
                try {
                    parser.parse(this.mainDexRules);
                }
                catch (ProguardRuleParserException e) {
                    throw new CompilationException(e.getMessage(), e.getCause());
                }
                mainDexKeepRules = parser.getConfig().getRules();
            }
            if (this.proguardConfigFiles.isEmpty()) {
                configuration = ProguardConfiguration.defaultConfiguration(factory);
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory);
                try {
                    parser.parse(this.proguardConfigFiles);
                }
                catch (ProguardRuleParserException e) {
                    throw new CompilationException(e.getMessage(), e.getCause());
                }
                configuration = parser.getConfig();
                this.addProgramFiles(configuration.getInjars(), false);
                this.addLibraryFiles(configuration.getLibraryjars());
            }
            boolean useTreeShaking = this.treeShaking.orElse(configuration.isShrinking());
            boolean useMinification = this.minification.orElse(configuration.isObfuscating());
            return new R8Command(this.getAppBuilder().build(), this.getOutputPath(), this.getOutputMode(), mainDexKeepRules, this.minimalMainDex, configuration, this.getMode(), this.getMinApiLevel(), useTreeShaking, useMinification, this.ignoreMissingClasses);
        }
    }
}

