/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.PackageDistribution;
import com.android.tools.r8.utils.ThreadUtils;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;

public class VirtualFile {
    private static final int MAX_ENTRIES = 65536;
    private static final int MAX_PREFILL_ENTRIES = 60536;
    private final int id;
    private final VirtualFileIndexedItemCollection indexedItems;
    private final IndexedItemTransaction transaction;

    private VirtualFile(int id, NamingLens namingLens) {
        this.id = id;
        this.indexedItems = new VirtualFileIndexedItemCollection(id);
        this.transaction = new IndexedItemTransaction(this.indexedItems, namingLens);
    }

    public int getId() {
        return this.id;
    }

    public Set<String> getClassDescriptors() {
        HashSet<String> classDescriptors = new HashSet<String>();
        for (DexProgramClass clazz : this.indexedItems.classes) {
            boolean added = classDescriptors.add(clazz.type.descriptor.toString());
            assert (added);
        }
        return classDescriptors;
    }

    public static String deriveCommonPrefixAndSanityCheck(List<String> fileNames) {
        Iterator<String> nameIterator = fileNames.iterator();
        String first = nameIterator.next();
        if (!first.toLowerCase().endsWith(".dex")) {
            throw new RuntimeException("Illegal suffix for dex file: `" + first + "`.");
        }
        String prefix = first.substring(0, first.length() - ".dex".length());
        int index = 2;
        while (nameIterator.hasNext()) {
            String next = nameIterator.next();
            if (!next.toLowerCase().endsWith(".dex")) {
                throw new RuntimeException("Illegal suffix for dex file: `" + first + "`.");
            }
            if (!next.startsWith(prefix)) {
                throw new RuntimeException("Input filenames lack common prefix.");
            }
            String numberPart = next.substring(prefix.length(), next.length() - ".dex".length());
            if (Integer.parseInt(numberPart) == index++) continue;
            throw new RuntimeException("DEX files are not numbered consecutively.");
        }
        return prefix;
    }

    private static Map<DexProgramClass, String> computeOriginalNameMapping(Collection<DexProgramClass> classes, ClassNameMapper proguardMap) {
        HashMap<DexProgramClass, String> originalNames = new HashMap<DexProgramClass, String>();
        classes.forEach(c -> originalNames.put((DexProgramClass)c, DescriptorUtils.descriptorToJavaType(c.type.toDescriptorString(), proguardMap)));
        return originalNames;
    }

    private static String extractPrefixToken(int prefixLength, String className, boolean addStar) {
        int index = 0;
        int lastIndex = 0;
        int segmentCount = 0;
        while (lastIndex != -1 && segmentCount++ < prefixLength) {
            index = lastIndex;
            lastIndex = className.indexOf(46, index + 1);
        }
        String prefix = className.substring(0, index);
        if (addStar && segmentCount >= prefixLength) {
            prefix = prefix + ".*";
        }
        return prefix;
    }

    public ObjectToOffsetMapping computeMapping(DexApplication application) {
        assert (this.transaction.isEmpty());
        return new ObjectToOffsetMapping(this.id, application, this.indexedItems.classes.toArray(new DexProgramClass[this.indexedItems.classes.size()]), this.indexedItems.protos.toArray(new DexProto[this.indexedItems.protos.size()]), this.indexedItems.types.toArray(new DexType[this.indexedItems.types.size()]), this.indexedItems.methods.toArray(new DexMethod[this.indexedItems.methods.size()]), this.indexedItems.fields.toArray(new DexField[this.indexedItems.fields.size()]), this.indexedItems.strings.toArray(new DexString[this.indexedItems.strings.size()]), this.indexedItems.callSites.toArray(new DexCallSite[this.indexedItems.callSites.size()]), this.indexedItems.methodHandles.toArray(new DexMethodHandle[this.indexedItems.methodHandles.size()]));
    }

    private void addClass(DexProgramClass clazz) {
        this.transaction.addClassAndDependencies(clazz);
    }

    private static boolean isFull(int numberOfMethods, int numberOfFields, int maximum) {
        return numberOfMethods > maximum || numberOfFields > maximum;
    }

    private boolean isFull() {
        return VirtualFile.isFull(this.transaction.getNumberOfMethods(), this.transaction.getNumberOfFields(), 65536);
    }

    private boolean isFilledEnough(FillStrategy fillStrategy) {
        return VirtualFile.isFull(this.transaction.getNumberOfMethods(), this.transaction.getNumberOfFields(), fillStrategy == FillStrategy.FILL_MAX ? 65536 : 60536);
    }

    public void abortTransaction() {
        this.transaction.abort();
    }

    public void commitTransaction() {
        this.transaction.commit();
    }

    public boolean isEmpty() {
        return this.indexedItems.classes.isEmpty();
    }

    public List<DexProgramClass> classes() {
        return this.indexedItems.classes;
    }

    private static class PackageSplitPopulator
    implements Callable<Map<String, Integer>> {
        private static final int MINIMUM_PREFIX_LENGTH = 4;
        private static final int MAXIMUM_PREFIX_LENGTH = 7;
        private static final int MIN_FILL_FACTOR = 5;
        private final List<DexProgramClass> classes;
        private final Map<DexProgramClass, String> originalNames;
        private final Set<String> previousPrefixes;
        private final DexItemFactory dexItemFactory;
        private final FillStrategy fillStrategy;
        private final VirtualFileCycler cycler;

        PackageSplitPopulator(Map<Integer, VirtualFile> files, Set<DexProgramClass> classes, Map<DexProgramClass, String> originalNames, Set<String> previousPrefixes, DexItemFactory dexItemFactory, FillStrategy fillStrategy, NamingLens namingLens) {
            this.classes = new ArrayList<DexProgramClass>(classes);
            this.originalNames = originalNames;
            this.previousPrefixes = previousPrefixes;
            this.dexItemFactory = dexItemFactory;
            this.fillStrategy = fillStrategy;
            this.cycler = new VirtualFileCycler(files, namingLens, fillStrategy);
        }

        private String getOriginalName(DexProgramClass clazz) {
            return this.originalNames != null ? this.originalNames.get(clazz) : clazz.toString();
        }

        @Override
        public Map<String, Integer> call() throws IOException {
            int prefixLength = 4;
            int transactionStartIndex = 0;
            int fileStartIndex = 0;
            String currentPrefix = null;
            LinkedHashMap<String, Integer> newPackageAssignments = new LinkedHashMap<String, Integer>();
            VirtualFile current = this.cycler.next();
            ArrayList<DexProgramClass> nonPackageClasses = new ArrayList<DexProgramClass>();
            for (int classIndex = 0; classIndex < this.classes.size(); ++classIndex) {
                DexProgramClass clazz = this.classes.get(classIndex);
                String originalName = this.getOriginalName(clazz);
                if (!PackageMapPopulator.coveredByPrefix(originalName, currentPrefix)) {
                    String newPrefix;
                    if (currentPrefix != null) {
                        current.commitTransaction();
                        this.cycler.restart();
                        assert (!newPackageAssignments.containsKey(currentPrefix));
                        newPackageAssignments.put(currentPrefix, current.id);
                        prefixLength = 3;
                    }
                    do {
                        newPrefix = VirtualFile.extractPrefixToken(++prefixLength, originalName, false);
                    } while (currentPrefix != null && (currentPrefix.startsWith(newPrefix) || this.conflictsWithPreviousPrefix(newPrefix, originalName)));
                    if (!newPrefix.equals("")) {
                        currentPrefix = VirtualFile.extractPrefixToken(prefixLength, originalName, true);
                    }
                    transactionStartIndex = classIndex;
                }
                if (currentPrefix != null) {
                    assert (clazz.superType != null || clazz.type == this.dexItemFactory.objectType);
                } else {
                    assert (clazz.superType != null);
                    assert (current.transaction.isEmpty());
                    nonPackageClasses.add(clazz);
                    continue;
                }
                current.addClass(clazz);
                if (!current.isFilledEnough(this.fillStrategy) && !current.isFull()) continue;
                current.abortTransaction();
                if (classIndex - transactionStartIndex > (classIndex - fileStartIndex) / 5 && prefixLength < 7) {
                    ++prefixLength;
                } else {
                    fileStartIndex = transactionStartIndex;
                    if (!this.cycler.hasNext()) {
                        if (current.transaction.getNumberOfClasses() == 0) {
                            for (int j = transactionStartIndex; j <= classIndex; ++j) {
                                nonPackageClasses.add(this.classes.get(j));
                            }
                            transactionStartIndex = classIndex + 1;
                        }
                        this.cycler.addFile();
                    }
                    current = this.cycler.next();
                }
                currentPrefix = null;
                classIndex = transactionStartIndex - 1;
                assert (current != null);
            }
            current.commitTransaction();
            assert (!newPackageAssignments.containsKey(currentPrefix));
            if (currentPrefix != null) {
                newPackageAssignments.put(currentPrefix, current.id);
            }
            if (nonPackageClasses.size() > 0) {
                this.addNonPackageClasses(this.cycler, nonPackageClasses);
            }
            return newPackageAssignments;
        }

        private void addNonPackageClasses(VirtualFileCycler cycler, List<DexProgramClass> nonPackageClasses) {
            cycler.restart();
            VirtualFile current = cycler.next();
            for (DexProgramClass clazz : nonPackageClasses) {
                if (current.isFilledEnough(this.fillStrategy)) {
                    current = this.getVirtualFile(cycler);
                }
                current.addClass(clazz);
                while (current.isFull()) {
                    current.abortTransaction();
                    current = this.getVirtualFile(cycler);
                    boolean wasEmpty = current.isEmpty();
                    current.addClass(clazz);
                    if (!wasEmpty || !current.isFull()) continue;
                    throw new InternalCompilerError("Class " + clazz.toString() + " does not fit into a single dex file.");
                }
                current.commitTransaction();
            }
        }

        private VirtualFile getVirtualFile(VirtualFileCycler cycler) {
            VirtualFile current = null;
            while (cycler.hasNext() && (current = cycler.next()).isFilledEnough(this.fillStrategy)) {
            }
            if (current == null || current.isFilledEnough(this.fillStrategy)) {
                current = cycler.addFile();
            }
            return current;
        }

        private boolean conflictsWithPreviousPrefix(String newPrefix, String originalName) {
            if (this.previousPrefixes == null) {
                return false;
            }
            for (String previous : this.previousPrefixes) {
                if (!previous.startsWith(newPrefix) || originalName.lastIndexOf(46) <= newPrefix.length()) continue;
                return true;
            }
            return false;
        }
    }

    private static class VirtualFileCycler {
        private Map<Integer, VirtualFile> files;
        private final NamingLens namingLens;
        private final FillStrategy fillStrategy;
        private int nextFileId;
        private Iterator<VirtualFile> allFilesCyclic;
        private Iterator<VirtualFile> activeFiles;

        VirtualFileCycler(Map<Integer, VirtualFile> files, NamingLens namingLens, FillStrategy fillStrategy) {
            this.files = files;
            this.namingLens = namingLens;
            this.fillStrategy = fillStrategy;
            this.nextFileId = files.size();
            if (fillStrategy == FillStrategy.MINIMAL_MAIN_DEX) {
                files.put(this.nextFileId, new VirtualFile(this.nextFileId, namingLens));
                this.files = Maps.filterKeys(files, key -> key != 0);
                ++this.nextFileId;
            }
            this.reset();
        }

        private void reset() {
            this.allFilesCyclic = Iterators.cycle(this.files.values());
            this.restart();
        }

        boolean hasNext() {
            return this.activeFiles.hasNext();
        }

        VirtualFile next() {
            VirtualFile next = this.activeFiles.next();
            assert (this.fillStrategy != FillStrategy.MINIMAL_MAIN_DEX || next.getId() != 0);
            return next;
        }

        void restart() {
            this.activeFiles = Iterators.limit(this.allFilesCyclic, (int)this.files.size());
        }

        VirtualFile addFile() {
            VirtualFile newFile = new VirtualFile(this.nextFileId, this.namingLens);
            this.files.put(this.nextFileId, newFile);
            ++this.nextFileId;
            this.reset();
            return newFile;
        }
    }

    private static class PackageMapPopulator
    implements Callable<List<DexProgramClass>> {
        private final VirtualFile file;
        private final Collection<DexProgramClass> classes;
        private final PackageDistribution packageDistribution;
        private final Map<DexProgramClass, String> originalNames;

        PackageMapPopulator(VirtualFile file, Collection<DexProgramClass> classes, PackageDistribution packageDistribution, Map<DexProgramClass, String> originalNames) {
            this.file = file;
            this.classes = classes;
            this.packageDistribution = packageDistribution;
            this.originalNames = originalNames;
        }

        @Override
        public List<DexProgramClass> call() {
            String currentPrefix = null;
            int currentFileId = -1;
            ArrayList<DexProgramClass> inserted = new ArrayList<DexProgramClass>();
            for (DexProgramClass clazz : this.classes) {
                String originalName = this.originalNames.get(clazz);
                assert (originalName != null);
                if (!PackageMapPopulator.coveredByPrefix(originalName, currentPrefix)) {
                    if (currentPrefix != null) {
                        this.file.commitTransaction();
                    }
                    currentFileId = (currentPrefix = this.lookupPrefixFor(originalName)) == null ? -1 : this.packageDistribution.get(currentPrefix);
                }
                if (currentFileId == this.file.id) {
                    this.file.addClass(clazz);
                    inserted.add(clazz);
                }
                if (!this.file.isFull()) continue;
                throw new CompilationError("Cannot fit package " + currentPrefix + " in requested dex file, consider removing mapping.");
            }
            this.file.commitTransaction();
            return inserted;
        }

        private String lookupPrefixFor(String originalName) {
            int index;
            int lastIndexOfDot = originalName.lastIndexOf(46);
            if (lastIndexOfDot < 0) {
                return null;
            }
            String prefix = originalName.substring(0, lastIndexOfDot);
            if (this.packageDistribution.containsFile(prefix)) {
                return prefix;
            }
            prefix = originalName;
            while ((index = prefix.lastIndexOf(46)) != -1) {
                if (!this.packageDistribution.containsFile((prefix = prefix.substring(0, index)) + ".*")) continue;
                return prefix + ".*";
            }
            return null;
        }

        static boolean coveredByPrefix(String originalName, String currentPrefix) {
            if (currentPrefix == null) {
                return false;
            }
            if (currentPrefix.endsWith(".*")) {
                return originalName.startsWith(currentPrefix.substring(0, currentPrefix.length() - 2));
            }
            return originalName.startsWith(currentPrefix) && originalName.lastIndexOf(46) == currentPrefix.length();
        }
    }

    private static class IndexedItemTransaction
    implements IndexedItemCollection {
        private final VirtualFileIndexedItemCollection base;
        private final NamingLens namingLens;
        private final Set<DexProgramClass> classes = new LinkedHashSet<DexProgramClass>();
        private final Set<DexField> fields = new LinkedHashSet<DexField>();
        private final Set<DexMethod> methods = new LinkedHashSet<DexMethod>();
        private final Set<DexType> types = new LinkedHashSet<DexType>();
        private final Set<DexProto> protos = new LinkedHashSet<DexProto>();
        private final Set<DexString> strings = new LinkedHashSet<DexString>();
        private final Set<DexCallSite> callSites = new LinkedHashSet<DexCallSite>();
        private final Set<DexMethodHandle> methodHandles = new LinkedHashSet<DexMethodHandle>();

        private IndexedItemTransaction(VirtualFileIndexedItemCollection base, NamingLens namingLens) {
            this.base = base;
            this.namingLens = namingLens;
        }

        private <T extends IndexedDexItem> boolean maybeInsert(T item, Set<T> set) {
            if (item.hasVirtualFileData(this.base.id) || set.contains(item)) {
                return false;
            }
            set.add(item);
            return true;
        }

        void addClassAndDependencies(DexProgramClass clazz) {
            clazz.collectIndexedItems(this);
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            if (this.base.seenClasses.contains(dexProgramClass) || this.classes.contains(dexProgramClass)) {
                return false;
            }
            this.classes.add(dexProgramClass);
            return true;
        }

        @Override
        public boolean addField(DexField field) {
            return this.maybeInsert(field, this.fields);
        }

        @Override
        public boolean addMethod(DexMethod method) {
            return this.maybeInsert(method, this.methods);
        }

        @Override
        public boolean addString(DexString string) {
            return this.maybeInsert(string, this.strings);
        }

        @Override
        public boolean addProto(DexProto proto) {
            return this.maybeInsert(proto, this.protos);
        }

        @Override
        public boolean addType(DexType type) {
            return this.maybeInsert(type, this.types);
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return this.maybeInsert(callSite, this.callSites);
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return this.maybeInsert(methodHandle, this.methodHandles);
        }

        @Override
        public DexString getRenamedDescriptor(DexType type) {
            return this.namingLens.lookupDescriptor(type);
        }

        @Override
        public DexString getRenamedName(DexMethod method) {
            assert (this.namingLens.checkTargetCanBeTranslated(method));
            return this.namingLens.lookupName(method);
        }

        @Override
        public DexString getRenamedName(DexField field) {
            return this.namingLens.lookupName(field);
        }

        int getNumberOfMethods() {
            return this.methods.size() + this.base.getNumberOfMethods();
        }

        int getNumberOfFields() {
            return this.fields.size() + this.base.getNumberOfFields();
        }

        private <T extends DexItem> void commitItemsIn(Set<T> set, Function<T, Boolean> hook) {
            set.forEach(item -> {
                boolean newlyAdded = (Boolean)hook.apply(item);
                assert (newlyAdded);
            });
            set.clear();
        }

        void commit() {
            this.commitItemsIn(this.classes, this.base::addClass);
            this.commitItemsIn(this.fields, this.base::addField);
            this.commitItemsIn(this.methods, this.base::addMethod);
            this.commitItemsIn(this.protos, this.base::addProto);
            this.commitItemsIn(this.types, this.base::addType);
            this.commitItemsIn(this.strings, this.base::addString);
            this.commitItemsIn(this.callSites, this.base::addCallSite);
            this.commitItemsIn(this.methodHandles, this.base::addMethodHandle);
        }

        void abort() {
            this.classes.clear();
            this.fields.clear();
            this.methods.clear();
            this.protos.clear();
            this.types.clear();
            this.strings.clear();
        }

        public boolean isEmpty() {
            return this.classes.isEmpty() && this.fields.isEmpty() && this.methods.isEmpty() && this.protos.isEmpty() && this.types.isEmpty() && this.strings.isEmpty();
        }

        int getNumberOfStrings() {
            return this.strings.size() + this.base.getNumberOfStrings();
        }

        int getNumberOfClasses() {
            return this.classes.size() + this.base.classes.size();
        }
    }

    private static class VirtualFileIndexedItemCollection
    implements IndexedItemCollection {
        final int id;
        private final List<DexProgramClass> classes = new ArrayList<DexProgramClass>();
        private final List<DexProto> protos = new ArrayList<DexProto>();
        private final List<DexType> types = new ArrayList<DexType>();
        private final List<DexMethod> methods = new ArrayList<DexMethod>();
        private final List<DexField> fields = new ArrayList<DexField>();
        private final List<DexString> strings = new ArrayList<DexString>();
        private final List<DexCallSite> callSites = new ArrayList<DexCallSite>();
        private final List<DexMethodHandle> methodHandles = new ArrayList<DexMethodHandle>();
        private final Set<DexClass> seenClasses = Sets.newIdentityHashSet();

        private VirtualFileIndexedItemCollection(int id) {
            this.id = id;
        }

        private <T extends IndexedDexItem> boolean addItem(T item, List<T> itemList) {
            assert (item != null);
            if (item.assignToVirtualFile(this.id)) {
                itemList.add(item);
                return true;
            }
            return false;
        }

        @Override
        public boolean addClass(DexProgramClass clazz) {
            if (this.seenClasses.add(clazz)) {
                this.classes.add(clazz);
                return true;
            }
            return false;
        }

        @Override
        public boolean addField(DexField field) {
            return this.addItem(field, this.fields);
        }

        @Override
        public boolean addMethod(DexMethod method) {
            return this.addItem(method, this.methods);
        }

        @Override
        public boolean addString(DexString string) {
            return this.addItem(string, this.strings);
        }

        @Override
        public boolean addProto(DexProto proto) {
            return this.addItem(proto, this.protos);
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return this.addItem(callSite, this.callSites);
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return this.addItem(methodHandle, this.methodHandles);
        }

        @Override
        public boolean addType(DexType type) {
            return this.addItem(type, this.types);
        }

        public int getNumberOfMethods() {
            return this.methods.size();
        }

        public int getNumberOfFields() {
            return this.fields.size();
        }

        public int getNumberOfStrings() {
            return this.strings.size();
        }
    }

    public static class PackageMapDistributor
    extends DistributorBase {
        private final PackageDistribution packageDistribution;
        private final ExecutorService executorService;

        public PackageMapDistributor(ApplicationWriter writer, PackageDistribution packageDistribution, ExecutorService executorService) {
            super(writer);
            this.packageDistribution = packageDistribution;
            this.executorService = executorService;
        }

        @Override
        public Map<Integer, VirtualFile> run() throws ExecutionException, IOException {
            Object newAssignments;
            int maxReferencedIndex = this.packageDistribution.maxReferencedIndex();
            for (int index = 0; index <= maxReferencedIndex; ++index) {
                VirtualFile file = new VirtualFile(index, this.writer.namingLens);
                this.nameToFileMap.put(index, file);
            }
            this.fillForMainDexList(this.classes);
            this.classes = this.sortClassesByPackage(this.classes, this.originalNames);
            Set<String> usedPrefixes = this.fillForDistribution(this.classes, this.originalNames);
            if (this.classes.isEmpty()) {
                newAssignments = Collections.emptyMap();
            } else {
                newAssignments = new PackageSplitPopulator(this.nameToFileMap, this.classes, this.originalNames, usedPrefixes, this.application.dexItemFactory, FillStrategy.LEAVE_SPACE_FOR_GROWTH, this.writer.namingLens).call();
                if (!newAssignments.isEmpty() && this.nameToFileMap.size() > 1) {
                    System.err.println(" * The used package map is missing entries. The following default mappings have been used:");
                    this.writeAssignments((Map<String, Integer>)newAssignments, new OutputStreamWriter(System.err));
                    System.err.println(" * Consider updating the map.");
                }
            }
            Path newPackageMap = Paths.get("package.map", new String[0]);
            System.out.println(" - " + newPackageMap.toString());
            PackageDistribution.writePackageToFileMap(newPackageMap, (Map<String, Integer>)newAssignments, this.packageDistribution);
            return this.nameToFileMap;
        }

        private Set<String> fillForDistribution(Set<DexProgramClass> classes, Map<DexProgramClass, String> originalNames) throws ExecutionException {
            Set<String> usedPrefixes = null;
            if (this.packageDistribution != null) {
                ArrayList<Future<List<DexProgramClass>>> futures = new ArrayList<Future<List<DexProgramClass>>>(this.nameToFileMap.size());
                usedPrefixes = this.packageDistribution.getFiles();
                for (VirtualFile file : this.nameToFileMap.values()) {
                    PackageMapPopulator populator = new PackageMapPopulator(file, classes, this.packageDistribution, originalNames);
                    futures.add(this.executorService.submit(populator));
                }
                ThreadUtils.awaitFutures(futures).forEach(classes::removeAll);
            }
            return usedPrefixes;
        }

        private void writeAssignments(Map<String, Integer> assignments, Writer output) throws IOException {
            for (Map.Entry<String, Integer> entry : assignments.entrySet()) {
                output.write("    ");
                PackageDistribution.formatEntry(entry, output);
                output.write("\n");
            }
            output.flush();
        }
    }

    public static class MonoDexDistributor
    extends DistributorBase {
        public MonoDexDistributor(ApplicationWriter writer) {
            super(writer);
        }

        @Override
        public Map<Integer, VirtualFile> run() throws ExecutionException, IOException {
            VirtualFile mainDexFile = new VirtualFile(0, this.writer.namingLens);
            this.nameToFileMap.put(0, mainDexFile);
            for (DexProgramClass programClass : this.classes) {
                mainDexFile.addClass(programClass);
                if (!mainDexFile.isFull()) continue;
                throw new CompilationError("Cannot fit all classes in a single dex file.");
            }
            mainDexFile.commitTransaction();
            return this.nameToFileMap;
        }
    }

    public static class FillFilesDistributor
    extends DistributorBase {
        private final FillStrategy fillStrategy;

        public FillFilesDistributor(ApplicationWriter writer, boolean minimalMainDex) {
            super(writer);
            this.fillStrategy = minimalMainDex ? FillStrategy.MINIMAL_MAIN_DEX : FillStrategy.FILL_MAX;
        }

        @Override
        public Map<Integer, VirtualFile> run() throws ExecutionException, IOException {
            this.nameToFileMap.put(0, new VirtualFile(0, this.writer.namingLens));
            this.fillForMainDexList(this.classes);
            this.classes = this.sortClassesByPackage(this.classes, this.originalNames);
            new PackageSplitPopulator(this.nameToFileMap, this.classes, this.originalNames, null, this.application.dexItemFactory, this.fillStrategy, this.writer.namingLens).call();
            return this.nameToFileMap;
        }
    }

    public static abstract class DistributorBase
    extends Distributor {
        protected Set<DexProgramClass> classes;
        protected Map<DexProgramClass, String> originalNames;

        public DistributorBase(ApplicationWriter writer) {
            super(writer);
            this.classes = Sets.newHashSet(this.application.classes());
            this.originalNames = VirtualFile.computeOriginalNameMapping(this.classes, this.application.getProguardMap());
        }

        protected void fillForMainDexList(Set<DexProgramClass> classes) {
            if (this.application.mainDexList != null) {
                VirtualFile mainDexFile = (VirtualFile)this.nameToFileMap.get(0);
                for (DexType type : this.application.mainDexList) {
                    DexClass clazz = this.application.definitionFor(type);
                    if (clazz != null && clazz.isProgramClass()) {
                        DexProgramClass programClass = (DexProgramClass)clazz;
                        mainDexFile.addClass(programClass);
                        if (mainDexFile.isFull()) {
                            throw new CompilationError("Cannot fit requested classes in main-dex file.");
                        }
                        classes.remove(programClass);
                    } else {
                        System.out.println("WARNING: Application does not contain `" + type.toSourceString() + "` as referenced in main-dex-list.");
                    }
                    mainDexFile.commitTransaction();
                }
            }
        }

        TreeSet<DexProgramClass> sortClassesByPackage(Set<DexProgramClass> classes, Map<DexProgramClass, String> originalNames) {
            TreeSet<DexProgramClass> sortedClasses = new TreeSet<DexProgramClass>((a, b) -> {
                String prefixB;
                String originalA = (String)originalNames.get(a);
                String originalB = (String)originalNames.get(b);
                int indexA = originalA.lastIndexOf(46);
                int indexB = originalB.lastIndexOf(46);
                if (indexA == -1 && indexB == -1) {
                    return originalA.compareTo(originalB);
                }
                if (indexA == -1) {
                    return -1;
                }
                if (indexB == -1) {
                    return 1;
                }
                String prefixA = originalA.substring(0, indexA);
                int result = prefixA.compareTo(prefixB = originalB.substring(0, indexB));
                if (result != 0) {
                    return result;
                }
                return originalA.compareTo(originalB);
            });
            sortedClasses.addAll(classes);
            return sortedClasses;
        }
    }

    public static class FilePerClassDistributor
    extends Distributor {
        public FilePerClassDistributor(ApplicationWriter writer) {
            super(writer);
        }

        @Override
        public Map<Integer, VirtualFile> run() throws ExecutionException, IOException {
            for (DexProgramClass clazz : this.application.classes()) {
                VirtualFile file = new VirtualFile(this.nameToFileMap.size(), this.writer.namingLens);
                this.nameToFileMap.put(this.nameToFileMap.size(), file);
                file.addClass(clazz);
                file.commitTransaction();
            }
            return this.nameToFileMap;
        }
    }

    public static abstract class Distributor {
        protected final DexApplication application;
        protected final ApplicationWriter writer;
        protected final Map<Integer, VirtualFile> nameToFileMap = new HashMap<Integer, VirtualFile>();

        public Distributor(ApplicationWriter writer) {
            this.application = writer.application;
            this.writer = writer;
        }

        public abstract Map<Integer, VirtualFile> run() throws ExecutionException, IOException;
    }

    static enum FillStrategy {
        MINIMAL_MAIN_DEX,
        FILL_MAX,
        LEAVE_SPACE_FOR_GROWTH;

    }
}

